/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.eclipse.epf.search.SearchPlugin;
import org.eclipse.epf.search.SearchResources;
import org.eclipse.epf.search.SearchServiceException;
import org.eclipse.epf.search.analysis.TextAnalyzer;
import org.eclipse.epf.search.utils.JarCreator;
import org.eclipse.epf.search.utils.LHTMLParser;
import org.eclipse.epf.search.utils.UNCUtil;

public class IndexBuilder {
    static final String VERSION_FILE_NAME = "version.txt";
    static final String VERSION_DELIMITER = "*";
    public static final String BRIEF_DESCRIPTION_FIELD = "briefDescription";
    public static final String CONTENT_FIELD = "contents";
    public static final String ID_FIELD = "id";
    public static final String MODIFIED_FIELD = "modified";
    public static final String NAME_FIELD = "name";
    public static final String ROLE_FIELD = "role";
    public static final String SUMMARY_FIELD = "summary";
    public static final String TYPE_FIELD = "type";
    public static final String URL_FIELD = "url";
    public static final String TITLE_FIELD = "title";
    public static final String UMA_ELEMENT_TYPE_FIELD = "uma.type";
    public static final String GENERAL_CONTENT = "general_content";
    private static List NO_SEARCHEABLE_UMA_ELEMENTS = new ArrayList();
    public static List dirsToSkip;
    public static String pDirectory;
    private StringBuffer indexFolder = null;
    private String productName = null;
    private List filesToSkip = new ArrayList();
    char[] cbuf = new char[1024];
    int skipCount = 0;

    static {
        NO_SEARCHEABLE_UMA_ELEMENTS.add(SUMMARY_FIELD);
        NO_SEARCHEABLE_UMA_ELEMENTS.add("workproductdescriptor");
        NO_SEARCHEABLE_UMA_ELEMENTS.add("taskdescriptor");
        NO_SEARCHEABLE_UMA_ELEMENTS.add("roledescriptor");
        dirsToSkip = new ArrayList();
        pDirectory = null;
    }

    public IndexBuilder(String publishDir) {
        int appletIndex = -1;
        if (publishDir == null) {
            return;
        }
        appletIndex = publishDir.indexOf(String.valueOf(File.separator) + "applet");
        pDirectory = UNCUtil.convertFilename(appletIndex > -1 ? publishDir.substring(0, appletIndex + 1) : publishDir);
        String siteName = pDirectory.replace(File.separatorChar, '/');
        int index = siteName.length();
        if (siteName.endsWith("/")) {
            --index;
        }
        int index2 = siteName.lastIndexOf("/", index - 1);
        this.productName = siteName.substring(index2 + 1, index);
        StringBuffer searchFolder = new StringBuffer(pDirectory);
        if (!searchFolder.toString().endsWith(File.separator)) {
            searchFolder.append(File.separator);
        }
        searchFolder.append("search");
        this.indexFolder = new StringBuffer(searchFolder.toString());
        this.indexFolder.append(File.separator).append("index");
        dirsToSkip.add(String.valueOf(pDirectory) + "applet");
        dirsToSkip.add(String.valueOf(pDirectory) + "css");
        dirsToSkip.add(String.valueOf(pDirectory) + "ext_help");
        dirsToSkip.add(String.valueOf(pDirectory) + "icons");
        dirsToSkip.add(String.valueOf(pDirectory) + "images");
        dirsToSkip.add(String.valueOf(pDirectory) + "index");
        dirsToSkip.add(String.valueOf(pDirectory) + "logs");
        dirsToSkip.add(String.valueOf(pDirectory) + "manuals");
        dirsToSkip.add(String.valueOf(pDirectory) + "noapplet");
        dirsToSkip.add(String.valueOf(pDirectory) + "pages_not_installed");
        dirsToSkip.add(String.valueOf(pDirectory) + "process");
        dirsToSkip.add(String.valueOf(pDirectory) + "scripts");
        dirsToSkip.add(String.valueOf(pDirectory) + "stylesheets");
        dirsToSkip.add(String.valueOf(pDirectory) + "xml");
        dirsToSkip.add(String.valueOf(pDirectory) + "search");
        this.filesToSkip.add("_desc.htm");
        this.filesToSkip.add("_wbs.htm");
        this.filesToSkip.add("_tbs.htm");
        this.filesToSkip.add("_wpbs.htm");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createIndex(boolean jarIt) throws SearchServiceException {
        Class<IndexBuilder> clazz = IndexBuilder.class;
        synchronized (IndexBuilder.class) {
            block19: {
                long milliseconds;
                Object analyzer;
                block18: {
                    if (this.indexFolder == null || pDirectory == null) {
                        throw new IllegalStateException("Invalid indexFolder or pDirectory");
                    }
                    boolean jako = false;
                    Locale locale = Locale.getDefault();
                    String lang = locale.getLanguage();
                    if (lang.equals(Locale.JAPANESE.getLanguage()) || lang.equals(Locale.KOREA.getLanguage())) {
                        jako = true;
                    }
                    analyzer = jako ? new CJKAnalyzer() : new TextAnalyzer();
                    try {
                        IndexWriter fsWriter = new IndexWriter((Directory)FSDirectory.getDirectory((String)this.indexFolder.toString(), (boolean)true), (Analyzer)analyzer, true);
                        if (fsWriter != null) {
                            fsWriter.setMaxFieldLength(1000000);
                            this.indexDocs(new File(pDirectory), fsWriter);
                            fsWriter.optimize();
                            fsWriter.close();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    Date today = new Date();
                    milliseconds = today.getTime();
                    if (jarIt) break block18;
                    try {
                        FileWriter fw = new FileWriter(this.indexFolder + File.separator + VERSION_FILE_NAME);
                        BufferedWriter bw = new BufferedWriter(fw);
                        bw.write(String.valueOf(this.productName) + VERSION_DELIMITER + milliseconds + "\n");
                        if (analyzer instanceof CJKAnalyzer) {
                            bw.write("CJKAnalyzer\n");
                        }
                        bw.close();
                        fw.close();
                    }
                    catch (IOException iOException) {
                        throw new SearchServiceException(SearchResources.createSearchIndexError);
                    }
                    return true;
                }
                JarCreator.jarFolder(this.indexFolder.toString());
                System.out.println("index Jarred successfully");
                try {
                    File indexDir = new File(this.indexFolder.toString());
                    File[] files = indexDir.listFiles();
                    int i = 0;
                    while (i < files.length) {
                        File tempFile = files[i];
                        if (!tempFile.getName().equals("index.jar")) {
                            tempFile.delete();
                        }
                        ++i;
                    }
                    File newIndexJar = new File(this.indexFolder + File.separator + "index.jar");
                    if (newIndexJar.exists()) {
                        String fileSize = "" + newIndexJar.length();
                        FileWriter fw = new FileWriter(this.indexFolder + File.separator + VERSION_FILE_NAME);
                        BufferedWriter bw = new BufferedWriter(fw);
                        bw.write(String.valueOf(this.productName) + VERSION_DELIMITER + milliseconds + VERSION_DELIMITER + fileSize + "\n");
                        if (analyzer instanceof CJKAnalyzer) {
                            bw.write("CJKAnalyzer\n");
                        }
                        bw.close();
                        fw.close();
                        break block19;
                    }
                    throw new SearchServiceException(SearchResources.createSearchIndexError);
                }
                catch (IOException iOException) {
                    throw new SearchServiceException(SearchResources.createSearchIndexError);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return true;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void indexDocs(File file, IndexWriter writer) throws Exception {
        if (dirsToSkip.contains(file.getAbsolutePath())) {
            return;
        }
        if (file.isFile()) {
            for (String fileToSkip : this.filesToSkip) {
                if (file.getName().indexOf(fileToSkip) <= -1) continue;
                return;
            }
        }
        if (file.isDirectory()) {
            String[] files = file.list();
            int i = 0;
            while (i < files.length) {
                this.indexDocs(new File(file, files[i]), writer);
                ++i;
            }
            return;
        } else {
            if (!IndexBuilder.isHtmlDoc(file)) return;
            if (this.shouldBeExcluded(file)) {
                return;
            }
            try {
                Document doc = this.getHTMLDocument(file);
                if (doc == null) return;
                writer.addDocument(doc);
                return;
            }
            catch (Exception e1) {
                System.out.println(file.getName());
                System.out.println("indexDocs");
                e1.printStackTrace();
            }
        }
    }

    private boolean shouldBeExcluded(File file) {
        String path = file.getParentFile().getAbsolutePath();
        return pDirectory.startsWith(path);
    }

    private static boolean isHtmlDoc(File file) {
        String path = file.getPath();
        return path.endsWith(".html") || path.endsWith(".htm");
    }

    private boolean isNoSearchableDocument(Properties metaTags) {
        String value = metaTags.getProperty(UMA_ELEMENT_TYPE_FIELD);
        return value != null && NO_SEARCHEABLE_UMA_ELEMENTS.contains(value);
    }

    /*
     * Unable to fully structure code
     */
    private Document getHTMLDocument(File file) {
        block24: {
            luceneDocument = null;
            input = null;
            reader = null;
            input = new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8");
            parser = new LHTMLParser(input);
            reader = parser.getReader();
            if (reader != null) break block24;
lbl9:
            // 3 sources

            while (true) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (Exception v0) {}
                }
                return null;
            }
        }
        try {
            try {
                block26: {
                    metaTags = parser.getMetaTags();
                    if (!this.isNoSearchableDocument(metaTags)) break block26;
                    while (reader.read(this.cbuf) > 0) {
                    }
                    parser = null;
                    ** GOTO lbl9
                }
                luceneDocument = new Document();
                url = file.getPath().replace(File.pathSeparatorChar, '/');
                luceneDocument.add(Field.UnIndexed((String)"url", (String)url));
                luceneDocument.add(Field.Text((String)"contents", (Reader)reader));
                title = parser.getTitle();
                if (title != null && title.length() > 0) ** break;
                ** continue;
                title = title.replaceAll("\\xa0", " ");
                luceneDocument.add(Field.Keyword((String)"title", (String)title));
                summary = parser.getSummary();
                if (summary.startsWith(title) && summary.length() > title.length()) {
                    luceneDocument.add(Field.Keyword((String)"summary", (String)summary.substring(title.length() + 1)));
                } else {
                    luceneDocument.add(Field.Keyword((String)"summary", (String)parser.getSummary()));
                }
                names = metaTags.propertyNames();
                while (names.hasMoreElements()) {
                    tagName = (String)names.nextElement();
                    if (tagName == null) continue;
                    if (tagName.equals("role")) {
                        roleName = metaTags.getProperty(tagName);
                        if (roleName == null) continue;
                        luceneDocument.add(Field.Text((String)tagName, (String)roleName));
                        continue;
                    }
                    tagValue = metaTags.getProperty(tagName);
                    if (tagValue == null) continue;
                    luceneDocument.add(Field.Text((String)tagName, (String)tagValue));
                }
                if (luceneDocument.getField("role") == null) {
                    luceneDocument.add(Field.Text((String)"role", (String)"NORUPROLE"));
                }
                if ((umaTypeField = luceneDocument.getField("uma.type")) == null) {
                    luceneDocument.add(Field.Text((String)"uma.type", (String)"general_content"));
                }
                parser = null;
            }
            catch (Exception e) {
                luceneDocument = null;
                SearchPlugin.getDefault().getLogger().logError((Throwable)e);
                if (input == null) ** GOTO lbl81
                try {
                    input.close();
                }
                catch (Exception v1) {}
            }
        }
        catch (Throwable var13_14) {
            if (input != null) {
                try {
                    input.close();
                }
                catch (Exception v2) {}
            }
            throw var13_14;
        }
        if (input != null) {
            try {
                input.close();
            }
            catch (Exception v3) {}
        }
lbl81:
        // 7 sources

        return luceneDocument;
    }
}

