/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.search.analysis;

import java.io.IOException;
import java.util.ResourceBundle;
import java.util.Set;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.eclipse.epf.common.utils.StrUtil;

public final class TextFilter
extends TokenFilter {
    private static Set stopWords = null;

    public TextFilter(TokenStream in) {
        super(in);
        if (stopWords == null) {
            this.loadStopWords();
        }
    }

    public final Token next() throws IOException {
        Token token = this.input.next();
        while (token != null) {
            String tokenText = token.termText();
            if (!stopWords.contains(tokenText)) {
                return token;
            }
            token = this.input.next();
        }
        return null;
    }

    private void loadStopWords() {
        String[] words = null;
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(String.valueOf(TextFilter.class.getPackage().getName()) + ".StopWords");
            String property = bundle.getString("Search.stopWords");
            words = StrUtil.split((String)property, (String)" ,");
        }
        catch (Exception exception) {
            words = StopAnalyzer.ENGLISH_STOP_WORDS;
        }
        stopWords = StopFilter.makeStopSet((String[])words);
    }
}

