/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.rcp.ui;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.common.service.utils.CommandLineRunUtil;
import org.eclipse.epf.library.ui.LibraryUIManager;
import org.eclipse.epf.rcp.ui.MainWorkbenchAdvisor;
import org.eclipse.epf.rcp.ui.RCPUIPlugin;
import org.eclipse.epf.rcp.ui.RCPUIResources;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.WorkbenchAdvisor;

public class MainApplication
implements IApplication {
    private static final String NONE = "@none";
    private static final String NO_DEFAULT = "@noDefault";
    private static final String USER_HOME = "@user.home";
    private static final String USER_DIR = "@user.dir";
    public static final String PROP_USER_HOME = "user.home";
    public static final String PROP_USER_DIR = "user.dir";

    public Object start(IApplicationContext context) {
        Display display = PlatformUI.createDisplay();
        Shell shell = new Shell(display, 16384);
        try {
            boolean noLock = false;
            String[] appArgs = Platform.getApplicationArgs();
            int i = 0;
            while (i < appArgs.length) {
                String location;
                if (appArgs[i].equalsIgnoreCase("-library") && i < appArgs.length - 1) {
                    location = appArgs[i + 1];
                    if ((location = this.buildLocation(location)) != null) {
                        LibraryUIManager.setCommandLineLibrary((String)location);
                    }
                } else if (appArgs[i].equalsIgnoreCase("-defaultlibrary") && i < appArgs.length - 1) {
                    location = appArgs[i + 1];
                    if ((location = this.buildLocation(location)) != null) {
                        LibraryUIManager.setCommandLineDefaultLibrary((String)location);
                    }
                } else if (appArgs[i].equalsIgnoreCase("-nolock")) {
                    noLock = true;
                } else if (appArgs[i].equalsIgnoreCase("-batch")) {
                    CommandLineRunUtil.getInstance().setNeedToRun(true);
                }
                ++i;
            }
            if (!noLock && !this.checkWorkspaceLock(shell)) {
                Platform.endSplash();
                Integer n = IApplication.EXIT_OK;
                return n;
            }
            int returnCode = this.createWorkbenchAdvisor(display);
            if (returnCode == 1) {
                Integer n = IApplication.EXIT_RESTART;
                return n;
            }
            Integer n = IApplication.EXIT_OK;
            return n;
        }
        finally {
            if (shell != null) {
                shell.dispose();
            }
            display.dispose();
        }
    }

    public void stop() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return;
        }
        final Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (!display.isDisposed()) {
                    workbench.close();
                }
            }
        });
    }

    protected int createWorkbenchAdvisor(Display display) {
        return PlatformUI.createAndRunWorkbench((Display)display, (WorkbenchAdvisor)new MainWorkbenchAdvisor());
    }

    protected boolean checkWorkspaceLock(Shell shell) {
        String appName;
        block3: {
            Location workspaceLocation = Platform.getInstanceLocation();
            appName = Platform.getProduct().getName();
            if (!workspaceLocation.lock()) break block3;
            return true;
        }
        try {
            MessageDialog.openInformation((Shell)shell, (String)NLS.bind((String)RCPUIResources.workspaceCannotLockTitle, (Object)appName), (String)NLS.bind((String)RCPUIResources.workspaceCannotLockMessage, (Object)appName));
        }
        catch (IOException e) {
            RCPUIPlugin.getDefault().getLogger().logError(NLS.bind((String)RCPUIResources.workspaceCannotLockMessage, (Object)appName), (Throwable)e);
            MessageDialog.openInformation((Shell)shell, (String)NLS.bind((String)RCPUIResources.workspaceCannotLockTitle, (Object)appName), (String)e.getMessage());
        }
        return false;
    }

    private String buildLocation(String location) {
        String trimmedLocation;
        String result = trimmedLocation = location.trim();
        if (trimmedLocation.equalsIgnoreCase(NONE)) {
            return null;
        }
        if (trimmedLocation.equalsIgnoreCase(NO_DEFAULT)) {
            return null;
        }
        if (trimmedLocation.startsWith(USER_HOME)) {
            String base = MainApplication.substituteVar(location, USER_HOME, PROP_USER_HOME);
            result = new File(base).getAbsolutePath();
        } else if (trimmedLocation.startsWith(USER_DIR)) {
            String base = MainApplication.substituteVar(location, USER_DIR, PROP_USER_DIR);
            result = new File(base).getAbsolutePath();
        }
        return result;
    }

    private static String substituteVar(String source, String var, String prop) {
        String value = System.getProperty(prop, "");
        return String.valueOf(value) + source.substring(var.length());
    }
}

