/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.dialogs;

import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.wizards.DirectoryValidator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PathSelectionDialog
extends Dialog {
    protected Text ctrl_path;
    protected Button ctrl_browse_button;
    protected String title;
    protected String message;
    protected String value;

    public PathSelectionDialog(Shell parentShell, String dialogTitle, String dialogMessage, String defaultPath) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = defaultPath;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.value = this.ctrl_path.getText();
            String msg = LibraryUIResources.pathSelectionError_msg;
            if (!DirectoryValidator.checkAndCreateDir(this.value, this.title, msg)) {
                return;
            }
        } else {
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.ctrl_path.setFocus();
        if (this.value != null) {
            this.ctrl_path.setText(this.value);
            this.ctrl_path.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.ctrl_path = new Text(composite, 2052);
        this.ctrl_path.setLayoutData((Object)new GridData(768));
        this.ctrl_browse_button = new Button(composite, 0);
        this.ctrl_browse_button.setLayoutData((Object)new GridData(128));
        this.ctrl_browse_button.setText(LibraryUIResources.browseButton_text);
        this.ctrl_browse_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PathSelectionDialog.this.openDirectoryDialog();
            }
        });
        PathSelectionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void openDirectoryDialog() {
        try {
            DirectoryDialog dd = new DirectoryDialog(this.getShell(), 0);
            dd.setFilterPath(this.ctrl_path.getText());
            String destination = dd.open();
            if (destination != null) {
                this.ctrl_path.setText(destination);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getPath() {
        return this.value;
    }
}

