/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.util.ExtensionManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NestedCommandExcecutor {
    private Command command;
    private ArrayList<Command> nestedCommands;

    public NestedCommandExcecutor(Command command) {
        this.command = command;
    }

    public List<Command> getNestedCommands() {
        if (this.nestedCommands == null) {
            this.nestedCommands = new ArrayList();
        }
        return this.nestedCommands;
    }

    public void executeNestedCommands() {
        List<INestedCommandProvider> nestedCommandProviders = ExtensionManager.getNestedCommandProviders();
        if (!nestedCommandProviders.isEmpty()) {
            for (INestedCommandProvider cmdProvider : nestedCommandProviders) {
                try {
                    Command cmd = cmdProvider.createNestedCommand(this.command);
                    if (cmd == null || !cmd.canExecute()) continue;
                    cmd.execute();
                    this.getNestedCommands().add(cmd);
                }
                catch (Exception e) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
    }

    public void undoNestedCommands() {
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int i = this.nestedCommands.size() - 1;
            while (i > -1) {
                block14: {
                    Command cmd = this.nestedCommands.get(i);
                    try {
                        try {
                            if (cmd.canUndo()) {
                                cmd.undo();
                            }
                        }
                        catch (Exception e) {
                            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                            try {
                                cmd.dispose();
                            }
                            catch (Exception exception) {}
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            cmd.dispose();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        cmd.dispose();
                    }
                    catch (Exception exception) {}
                }
                --i;
            }
            this.nestedCommands.clear();
        }
    }

    public void dispose() {
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int i = this.nestedCommands.size() - 1;
            while (i > -1) {
                Command cmd = this.nestedCommands.get(i);
                try {
                    cmd.dispose();
                }
                catch (Exception exception) {}
                --i;
            }
            this.nestedCommands.clear();
        }
    }

    public Collection<Resource> getModifiedResources() {
        HashSet<Resource> modifiedResources = new HashSet<Resource>();
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int i = this.nestedCommands.size() - 1;
            while (i > -1) {
                Command cmd = this.nestedCommands.get(i);
                if (cmd instanceof IResourceAwareCommand) {
                    try {
                        Collection<Resource> resources = ((IResourceAwareCommand)cmd).getModifiedResources();
                        if (resources != null) {
                            modifiedResources.addAll(resources);
                        }
                    }
                    catch (Exception e) {
                        LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                }
                --i;
            }
        }
        return modifiedResources.isEmpty() ? Collections.EMPTY_SET : modifiedResources;
    }
}

