/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.VariabilityElement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyHelper
extends CopyCommand.Helper {
    private static final long serialVersionUID = 5264389393955639004L;
    private Map copyToOriginalMap = new HashMap();
    private Map baseToVariabilityElementMap = new HashMap();
    private Map baseToBackupVariabilityElementMap = new HashMap();
    private Map<String, BreakdownElement> wrapperPathToCopyMap = new HashMap<String, BreakdownElement>();

    public void clear() {
        super.clear();
        this.copyToOriginalMap.clear();
        this.baseToBackupVariabilityElementMap.clear();
        this.baseToVariabilityElementMap.clear();
        this.wrapperPathToCopyMap.clear();
    }

    public Object getOriginal(Object copy) {
        return this.copyToOriginalMap.get(copy);
    }

    public Object putVariabilityElement(VariabilityElement base, VariabilityElement ve) {
        return this.baseToVariabilityElementMap.put(base, ve);
    }

    public Object removeVariabilityElement(VariabilityElement base) {
        return this.baseToVariabilityElementMap.remove(base);
    }

    public Object putBackupCopy(VariabilityElement base, VariabilityElement backup) {
        return this.baseToBackupVariabilityElementMap.put(base, backup);
    }

    public EObject put(EObject key, EObject value) {
        this.copyToOriginalMap.put(value, key);
        return super.put(key, value);
    }

    public Object basicPut(EObject key, EObject value) {
        EObject old = super.put(key, value);
        this.initializationList.remove(key);
        return old;
    }

    public EObject getCopy(EObject object) {
        Object ve;
        Object ve2;
        if (object instanceof VariabilityElement && (ve2 = CopyHelper.getVariabilityElement(this.baseToVariabilityElementMap, object)) != null) {
            return super.getCopy((EObject)ve2);
        }
        EObject copy = super.getCopy(object);
        if (copy == null && (ve = CopyHelper.getVariabilityElement(this.baseToBackupVariabilityElementMap, object)) != null) {
            return super.getCopy((EObject)ve);
        }
        return copy;
    }

    private static Object getVariabilityElement(Map baseToVariabilityElementMap, Object base) {
        Object ve = null;
        do {
            if ((base = baseToVariabilityElementMap.get(base)) == null) continue;
            ve = base;
        } while (base != null);
        return ve;
    }

    public EObject getCopyTarget(EObject target, boolean copyRequired) {
        if (copyRequired) {
            return super.getCopy(target);
        }
        EObject copied = this.getCopy(target);
        if (copied == null) {
            return target;
        }
        return copied;
    }

    public Map getObjectToCopyMap() {
        HashSet objects = new HashSet(this.baseToBackupVariabilityElementMap.keySet());
        objects.addAll(this.baseToVariabilityElementMap.keySet());
        objects.addAll(this.keySet());
        HashMap map = new HashMap();
        for (Object object : objects) {
            map.put(object, this.getCopy((EObject)object));
        }
        return map;
    }

    public void putWrapperCopy(String guidPath, BreakdownElement e) {
        this.wrapperPathToCopyMap.put(guidPath, e);
    }

    public BreakdownElement getWrapperCopy(String guidPath) {
        return this.wrapperPathToCopyMap.get(guidPath);
    }

    public Map<String, BreakdownElement> getWrapperPathToCopyMap() {
        return this.wrapperPathToCopyMap;
    }
}

