/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.NestedCommandExcecutor;
import org.eclipse.epf.library.edit.process.command.ActivityDeepCopyCommand;
import org.eclipse.epf.library.edit.process.command.CopyHelper;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDeepCopyCommand
extends ActivityDeepCopyCommand {
    private ProcessPackage targetPackage;
    private ProcessComponent tempPc;
    private String newProcessName;
    private NestedCommandExcecutor nestedCommandExecutor;

    public ProcessDeepCopyCommand(Process process, String newProcessName, CopyHelper copyHelper, MethodConfiguration config, ProcessPackage targetPackage, IProgressMonitor monitor, IConfigurator configurator) {
        super((Activity)process, copyHelper, config, (Process)null, monitor, configurator);
        this.newProcessName = newProcessName;
        this.targetPackage = targetPackage;
        this.createtargetProcess();
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.config;
    }

    public Process getTargetProcess() {
        return this.targetProcess;
    }

    public Process getSourceProcess() {
        return (Process)this.activity;
    }

    private void createtargetProcess() {
        this.tempPc = UmaFactory.eINSTANCE.createProcessComponent();
        this.targetPackage.getChildPackages().add(this.tempPc);
        this.targetProcess = this.activity instanceof DeliveryProcess ? UmaFactory.eINSTANCE.createDeliveryProcess() : UmaFactory.eINSTANCE.createCapabilityPattern();
        this.targetProcess.setName(this.newProcessName);
        this.targetProcess.setPresentationName(this.newProcessName);
        this.tempPc.setName(this.newProcessName);
        this.tempPc.setProcess(this.targetProcess);
    }

    public void dispose() {
        if (this.nestedCommandExecutor != null) {
            this.nestedCommandExecutor.dispose();
        }
        super.dispose();
    }

    @Override
    public void execute() {
        super.execute();
        if (this.pkgCopy != null && this.pkgCopy instanceof ProcessComponent) {
            ILibraryPersister.FailSafeMethodLibraryPersister persister = Services.getDefaultLibraryPersister().getFailSafePersister();
            try {
                persister.save(this.pkgCopy.eResource());
                persister.commit();
            }
            catch (Exception e) {
                LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                try {
                    persister.rollback();
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
        if (this.nestedCommandExecutor != null) {
            this.nestedCommandExecutor.executeNestedCommands();
        }
    }

    public void undo() {
        if (this.nestedCommandExecutor != null) {
            this.nestedCommandExecutor.undoNestedCommands();
        }
        super.undo();
    }

    @Override
    protected void fixProcessComponent() {
        if (this.pkgCopy instanceof ProcessComponent) {
            this.pkgCopy.setName(this.newProcessName);
            Process proc = ((ProcessComponent)this.pkgCopy).getProcess();
            proc.setName(this.newProcessName);
            proc.setPresentationName(this.newProcessName);
            this.targetProcess = proc;
            EcoreUtil.replace((EObject)this.tempPc, (EObject)this.pkgCopy);
        }
    }

    @Override
    public Collection<?> getResult() {
        if (this.pkgCopy != null && this.pkgCopy instanceof ProcessComponent) {
            return Collections.singletonList(((ProcessComponent)this.pkgCopy).getProcess());
        }
        return Collections.EMPTY_LIST;
    }
}

