/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;

public abstract class VaryActivityCommand
extends AbstractCommand
implements IResourceAwareCommand {
    protected BreakdownElementWrapperItemProvider wrapper;
    private Process proc;
    protected List createdActivities;
    public Activity superActivity;

    public VaryActivityCommand(BreakdownElementWrapperItemProvider wrapper) {
        this.wrapper = wrapper;
        this.proc = (Process)wrapper.getTopItem();
    }

    public BreakdownElementWrapperItemProvider getWrapper() {
        return this.wrapper;
    }

    public Collection getModifiedResources() {
        if (this.proc.eResource() != null) {
            return Collections.singletonList(this.proc.eResource());
        }
        return Collections.EMPTY_LIST;
    }

    protected boolean prepare() {
        return true;
    }

    public void execute() {
        if (this.createdActivities == null) {
            this.createdActivities = new ArrayList();
        } else {
            this.createdActivities.clear();
        }
        this.doVary();
        List listeners = Providers.getCommandListeners(VaryActivityCommand.class);
        if (listeners != null) {
            for (ICommandListener listener : listeners) {
                listener.notifyExecuted(this);
            }
        }
    }

    protected abstract void doVary();

    public void redo() {
        Object owner = this.wrapper.getOwner();
        ITreeItemContentProvider ip = (ITreeItemContentProvider)this.wrapper.getAdapterFactory().adapt(owner, ITreeItemContentProvider.class);
        for (Object child : ip.getChildren(owner)) {
            if (!(child instanceof BreakdownElementWrapperItemProvider) || ((BreakdownElementWrapperItemProvider)child).getValue() != this.wrapper.getValue()) continue;
            this.wrapper = (BreakdownElementWrapperItemProvider)child;
            break;
        }
        this.execute();
    }

    public void undo() {
        List listeners = Providers.getCommandListeners(VaryActivityCommand.class);
        if (listeners != null) {
            for (ICommandListener listener : listeners) {
                listener.preUndo(this);
            }
        }
        if (!this.createdActivities.isEmpty()) {
            this.restoreOrder();
            Activity act = (Activity)this.createdActivities.get(0);
            this.superActivity = act.getSuperActivities();
            act.setSuperActivities(null);
            this.createdActivities.clear();
        }
        if (listeners != null) {
            for (ICommandListener listener : listeners) {
                listener.postUndo(this);
            }
        }
    }

    protected void restoreOrder() {
        BreakdownElement next;
        Activity variedAct = (Activity)this.createdActivities.get(this.createdActivities.size() - 1);
        BreakdownElement be = (BreakdownElement)TngUtil.unwrap(this.wrapper);
        BreakdownElement prev = variedAct.getPresentedBefore();
        if (prev != null && this.proc == TngUtil.getOwningProcess(prev)) {
            prev.setPresentedAfter(be);
        }
        if ((next = variedAct.getPresentedAfter()) != null && this.proc == TngUtil.getOwningProcess(next)) {
            next.setPresentedBefore(be);
        }
    }

    public Collection getResult() {
        return this.createdActivities;
    }
}

