/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.CircularDependencyCheck;
import org.eclipse.epf.library.edit.validation.CircularDependencyCheckFilter;
import org.eclipse.epf.library.edit.validation.DependencyInfoMgr;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public final class DependencyChecker {
    private static final IStatus ERROR_STATUS = new Status(4, LibraryEditPlugin.getDefault().getId(), 0, "", null);
    public static boolean newCheck = true;
    public static boolean newCheckAct = true;

    public static IStatus checkCircularDependency(EObject owner, final EStructuralFeature feature, Object value) {
        if (feature == UmaPackage.Literals.ACTIVITY__BREAKDOWN_ELEMENTS) {
            if (value instanceof Activity) {
                Activity activity = (Activity)owner;
                VariabilityType type = activity.getVariabilityType();
                return DependencyChecker.checkCircularDependency(activity, (Activity)value, type);
            }
        } else if (feature == UmaPackage.Literals.VARIABILITY_ELEMENT__VARIABILITY_BASED_ON_ELEMENT) {
            if (DependencyChecker.isCircularDependency((VariabilityElement)owner, (VariabilityElement)value)) {
                return ERROR_STATUS;
            }
        } else if (feature == UmaPackage.Literals.DELIVERABLE__DELIVERED_WORK_PRODUCTS) {
            if (!DependencyChecker.checkCircularDeliverables((Deliverable)value, (Deliverable)owner)) {
                return ERROR_STATUS;
            }
        } else if (feature.isMany()) {
            AbstractTreeIterator iter = new AbstractTreeIterator(value){
                private static final long serialVersionUID = 0L;

                protected Iterator getChildren(Object object) {
                    EObject eObject;
                    List list;
                    if (feature.getContainerClass().isInstance(object) && !(list = (List)(eObject = (EObject)object).eGet(feature)).isEmpty()) {
                        ArrayList children = new ArrayList();
                        for (Object element : list) {
                            if (!feature.getContainerClass().isInstance(element)) continue;
                            children.add(element);
                        }
                        return children.iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
            };
            while (iter.hasNext()) {
                if (iter.next() != owner) continue;
                return ERROR_STATUS;
            }
        } else if (feature.getContainerClass().isInstance(value)) {
            Object o;
            Object v = (EObject)value;
            do {
                if (v == owner) {
                    return ERROR_STATUS;
                }
                o = v.eGet(feature);
            } while ((v = feature.getContainerClass().isInstance(o) ? (EObject)o : null) != null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkCircularDependency(Activity activity, Activity target) {
        if (DependencyChecker.isParent(activity, (BreakdownElement)target)) {
            Object[] args = new Object[]{target.getName()};
            String message = NLS.bind((String)LibraryEditResources.activity_variability_error_msg1, (Object[])args);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
        }
        Process process = TngUtil.getOwningProcess((BreakdownElement)target);
        if (!newCheckAct && DependencyChecker.hasCyclicDependency(activity, process) || newCheckAct && DependencyChecker.sourceReachableByTarget((VariabilityElement)activity, (VariabilityElement)target)) {
            Object[] args = new Object[]{activity.getName(), process.getName()};
            String message = NLS.bind((String)LibraryEditResources.apply_pattern_error_msg, (Object[])args);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
        }
        if (ProcessUtil.hasContributorOrReplacer(activity)) {
            Object[] args = new Object[]{activity.getName(), process.getName()};
            String message = NLS.bind((String)LibraryEditResources.apply_pattern_error_msg1, (Object[])args);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
        }
        return Status.OK_STATUS;
    }

    private static boolean hasCyclicDependency(Activity activity, Process process) {
        AbstractTreeIterator iter = new AbstractTreeIterator(activity){
            private static final long serialVersionUID = 0L;

            protected Iterator getChildren(Object object) {
                if (object instanceof Activity) {
                    ArrayList children = new ArrayList();
                    for (Object element : ((Activity)object).getBreakdownElements()) {
                        if (!(element instanceof VariabilityElement)) continue;
                        children.add(element);
                    }
                    return children.iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (iter.hasNext()) {
            Process proc;
            VariabilityElement ve = (VariabilityElement)iter.next();
            VariabilityElement base = ve.getVariabilityBasedOnElement();
            VariabilityType vType = ve.getVariabilityType();
            if (base == null || vType != VariabilityType.EXTENDS || (proc = TngUtil.getOwningProcess((BreakdownElement)base)) != process) continue;
            return true;
        }
        return false;
    }

    public static boolean isParent(Activity parent, BreakdownElement child) {
        Activity act = child.getSuperActivities();
        while (act != null) {
            if (act == parent) {
                return true;
            }
            act = act.getSuperActivities();
        }
        return false;
    }

    public static IStatus checkCircularDependency(Activity act, Activity base, VariabilityType type) {
        return DependencyChecker.checkCircularDependency(act, base, type, false);
    }

    public static IStatus checkCircularDependencyAfterFilterSelection(Activity act, Activity base, VariabilityType type) {
        return DependencyChecker.checkCircularDependency(act, base, type, true);
    }

    private static IStatus checkCircularDependency(Activity act, Activity base, VariabilityType type, boolean filtering) {
        if (base instanceof Process && type == VariabilityType.REPLACES && !(act instanceof Process)) {
            String message = LibraryEditResources.activity_variability_error_msg3;
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
        }
        if (DependencyChecker.isParent(base, (BreakdownElement)act)) {
            Object[] args = new Object[]{act.getName()};
            String message = NLS.bind((String)LibraryEditResources.activity_variability_error_msg1, (Object[])args);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
        }
        if (newCheckAct && filtering) {
            IFilter filter = DependencyChecker.getCircularDependencyCheckFilter((VariabilityElement)act);
            if (!filter.accept(base)) {
                Object[] args = new Object[]{act.getName(), base.getName()};
                String message = NLS.bind((String)LibraryEditResources.activity_variability_error_msg2, (Object[])args);
                return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
            }
            return Status.OK_STATUS;
        }
        if (DependencyChecker.isCircularDependency((VariabilityElement)act, (VariabilityElement)base)) {
            Object[] args = new Object[]{act.getName(), base.getName()};
            String message = NLS.bind((String)LibraryEditResources.activity_variability_error_msg2, (Object[])args);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
        }
        if (ProcessUtil.hasContributorOrReplacer(base) && type == VariabilityType.EXTENDS) {
            Object[] args = new Object[]{act.getName(), base.getName()};
            String message = NLS.bind((String)LibraryEditResources.activity_variability_error_msg, (Object[])args);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
        }
        Process process = TngUtil.getOwningProcess((BreakdownElement)act);
        if (process != null && DependencyChecker.hasCyclicDependency(base, process)) {
            Object[] args = new Object[]{act.getName(), base.getName()};
            String message = NLS.bind((String)LibraryEditResources.activity_variability_error_msg2, (Object[])args);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
        }
        return Status.OK_STATUS;
    }

    private static boolean isCircularDependency(VariabilityElement element, VariabilityElement base) {
        VariabilityType type = base.getVariabilityType();
        while (type != VariabilityType.NA) {
            VariabilityElement ve = base.getVariabilityBasedOnElement();
            if (ve != null && ve == element) {
                return true;
            }
            base = ve;
            type = ve.getVariabilityType();
        }
        return false;
    }

    public static boolean checkCircularDeliverables(Deliverable toBePart, Deliverable deliverable) {
        if (newCheck) {
            return !DependencyChecker.sourceReachableByTarget((VariabilityElement)toBePart, (VariabilityElement)deliverable);
        }
        if (toBePart == deliverable) {
            return false;
        }
        List deliverables = toBePart.getDeliveredWorkProducts();
        if (deliverables != null && deliverables.size() > 0) {
            if (deliverables.contains(deliverable)) {
                return false;
            }
            for (Object obj : deliverables) {
                if (!(obj instanceof Deliverable)) continue;
                return DependencyChecker.checkCircularDeliverables((Deliverable)obj, deliverable);
            }
        }
        return true;
    }

    public static boolean isAncessorOf(CustomCategory cc, DescribableElement e) {
        AbstractTreeIterator iter = new AbstractTreeIterator(cc, false){
            private static final long serialVersionUID = 1L;

            protected Iterator getChildren(Object object) {
                if (object instanceof CustomCategory) {
                    return ((CustomCategory)object).getCategorizedElements().iterator();
                }
                return Collections.EMPTY_LIST.iterator();
            }
        };
        while (iter.hasNext()) {
            if (iter.next() != e) continue;
            return true;
        }
        return false;
    }

    public static boolean checkCircularForArtifacts(Artifact destination, Collection sourceElements) {
        HashSet variantSet = new HashSet();
        DependencyChecker.collectVariantSet(destination, variantSet, VariabilityType.REPLACES);
        DependencyChecker.collectVariantSet(destination, variantSet, VariabilityType.EXTENDS);
        if (!DependencyChecker.checkCircularForArtifacts1(destination, sourceElements, variantSet)) {
            return false;
        }
        return DependencyChecker.checkCircularForArtifacts2(destination, sourceElements);
    }

    private static boolean checkCircularForArtifacts1(Artifact destination, Collection sourceElements, HashSet variantSet) {
        if (sourceElements == null) {
            return true;
        }
        for (Object obj : sourceElements) {
            if (!(obj instanceof Artifact)) continue;
            Artifact artifact = (Artifact)obj;
            if (variantSet.contains(artifact)) {
                return false;
            }
            if (DependencyChecker.checkCircularForArtifacts1(destination, artifact.getContainedArtifacts(), variantSet)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkCircularForArtifacts2(Artifact destination, Collection sourceElements) {
        for (Object obj : sourceElements) {
            if (!(obj instanceof Artifact) || !DependencyChecker.sourceIsOrAboveMe((Artifact)obj, destination)) continue;
            return false;
        }
        return true;
    }

    private static boolean sourceIsOrAboveMe(Artifact source, Artifact me) {
        if (source == me) {
            return true;
        }
        Artifact obj = me.getContainerArtifact();
        if (obj instanceof Artifact && DependencyChecker.sourceIsOrAboveMe(source, obj)) {
            return true;
        }
        obj = me.getVariabilityBasedOnElement();
        return obj instanceof Artifact && DependencyChecker.sourceIsOrAboveMe(source, obj);
    }

    private static void collectVariantSet(Artifact a, HashSet variantSet, VariabilityType type) {
        while (a != null) {
            Iterator iter = TngUtil.getGeneralizers((VariabilityElement)a, type);
            while (iter.hasNext()) {
                variantSet.add(iter.next());
            }
            a = a.getContainerArtifact();
        }
    }

    private static CircularDependencyCheck getCircularDependencyCheck(VariabilityElement ve, boolean filter, boolean move, boolean dnd) {
        MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)ve);
        DependencyInfoMgr depInfoMgr = new DependencyInfoMgr(lib);
        depInfoMgr.setDndBit(dnd);
        return new CircularDependencyCheck(depInfoMgr, ve, filter, move || dnd);
    }

    private static boolean sourceReachableByTarget(VariabilityElement source, VariabilityElement target) {
        return DependencyChecker.getCircularDependencyCheck(source, false, false, false).reachableBy(target);
    }

    public static IFilter getCircularDependencyCheckFilter(VariabilityElement ve) {
        MethodLibrary lib = UmaUtil.getMethodLibrary((EObject)ve);
        DependencyInfoMgr depInfoMgr = new DependencyInfoMgr(lib);
        return new CircularDependencyCheckFilter(depInfoMgr, ve);
    }

    public static boolean checkCircularForMovingVariabilityElement(VariabilityElement destination, Collection sourceElements) {
        return DependencyChecker.checkCircularForMovingVariabilityElement(destination, sourceElements, false);
    }

    public static boolean checkCircularForMovingVariabilityElement(VariabilityElement destination, Collection sourceElements, boolean dnd) {
        if (!DependencyInfoMgr.VeToCheck(destination)) {
            return true;
        }
        CircularDependencyCheck check = DependencyChecker.getCircularDependencyCheck(destination, false, true, dnd);
        Iterator it = sourceElements.iterator();
        while (it.hasNext()) {
            if (check.accept(it.next())) continue;
            return false;
        }
        return true;
    }

    public static IStatus checkCircularForApplyingVariabilityElement(VariabilityElement base, VariabilityElement ve, boolean dnd) {
        boolean ok = DependencyChecker.checkCircularForMovingVariabilityElement(base, Collections.singletonList(ve), true);
        if (!ok) {
            Object[] args = new Object[]{ve.getName(), base.getName()};
            String message = NLS.bind((String)LibraryEditResources.variability_error_msg, (Object[])args);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
        }
        return Status.OK_STATUS;
    }

    public static IStatus checkCircularDependencyAfterFilterSelection(VariabilityElement ve, VariabilityElement base) {
        IFilter filter = DependencyChecker.getCircularDependencyCheckFilter(ve);
        if (!filter.accept(base)) {
            Object[] args = new Object[]{ve.getName(), base.getName()};
            String message = NLS.bind((String)LibraryEditResources.variability_error_msg, (Object[])args);
            return new Status(4, LibraryEditPlugin.getDefault().getId(), 0, message, null);
        }
        return Status.OK_STATUS;
    }
}

