/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ui.viewer;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.SWTGraphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.epf.diagram.core.figures.WidenedWrapLabel;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.diagram.DiagramInfo;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.Process;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public abstract class AbstractDiagramGraphicalViewer {
    protected Composite parent;
    protected GraphicalViewer graphicalViewer;
    protected Object wrapper;

    public AbstractDiagramGraphicalViewer(Composite parent) {
        this.parent = parent;
        this.createGraphicalViewer();
    }

    public AbstractDiagramGraphicalViewer(Composite parent, Object wrapper) {
        this.parent = parent;
        this.wrapper = wrapper;
        this.createGraphicalViewer();
    }

    protected void createGraphicalViewer() {
        this.graphicalViewer = new ScrollingGraphicalViewer();
        this.graphicalViewer.createControl(this.parent);
        this.configureGraphicalViewer();
    }

    public GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected void configureGraphicalViewer() {
        this.getGraphicalViewer().getControl().setBackground(ColorConstants.listBackground);
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart();
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory(this.createEditPartFactory());
    }

    protected IFigure getFigure() {
        GraphicalViewer viewer = this.getGraphicalViewer();
        LayerManager lm = (LayerManager)viewer.getEditPartRegistry().get(LayerManager.ID);
        IFigure figure = lm.getLayer((Object)"Printable Layers");
        return figure;
    }

    protected void setSuppressionToDiagram(Diagram diagram) {
        Process proc;
        Object e = diagram.getObject();
        if (e instanceof BreakdownElement && (proc = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)e))) != null) {
            diagram.setSuppression(Suppression.getSuppression((Process)proc));
        }
    }

    public Image createDiagramImage() {
        IFigure figure = this.getFigure();
        IFigure borderItemAwareFreeFormLayer = (IFigure)figure.getChildren().get(0);
        IFigure tempFigure = (IFigure)borderItemAwareFreeFormLayer.getChildren().get(0);
        List defaultSizeNodeFigureList = null;
        if (tempFigure != null) {
            defaultSizeNodeFigureList = tempFigure.getChildren();
        }
        int i = 0;
        while (i < defaultSizeNodeFigureList.size()) {
            List children;
            IFigure activityNodeFigure = null;
            if (defaultSizeNodeFigureList.get(i) != null) {
                activityNodeFigure = (IFigure)((IFigure)defaultSizeNodeFigureList.get(i)).getChildren().get(0);
            }
            IFigure widenedWrapLabel = null;
            if (activityNodeFigure != null && (children = activityNodeFigure.getChildren()) != null && !children.isEmpty() && (widenedWrapLabel = (IFigure)activityNodeFigure.getChildren().get(0)) instanceof WidenedWrapLabel) {
                widenedWrapLabel.setForegroundColor(new Color(null, 0, 0, 0));
            }
            ++i;
        }
        SWTGraphics graphics = null;
        GC gc = null;
        Image image = null;
        try {
            try {
                Rectangle bounds = figure.getBounds();
                int height = bounds.height;
                int width = bounds.width;
                Display display = Display.getDefault();
                image = new Image((Device)display, width, height);
                gc = new GC((Drawable)image);
                graphics = new SWTGraphics(gc);
                figure.paint((Graphics)graphics);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                if (graphics != null) {
                    graphics.dispose();
                }
                if (gc != null) {
                    gc.dispose();
                }
            }
        }
        finally {
            if (graphics != null) {
                graphics.dispose();
            }
            if (gc != null) {
                gc.dispose();
            }
        }
        return image;
    }

    public void dispose() {
        try {
            if (this.graphicalViewer != null) {
                EditPart editPart;
                Control ctrl = this.graphicalViewer.getControl();
                if (ctrl != null) {
                    ctrl.dispose();
                }
                if ((editPart = this.graphicalViewer.getContents()) != null) {
                    editPart.setModel(null);
                }
                this.graphicalViewer = null;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    protected abstract EditPartFactory createEditPartFactory();

    protected abstract EditPart createEditPart(Object var1, IFilter var2, Suppression var3);

    protected abstract String getDiagramType();

    protected void cleanUpDiagram() {
    }

    public abstract DiagramInfo getDiagramInfo();

    public abstract EditPart loadDiagram(Object var1, boolean var2, IFilter var3, Suppression var4);

    public abstract void setMethodConfiguration(MethodConfiguration var1);
}

