/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.epf.common.service.utils.CommandLineRunUtil;
import org.eclipse.epf.library.ConfigurationAlreadyExistsException;
import org.eclipse.epf.library.ConfigurationManager;
import org.eclipse.epf.library.CreateLibraryManagerException;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryManagerFactory;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryServiceException;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.preferences.LibraryPreferences;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryProblemMonitor;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.UmaFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryService
implements ILibraryService {
    protected static final int EVENT_CREATE_LIBRARY = 1;
    protected static final int EVENT_OPEN_LIBRARY = 2;
    protected static final int EVENT_REOPEN_LIBRARY = 3;
    protected static final int EVENT_CLOSE_LIBRARY = 4;
    protected static final int EVENT_SET_CURRENT_LIBRARY = 5;
    protected static final int EVENT_SET_CURRENT_CONFIGURATION = 6;
    protected static ILibraryService instance;
    protected Map<MethodLibrary, ILibraryManager> libraryManagers = new HashMap<MethodLibrary, ILibraryManager>();
    protected Map<MethodConfiguration, IConfigurationManager> configManagers = new HashMap<MethodConfiguration, IConfigurationManager>();
    protected List<ILibraryServiceListener> listeners = new ArrayList<ILibraryServiceListener>();
    protected MethodLibrary currentLibrary;
    protected MethodConfiguration currentConfig;
    private boolean closingCurrentLibrary;
    private LibraryProblemMonitor libraryProblemMonitor;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ILibraryService getInstance() {
        if (instance != null) return instance;
        Class<LibraryService> clazz = LibraryService.class;
        synchronized (LibraryService.class) {
            if (instance != null) return instance;
            instance = new LibraryService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LibraryService() {
        this.init();
    }

    protected void init() {
        LibraryManagerFactory.getInstance();
    }

    @Override
    public MethodLibrary createMethodLibrary(String name, String type, Map<String, Object> params) throws LibraryServiceException {
        if (name == null || type == null || params == null) {
            throw new IllegalArgumentException();
        }
        boolean reopenLibrary = LibraryService.getInstance().getCurrentMethodLibrary() != null;
        try {
            LibraryService.getInstance().closeCurrentMethodLibrary();
            ILibraryManager manager = LibraryManagerFactory.getInstance().createLibraryManager(type);
            MethodLibrary library = manager.createMethodLibrary(name, params);
            if (library != null) {
                library = manager.openMethodLibrary(manager.getMethodLibraryURI());
                this.setLibraryManager(manager);
                this.setCurrentMethodLibrary(library);
                this.saveMethodLibraryPreferences(manager.getMethodLibraryURI(), type);
                this.notifyListeners(library, 1);
            }
            reopenLibrary = false;
            MethodLibrary methodLibrary = library;
            return methodLibrary;
        }
        catch (LibraryServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LibraryServiceException(e);
        }
        finally {
            if (reopenLibrary) {
                this.openLastOpenedMethodLibrary();
            }
        }
    }

    @Override
    public MethodLibrary openMethodLibrary(String type, URI uri) throws LibraryServiceException {
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        try {
            ILibraryManager manager = LibraryManagerFactory.getInstance().createLibraryManager(type);
            MethodLibrary library = manager.openMethodLibrary(uri);
            if (library != null) {
                this.setLibraryManager(manager);
                this.setCurrentMethodLibrary(library);
                this.saveMethodLibraryPreferences(manager.getMethodLibraryURI(), type);
                this.notifyListeners(library, 2);
            }
            return library;
        }
        catch (CreateLibraryManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LibraryServiceException(e);
        }
    }

    @Override
    public MethodLibrary openMethodLibrary(String type, Map<String, Object> params) throws LibraryServiceException {
        if (params == null) {
            throw new IllegalArgumentException();
        }
        try {
            ILibraryManager manager = LibraryManagerFactory.getInstance().createLibraryManager(type);
            MethodLibrary library = manager.openMethodLibrary(params);
            if (library != null) {
                this.setLibraryManager(manager);
                this.setCurrentMethodLibrary(library);
                this.saveMethodLibraryPreferences(manager.getMethodLibraryURI(), type);
                this.notifyListeners(library, 2);
            }
            return library;
        }
        catch (CreateLibraryManagerException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LibraryServiceException(e);
        }
    }

    @Override
    public MethodLibrary openLastOpenedMethodLibrary() {
        String type;
        URI uri;
        block6: {
            block5: {
                if (CommandLineRunUtil.getInstance().isNeedToRun()) {
                    return null;
                }
                String savedMethodLibraryURI = LibraryPreferences.getSavedMethodLibraryURI();
                try {
                    uri = new URI(savedMethodLibraryURI);
                    if (uri.getPath().length() != 0) break block5;
                    return null;
                }
                catch (Exception exception) {
                    LibraryPlugin.getDefault().getLogger().logWarning("Unable to open the last opened method library '" + savedMethodLibraryURI + "'.");
                    LibraryPreferences.setSavedMethodLibraryURI("");
                    return null;
                }
            }
            type = LibraryPreferences.getSavedMethodLibraryType();
            if (type != null && type.length() != 0) break block6;
            return null;
        }
        return this.openMethodLibrary(type, uri);
    }

    @Override
    public MethodLibrary reopenMethodLibrary(MethodLibrary library) throws LibraryServiceException {
        ILibraryManager manager = this.getLibraryManager(library);
        if (manager != null) {
            try {
                this.removeLibraryManager(manager);
                library = manager.reopenMethodLibrary();
                this.setLibraryManager(manager);
                this.setCurrentMethodLibrary(library);
                this.notifyListeners(library, 3);
            }
            catch (Exception e) {
                throw new LibraryServiceException(e);
            }
        }
        return null;
    }

    @Override
    public MethodLibrary reopenCurrentMethodLibrary() throws LibraryServiceException {
        return this.reopenMethodLibrary(this.currentLibrary);
    }

    @Override
    public void saveMethodLibrary(MethodLibrary library) throws LibraryServiceException {
        ILibraryManager manager = this.getLibraryManager(library);
        if (manager != null) {
            manager.saveMethodLibrary();
        }
    }

    @Override
    public void saveCurrentMethodLibrary() throws LibraryServiceException {
        this.saveMethodLibrary(this.currentLibrary);
    }

    @Override
    public void closeMethodLibrary(MethodLibrary library) throws LibraryServiceException {
        ILibraryManager manager = this.getLibraryManager(library);
        if (manager != null) {
            this.notifyListeners(library, 4);
            manager.closeMethodLibrary();
            if (this.currentLibrary == library) {
                this.setCurrentMethodLibrary(null);
                this.setCurrentMethodConfiguration(null);
            }
            this.removeLibraryManager(manager);
            manager.dispose();
        }
    }

    @Override
    public synchronized void closeCurrentMethodLibrary() throws LibraryServiceException {
        if (this.closingCurrentLibrary) {
            return;
        }
        try {
            this.closingCurrentLibrary = true;
            if (this.currentLibrary != null) {
                this.closeMethodLibrary(this.currentLibrary);
            }
        }
        finally {
            this.closingCurrentLibrary = false;
        }
    }

    @Override
    public void replaceMethodLibrary(MethodLibrary oldLibrary, MethodLibrary newLibrary) {
        ILibraryManager manager = this.getLibraryManager(oldLibrary);
        if (manager != null) {
            this.removeLibraryManager(manager);
            manager.setMethodLibrary(newLibrary);
            this.setLibraryManager(manager);
        }
    }

    @Override
    public void addListener(ILibraryServiceListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(ILibraryServiceListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public MethodLibrary getCurrentMethodLibrary() {
        return this.currentLibrary;
    }

    @Override
    public void setCurrentMethodLibrary(MethodLibrary library) {
        this.currentLibrary = library;
        this.notifyListeners(library, 5);
    }

    @Override
    public String getCurrentMethodLibraryLocation() {
        ILibraryManager manager = this.getLibraryManager(this.currentLibrary);
        if (manager != null) {
            return manager.getMethodLibraryLocation();
        }
        return null;
    }

    @Override
    public ILibraryManager getLibraryManager(MethodLibrary library) {
        return this.libraryManagers.get(library);
    }

    @Override
    public void removeLibraryManager(ILibraryManager libMgr) {
        MethodLibrary lib;
        if (libMgr != null && (lib = libMgr.getMethodLibrary()) != null) {
            this.removeConfigurationManagers(lib);
            this.libraryManagers.remove(lib);
        }
    }

    @Override
    public void setLibraryManager(ILibraryManager libMgr) {
        MethodLibrary lib = libMgr.getMethodLibrary();
        if (lib != null) {
            this.libraryManagers.put(lib, libMgr);
        }
    }

    @Override
    public ILibraryManager getCurrentLibraryManager() {
        return this.getLibraryManager(this.currentLibrary);
    }

    @Override
    public MethodConfiguration createMethodConfiguration(String name, MethodLibrary library) throws LibraryServiceException {
        MethodConfiguration config2;
        if (name == null || library == null) {
            throw new IllegalArgumentException();
        }
        List configs = library.getPredefinedConfigurations();
        for (MethodConfiguration config2 : configs) {
            if (!name.equals(config2.getName())) continue;
            throw new ConfigurationAlreadyExistsException();
        }
        config2 = UmaFactory.eINSTANCE.createMethodConfiguration();
        config2.setName(name);
        configs.add(config2);
        return config2;
    }

    @Override
    public MethodConfiguration getCurrentMethodConfiguration() {
        return this.currentConfig;
    }

    @Override
    public void setCurrentMethodConfiguration(MethodConfiguration config) {
        this.currentConfig = config;
        this.notifyListeners(config, 6);
    }

    @Override
    public synchronized IConfigurationManager getConfigurationManager(MethodConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException();
        }
        IConfigurationManager manager = this.configManagers.get(config);
        if (manager == null) {
            manager = new ConfigurationManager(config);
            this.configManagers.put(config, manager);
        }
        return manager;
    }

    @Override
    public void removeConfigurationManager(MethodConfiguration config) {
        if (config == null) {
            throw new IllegalArgumentException();
        }
        IConfigurationManager mgr = this.configManagers.remove(config);
        if (mgr != null) {
            mgr.dispose();
        }
    }

    @Override
    public void removeConfigurationManagers(MethodLibrary library) {
        if (library == null) {
            throw new IllegalArgumentException();
        }
        MethodConfiguration[] configs = LibraryServiceUtil.getMethodConfigurations(library);
        int i = 0;
        while (i < configs.length) {
            this.removeConfigurationManager(configs[i]);
            ++i;
        }
    }

    @Override
    public IConfigurationManager getCurrentConfigurationManager() {
        if (this.currentConfig != null) {
            return this.getConfigurationManager(this.currentConfig);
        }
        return null;
    }

    protected void notifyListeners(final MethodLibrary library, int eventId) {
        for (final ILibraryServiceListener listener : new ArrayList<ILibraryServiceListener>(this.listeners)) {
            switch (eventId) {
                case 1: {
                    SafeUpdateController.asyncExec(new Runnable(){

                        public void run() {
                            listener.libraryCreated(library);
                        }
                    });
                    break;
                }
                case 2: {
                    SafeUpdateController.asyncExec(new Runnable(){

                        public void run() {
                            listener.libraryOpened(library);
                        }
                    });
                    break;
                }
                case 3: {
                    SafeUpdateController.asyncExec(new Runnable(){

                        public void run() {
                            listener.libraryReopened(library);
                        }
                    });
                    break;
                }
                case 4: {
                    SafeUpdateController.asyncExec(new Runnable(){

                        public void run() {
                            listener.libraryClosed(library);
                        }
                    });
                    break;
                }
                case 5: {
                    SafeUpdateController.asyncExec(new Runnable(){

                        public void run() {
                            listener.librarySet(library);
                        }
                    });
                }
            }
        }
    }

    protected void notifyListeners(final MethodConfiguration config, int eventId) {
        for (final ILibraryServiceListener listener : new ArrayList<ILibraryServiceListener>(this.listeners)) {
            switch (eventId) {
                case 6: {
                    SafeUpdateController.syncExec(new Runnable(){

                        public void run() {
                            listener.configurationSet(config);
                        }
                    });
                }
            }
        }
    }

    protected void saveMethodLibraryPreferences(URI uri, String type) {
        LibraryPreferences.setSavedMethodLibraryURI(uri.toString());
        LibraryPreferences.setSavedMethodLibraryType(type);
    }

    @Override
    public void registerMethodLibrary(MethodLibrary lib, String type, Map<String, Object> params) throws LibraryServiceException {
        ILibraryManager libMgr = LibraryManagerFactory.getInstance().createLibraryManager(type);
        libMgr.registerMethodLibrary(lib, params);
        LibraryService.getInstance().setLibraryManager(libMgr);
    }

    @Override
    public void unRegisterMethodLibrary(MethodLibrary lib) throws LibraryServiceException {
        ILibraryManager libMgr = this.getLibraryManager(lib);
        if (libMgr == null) {
            return;
        }
        this.removeLibraryManager(libMgr);
        libMgr.unRegisterMethodLibrary();
        libMgr.dispose();
    }

    @Override
    public LibraryProblemMonitor getLibraryProblemMonitor() {
        if (this.libraryProblemMonitor == null) {
            this.libraryProblemMonitor = new LibraryProblemMonitor();
        }
        return this.libraryProblemMonitor;
    }
}

