/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.SupportingElementData;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public abstract class ConfigDataBase {
    public static boolean localDebug = false;
    private static boolean profiling = false;
    private MethodConfiguration config;
    private boolean needUpdateChanges = true;
    private ILibraryManager libraryManager;
    private Adapter configListener;
    private ILibraryChangeListener libListener;
    private boolean enableUpdate = true;
    private boolean updatingChanges = false;

    public ConfigDataBase(MethodConfiguration config) {
        this.config = config;
        this.configListener = new AdapterImpl(){

            public void notifyChanged(Notification msg) {
                if (ConfigDataBase.this.isNeedUpdateChanges()) {
                    return;
                }
                int type = msg.getEventType();
                if (type == 3 || type == 5 || type == 4 || type == 6) {
                    ConfigDataBase.this.setNeedUpdateChanges(true);
                }
            }
        };
        config.eAdapters().add((Object)this.configListener);
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection changedItems) {
                ConfigDataBase.this.handleLibraryChange(option, changedItems);
            }
        };
        MethodLibrary library = LibraryServiceUtil.getMethodLibrary((MethodElement)config);
        this.libraryManager = LibraryService.getInstance().getLibraryManager(library);
        if (this.libraryManager != null) {
            this.libraryManager.addListener(this.libListener);
        }
    }

    protected void handleLibraryChange(int option, Collection changedItems) {
        this.setNeedUpdateChanges(true);
    }

    public void dispose() {
        this.config.eAdapters().remove((Object)this.configListener);
        this.libraryManager.removeListener(this.libListener);
    }

    protected boolean isNeedUpdateChanges() {
        return this.needUpdateChanges;
    }

    public void setNeedUpdateChanges(boolean needUpdateChanges) {
        this.needUpdateChanges = needUpdateChanges;
        if (localDebug) {
            System.out.println("LD> setNeedUpdateChanges: " + needUpdateChanges);
        }
    }

    protected boolean isEnableUpdate() {
        return this.enableUpdate;
    }

    public void setEnableUpdate(boolean enableUpdate) {
        this.enableUpdate = enableUpdate;
        if (localDebug) {
            System.out.println("LD> setEnableUpdate: " + enableUpdate);
        }
    }

    public MethodConfiguration getConfig() {
        return this.config;
    }

    public void setConfig(MethodConfiguration config) {
        this.config = config;
    }

    protected void updateChanges() {
        if (!this.isEnableUpdate()) {
            return;
        }
        if (!this.isNeedUpdateChanges()) {
            return;
        }
        if (this.isUpdatingChanges()) {
            return;
        }
        long t = 0L;
        if (profiling) {
            System.out.println("LD> updateChanges_() -> " + this.getType());
            t = System.currentTimeMillis();
        }
        if (localDebug) {
            System.out.println("LD> updateChanges(): " + this.getType());
        }
        this.updateChangeImpl();
        if (profiling) {
            t = System.currentTimeMillis() - t;
            System.out.println("LD> updateChanges_() <- time: " + t + ", " + this.getType());
            System.out.println("");
        }
    }

    protected abstract void updateChangeImpl();

    protected boolean isUpdatingChanges() {
        return this.updatingChanges;
    }

    protected void setUpdatingChanges(boolean updatingChanges) {
        this.updatingChanges = updatingChanges;
        if (localDebug) {
            System.out.println("LD> setUpdatingChanges: " + updatingChanges + ", " + this.getType());
        }
    }

    private String getType() {
        if (this instanceof SupportingElementData) {
            return "SupportingElementData";
        }
        return "";
    }
}

