/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.io.File;
import java.io.PrintStream;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.util.ContentResourceScanner;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.osgi.util.NLS;

public class DefaultContentValidator
implements IContentValidator {
    protected PrintStream info;
    protected PrintStream warning;
    protected PrintStream error;
    protected String pubDir;

    public DefaultContentValidator() {
        this(null);
    }

    public DefaultContentValidator(String pubDir) {
        this.pubDir = pubDir;
        this.info = System.out;
        this.warning = System.out;
        this.error = System.err;
    }

    public void setPublishDir(String pubDir) {
        this.pubDir = pubDir;
    }

    public String getPublishDir() {
        return this.pubDir;
    }

    public boolean showBrokenLinks() {
        return true;
    }

    public void scanContent(IElementLayout layout, String content) throws Exception {
        MethodElement owner = layout.getElement();
        String contentPath = layout.getFilePath();
        ContentResourceScanner scanner = this.getScanner(owner);
        if (scanner != null) {
            scanner.resolveResources(owner, content, contentPath);
        }
    }

    private ContentResourceScanner getScanner(MethodElement owner) {
        ILibraryResourceManager resMgr = ResourceHelper.getResourceMgr(owner);
        if (resMgr == null) {
            return null;
        }
        String rootContentPath = resMgr.getLogicalPluginPath(owner);
        File src_root = new File(resMgr.getPhysicalPluginPath(owner));
        File tgt_root = new File(this.pubDir, rootContentPath);
        ContentResourceScanner scanner = new ContentResourceScanner(src_root, tgt_root, rootContentPath, this);
        return scanner;
    }

    public LinkInfo validateLink(MethodElement owner, String attributes, String text, MethodConfiguration config, String tag) {
        LinkInfo info = new LinkInfo(owner, this, this.pubDir, tag);
        info.validateLink(attributes, text, config);
        return info;
    }

    public void logInfo(MethodElement owner, String message) {
        this.info.println(NLS.bind((String)LibraryResources.DefaultContentValidator_MSG1, (Object)(String.valueOf(owner == null ? "" : LibraryUtil.getTypeName(owner)) + ": " + message)));
        this.info.flush();
    }

    public void logWarning(MethodElement owner, String message) {
        this.warning.println(NLS.bind((String)LibraryResources.DefaultContentValidator_MSG4, (Object)(String.valueOf(owner == null ? "" : LibraryUtil.getTypeName(owner)) + ": " + message)));
        this.warning.flush();
    }

    public void logError(MethodElement owner, String message, Throwable th) {
        this.error.println(NLS.bind((String)LibraryResources.DefaultContentValidator_MSG7, (Object)(String.valueOf(owner == null ? "" : LibraryUtil.getTypeName(owner)) + ": " + message)));
        if (th != null) {
            th.printStackTrace(this.error);
        }
        this.error.flush();
    }

    public void logInfo(String message) {
        this.logInfo(null, message);
    }

    public void logWarning(String message) {
        this.logWarning(null, message);
    }

    public void logError(String message, Throwable th) {
        this.logError(null, message, th);
    }

    public void logMissingReference(MethodElement owner, MethodElement refElement) {
        this.logWarning(owner, NLS.bind((String)LibraryResources.DefaultContentValidator_MSG10, (Object)LibraryUtil.getTypeName(refElement)));
    }

    public void logMissingReference(MethodElement owner, String guid, String linkedText) {
        this.logWarning(owner, NLS.bind((String)LibraryResources.DefaultContentValidator_MSG11, (Object)guid));
    }

    public void logMissingResource(MethodElement owner, File resourceFile, String url) {
        String msg = resourceFile != null ? NLS.bind((String)LibraryResources.DefaultContentValidator_MSG12, (Object)resourceFile.getPath(), (Object)url) : NLS.bind((String)LibraryResources.DefaultContentValidator_MSG15, (Object)url);
        this.logWarning(owner, msg);
    }

    public void logInvalidExternalLink(MethodElement owner, String url, String message) {
        String text = message != null && message.length() > 0 ? NLS.bind((String)LibraryResources.DefaultContentValidator_MSG19, (Object)url, (Object)message) : NLS.bind((String)LibraryResources.DefaultContentValidator_MSG17, (Object)url);
        this.logWarning(owner, text);
    }

    public boolean isDiscarded(MethodElement owner, Object feature, MethodElement e) {
        return false;
    }

    public boolean isDiscarded(MethodElement owner, Object feature, MethodElement e, MethodConfiguration config) {
        return false;
    }

    public void dispose() {
    }

    public void addReferencedElement(MethodElement owner, MethodElement e) {
    }

    public void setDiscardedElement(MethodElement e) {
    }

    public boolean showExtraInfoForDescriptors() {
        return BrowsingLayoutSettings.INSTANCE.isShowExtraInfoForDescriptors();
    }

    public boolean showRelatedDescriptors() {
        return true;
    }

    public String getDefaultActivityTab() {
        return null;
    }
}

