/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;
import org.eclipse.epf.library.layout.DefaultContentValidator;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutExtension;
import org.eclipse.epf.library.layout.LayoutExtensionFactory;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.ProcessAdapterFactoryFilter;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.layout.elements.GeneralLayout;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkBreakdownElement;

public class ElementLayoutManager {
    private static final String PACKAGE_NAME = ElementLayoutManager.class.getPackage().getName();
    private static final String default_config_path = "noconfig";
    private boolean isPublishingMode = false;
    private String publish_dir = null;
    private MethodConfiguration config = null;
    private IActivityDiagramService diagramService = null;
    private LayoutAdapterFactory contentLayoutAdapterFactory = null;
    private LayoutAdapterFactory diagramLayoutAdapterFactory = null;
    private Map supressionMap = null;
    private IContentValidator validator = null;
    private ElementRealizer realizer = null;
    private Map<String, LayoutExtension> layoutExtensions = new HashMap<String, LayoutExtension>();
    private static final Pattern p_parameters = Pattern.compile("\\?proc=(.*?)&path=(.*)?", 34);

    public boolean isPublishingMode() {
        return this.isPublishingMode;
    }

    public ElementLayoutManager() {
        this(null, null, null, false);
    }

    public ElementLayoutManager(MethodConfiguration config) {
        this(config, null, null, false);
    }

    public ElementLayoutManager(MethodConfiguration config, String publishdir, IContentValidator validator, boolean isPublishingMode) {
        this.validator = validator;
        this.isPublishingMode = isPublishingMode;
        if (config != null) {
            this.config = config;
        }
        if (publishdir == null) {
            publishdir = LayoutResources.getDefaultPublishDir();
            if (!publishdir.endsWith(File.separator)) {
                publishdir = String.valueOf(publishdir) + File.separator;
            }
            if (this.config == null) {
                publishdir = String.valueOf(publishdir) + default_config_path;
            } else {
                String str = StrUtil.removeSpecialCharacters((String)this.config.getName());
                if (str == "") {
                    str = Integer.toHexString(this.config.toString().hashCode());
                }
                publishdir = String.valueOf(publishdir) + str;
            }
        }
        this.setPublishDir(publishdir);
        this.contentLayoutAdapterFactory = new LayoutAdapterFactory(this.config);
        this.diagramLayoutAdapterFactory = new LayoutAdapterFactory(this.config);
        this.loadLayoutExtensions();
    }

    private void loadLayoutExtensions() {
        if (this.config == null) {
            return;
        }
        List props = this.config.getMethodElementProperty();
        if (props != null && props.size() > 0) {
            for (MethodElementProperty prop : props) {
                String id = prop.getName();
                LayoutExtension ext = LayoutExtensionFactory.getInstance().createExtension(id);
                if (ext == null) continue;
                ext.init(this);
                this.layoutExtensions.put(id, ext);
            }
        }
    }

    public IContentValidator getValidator() {
        if (this.validator == null) {
            this.validator = new DefaultContentValidator(this.getPublishDir());
        }
        return this.validator;
    }

    public ElementRealizer getElementRealizer() {
        if (this.realizer == null) {
            this.realizer = DefaultElementRealizer.newElementRealizer(this.config);
            this.realizer.setFilter(this.contentLayoutAdapterFactory.getFilter());
        }
        return this.realizer;
    }

    public void setElementRealizer(ElementRealizer realizer) {
        this.realizer = realizer;
    }

    public ConfigurableComposedAdapterFactory getWBSAdapterFactory() {
        return this.contentLayoutAdapterFactory.wbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getTBSAdapterFactory() {
        return this.contentLayoutAdapterFactory.tbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getWPBSAdapterFactory() {
        return this.contentLayoutAdapterFactory.wpbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getCBSAdapterFactory() {
        return this.contentLayoutAdapterFactory.cbsAdapterFactory;
    }

    public ConfigurableComposedAdapterFactory getDiagramAdapterFactory() {
        return this.diagramLayoutAdapterFactory.wbsAdapterFactory;
    }

    public void setActivityDiagramService(IActivityDiagramService diagramService) {
        this.diagramService = diagramService;
    }

    public IActivityDiagramService getActivityDiagramService() {
        return this.diagramService;
    }

    public Suppression getSuppression(Process proc) {
        Suppression sup = null;
        if (this.isPublishingMode) {
            String guid;
            if (this.supressionMap == null) {
                this.supressionMap = new HashMap();
            }
            if ((sup = (Suppression)this.supressionMap.get(guid = proc.getGuid())) == null) {
                sup = this.createSuppression(proc);
                this.supressionMap.put(guid, sup);
            }
        } else {
            sup = this.createSuppression(proc);
        }
        return sup;
    }

    public void prepareAdaptorFactoriesForProcess(Process proc) {
        this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getCBSAdapterFactory(), proc);
        this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getTBSAdapterFactory(), proc);
        this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getWBSAdapterFactory(), proc);
        this.prepareAdapterfactoryFor((ComposedAdapterFactory)this.getWPBSAdapterFactory(), proc);
    }

    private void prepareAdapterfactoryFor(ComposedAdapterFactory adapterFactory, Object obj) {
        if (obj == null || adapterFactory == null) {
            return;
        }
        ITreeItemContentProvider provider = null;
        provider = obj instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)obj : (ITreeItemContentProvider)adapterFactory.adapt(obj, ITreeItemContentProvider.class);
        if (provider != null) {
            Collection items = provider.getChildren(obj);
            for (Object rawitem : items) {
                MethodElement item = (MethodElement)LibraryUtil.unwrap(rawitem);
                if (!(item instanceof Activity)) continue;
                this.prepareAdapterfactoryFor(adapterFactory, rawitem);
            }
        }
    }

    private IElementLayout createLayout(MethodElement element) {
        String path = null;
        Process owningProc = null;
        if (element instanceof Activity) {
            Activity act = (Activity)element;
            path = AbstractProcessElementLayout.getPath((BreakdownElement)act);
            owningProc = TngUtil.getOwningProcess((BreakdownElement)act);
        }
        return this.createLayout(element, owningProc, path);
    }

    public IElementLayout createLayout(MethodElement element, Process owningProc, String path) {
        String className;
        AbstractElementLayout layout = null;
        if (ConfigurationHelper.isDescriptionElement(element)) {
            className = "ContentDescription";
        } else if (element instanceof Activity) {
            className = "Activity";
        } else if (element instanceof WorkBreakdownElement && !(element instanceof TaskDescriptor)) {
            className = "WorkBreakdownElement";
        } else {
            Class<?>[] i = element.getClass().getInterfaces();
            className = i != null && i.length == 1 ? i[0].getName() : element.getClass().getName();
            int index = className.lastIndexOf(".");
            if (index >= 0) {
                className = className.substring(index + 1);
            }
        }
        className = String.valueOf(PACKAGE_NAME) + ".elements." + className + "Layout";
        try {
            Class<?> c = Class.forName(className);
            if (c != null) {
                layout = (AbstractElementLayout)c.newInstance();
            }
        }
        catch (Exception exception) {}
        if (layout == null) {
            layout = new GeneralLayout();
        }
        if (layout instanceof AbstractProcessElementLayout) {
            ((AbstractProcessElementLayout)layout).init(this, element, owningProc, path);
        } else {
            ((AbstractElementLayout)layout).init(this, element);
        }
        return layout;
    }

    public IElementLayout getLayout(MethodElement element, boolean create) {
        IElementLayout layout = null;
        if (layout == null && create) {
            layout = this.createLayout(element);
        }
        return layout;
    }

    public IElementLayout getLayout(String url) {
        MethodElement element;
        Process owningProc = null;
        String path = null;
        Matcher m = p_parameters.matcher(url);
        if (m.find()) {
            String proc = m.group(1);
            path = m.group(2);
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            if (manager != null) {
                owningProc = (Process)manager.getMethodElement(proc);
            }
        }
        if ((element = ResourceHelper.getElementFromFileName(url)) != null) {
            return this.createLayout(element, owningProc, path);
        }
        System.out.println("Can't find element for url '" + url + "'");
        return null;
    }

    public static String getQueryString(String proc, String path) {
        return "?proc=" + proc + "&" + "path" + "=" + path;
    }

    public MethodConfiguration getConfiguration() {
        return this.config;
    }

    public void setPublishDir(String path) {
        this.publish_dir = path;
        if (!this.publish_dir.endsWith(File.separator)) {
            this.publish_dir = String.valueOf(this.publish_dir) + File.separator;
        }
        this.init_publishingSite();
    }

    public String getPublishDir() {
        return this.publish_dir;
    }

    private void init_publishingSite() {
        if (BrowsingLayoutSettings.INSTANCE.needUpdate(this.publish_dir)) {
            if (LibraryPlugin.getDefault().isDebugging()) {
                System.out.println("Begin initializing publishing site: " + this.publish_dir);
            }
            LayoutResources.copyLayoutFiles(this.publish_dir);
            if (LibraryPlugin.getDefault().isDebugging()) {
                System.out.println("End initializing publishing site: " + this.publish_dir);
            }
        }
    }

    public void clear() {
        this.diagramService = null;
        if (this.supressionMap != null) {
            this.supressionMap.clear();
        }
        this.layoutExtensions.clear();
        this.layoutExtensions = null;
        this.contentLayoutAdapterFactory.clear();
        this.diagramLayoutAdapterFactory.clear();
        if (this.validator != null) {
            this.validator.dispose();
            this.validator = null;
        }
        if (this.realizer != null) {
            this.realizer.dispose();
            this.realizer = null;
        }
        if (this.contentLayoutAdapterFactory != null) {
            this.contentLayoutAdapterFactory.clear();
            this.contentLayoutAdapterFactory = null;
        }
        if (this.diagramLayoutAdapterFactory != null) {
            this.diagramLayoutAdapterFactory.clear();
            this.diagramLayoutAdapterFactory = null;
        }
    }

    private Suppression createSuppression(Process proc) {
        if (this.layoutExtensions != null && this.layoutExtensions.size() > 0) {
            for (LayoutExtension ext : this.layoutExtensions.values()) {
                Suppression sup = ext.getSuppression(proc);
                if (sup == null) continue;
                return sup;
            }
        }
        return new Suppression(proc);
    }

    public class LayoutAdapterFactory {
        public ConfigurableComposedAdapterFactory wbsAdapterFactory = null;
        public ConfigurableComposedAdapterFactory tbsAdapterFactory = null;
        public ConfigurableComposedAdapterFactory wpbsAdapterFactory = null;
        public ConfigurableComposedAdapterFactory cbsAdapterFactory = null;
        ProcessAdapterFactoryFilter configurator = null;

        public LayoutAdapterFactory(MethodConfiguration methodConfig) {
            if (ElementLayoutManager.this.isPublishingMode()) {
                this.wbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createPublishingWBSAdapterFactory();
                this.tbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createPublishingTBSAdapterFactory();
                this.wpbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createPublishingWPBSAdapterFactory();
                this.cbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createPublishingCBSAdapterFactory();
            } else {
                this.wbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWBSComposedAdapterFactory();
                this.tbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createTBSComposedAdapterFactory();
                this.wpbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createWPBSComposedAdapterFactory();
                this.cbsAdapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.createProcessComposedAdapterFactory();
            }
            this.configurator = new ProcessAdapterFactoryFilter(methodConfig, this);
            this.wbsAdapterFactory.setFilter((IFilter)this.configurator);
            this.tbsAdapterFactory.setFilter((IFilter)this.configurator);
            this.wpbsAdapterFactory.setFilter((IFilter)this.configurator);
            this.cbsAdapterFactory.setFilter((IFilter)this.configurator);
        }

        public IFilter getFilter() {
            return this.configurator;
        }

        public void clear() {
            if (this.wbsAdapterFactory != null) {
                this.wbsAdapterFactory.setFilter(null);
                this.wbsAdapterFactory.dispose();
                this.wbsAdapterFactory = null;
            }
            if (this.tbsAdapterFactory != null) {
                this.tbsAdapterFactory.setFilter(null);
                this.tbsAdapterFactory.dispose();
                this.tbsAdapterFactory = null;
            }
            if (this.wpbsAdapterFactory != null) {
                this.wpbsAdapterFactory.setFilter(null);
                this.wpbsAdapterFactory.dispose();
                this.wpbsAdapterFactory = null;
            }
            if (this.cbsAdapterFactory != null) {
                this.cbsAdapterFactory.setFilter(null);
                this.cbsAdapterFactory.dispose();
                this.cbsAdapterFactory = null;
            }
            if (this.configurator != null) {
                this.configurator.dispose();
                this.configurator = null;
            }
        }
    }
}

