/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.layout.LayoutExtension;
import org.osgi.framework.Bundle;

public class LayoutExtensionFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.library";
    public static final String EXTENSION_POINT_NAME = "elementLayoutExtensions";
    public static final String CLASS_ATTRIB_NAME = "class";
    public static final String ID_ATTRIB_NAME = "id";
    private static LayoutExtensionFactory instance = null;
    private Map<String, LayoutExtensionElement> layoutElements = new HashMap<String, LayoutExtensionElement>();

    public static synchronized LayoutExtensionFactory getInstance() {
        if (instance == null) {
            instance = new LayoutExtensionFactory();
        }
        return instance;
    }

    private LayoutExtensionFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        LayoutExtensionElement provider;
                        String className = configElement.getAttribute(CLASS_ATTRIB_NAME);
                        String id = configElement.getAttribute(ID_ATTRIB_NAME);
                        if (className != null && className.trim().length() > 0 && id != null && id.trim().length() > 0 && (provider = this.layoutElements.get(id)) == null) {
                            provider = new LayoutExtensionElement(bundle, className, id);
                            this.layoutElements.put(id, provider);
                        }
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public boolean hasExtension(String id) {
        return this.layoutElements.containsKey(id);
    }

    public LayoutExtension createExtension(String id) {
        if (!this.hasExtension(id)) {
            return null;
        }
        LayoutExtensionElement provider = this.layoutElements.get(id);
        try {
            Class clazz = provider.bundle.loadClass(provider.className);
            return (LayoutExtension)clazz.newInstance();
        }
        catch (Exception e) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
            return null;
        }
    }

    private class LayoutExtensionElement {
        Bundle bundle;
        String className;
        String id;

        private LayoutExtensionElement(Bundle bundle, String className, String id) {
            this.bundle = bundle;
            this.className = className;
            this.id = id;
        }
    }
}

