/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import com.ibm.icu.util.Calendar;
import java.io.File;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;

public class LayoutResources {
    private static ResourceBundle resourceBundle;
    private static ResourceBundle shapeiconBundle;
    private static String TEMP_LAYOUT_DIR;

    static {
        TEMP_LAYOUT_DIR = "";
        try {
            String pkg = LayoutResources.class.getPackage().getName();
            String resource = LayoutResources.class.getName();
            resourceBundle = ResourceBundle.getBundle(resource);
            shapeiconBundle = ResourceBundle.getBundle(String.valueOf(pkg) + ".DefaultShapeicons");
            String userHome = System.getProperty("user.home");
            TEMP_LAYOUT_DIR = String.valueOf(userHome) + File.separator + "EPF" + File.separator + "layout" + File.separator + Long.toHexString(Calendar.getInstance().getTimeInMillis()) + File.separator;
            File rupTmpDir = new File(TEMP_LAYOUT_DIR);
            if (!rupTmpDir.exists()) {
                rupTmpDir.mkdirs();
            } else {
                FileUtil.deleteAllFiles((String)rupTmpDir.getAbsolutePath());
            }
        }
        catch (MissingResourceException x) {
            x.printStackTrace();
            resourceBundle = null;
        }
    }

    public static void clear() {
        try {
            FileUtil.deleteAllFiles((String)TEMP_LAYOUT_DIR);
            new File(TEMP_LAYOUT_DIR).delete();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BrowsingLayoutSettings.INSTANCE.setChanged();
    }

    public static String getDefaultPublishDir() {
        return TEMP_LAYOUT_DIR;
    }

    public static String getDefaultXslPath(String key, String secondKey) {
        String url = LayoutResources.getXslUri(key, secondKey);
        if (url != null) {
            return String.valueOf(LibraryPlugin.getDefault().getLayoutXslPath()) + url;
        }
        return "";
    }

    public static String getXslUri(String key, String secondKey) {
        String url = LayoutResources.getString(resourceBundle, key.toLowerCase());
        if (url == null && secondKey != null) {
            url = LayoutResources.getString(resourceBundle, secondKey.toLowerCase());
        }
        if (url == null) {
            url = LayoutResources.getString(resourceBundle, "default");
        }
        return url;
    }

    public static String getDefaultShapeiconUrl(String key) {
        String url = LayoutResources.getString(shapeiconBundle, key);
        if (url == null) {
            url = LayoutResources.getString(shapeiconBundle, "general");
        }
        return url;
    }

    private static String getString(ResourceBundle bundle, String key) {
        try {
            return bundle != null ? bundle.getString(key) : null;
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    public static String getString(String key) {
        return LayoutResources.getString(resourceBundle, key);
    }

    public static void copyDir(String fromDir, String toDir) {
        String includes = "*.*, **/css/*.*, **/icons/*.*, **/images/*.*, **/resources/*.*, **/stylesheets/*.*, **/scripts/*.*";
        LayoutResources.copyDir(fromDir, toDir, includes, null);
    }

    public static void copyDir(String fromDir, String toDir, String includes, String excludes) {
        LayoutResources.copyDir(new File(fromDir), new File(toDir), includes, excludes);
    }

    public static void copyDir(File fromDir, File toDir, String includes, String excludes) {
        LayoutResources.copyDir(fromDir, toDir, includes, excludes, true);
    }

    public static void copyDir(File fromDir, File toDir, String includes, String excludes, boolean overwrite) {
        Copy cp = new Copy();
        cp.setOverwrite(overwrite);
        if (includes != null || excludes != null) {
            FileSet set = new FileSet();
            if (includes != null) {
                set.setIncludes(includes);
            }
            if (excludes != null) {
                set.setExcludes(excludes);
            }
            set.setDir(fromDir);
            cp.addFileset(set);
        }
        cp.setTodir(toDir);
        cp.setProject(new Project());
        cp.execute();
    }

    public static void copyLayoutFiles(String toDir) {
        String sourceDir = LibraryPlugin.getDefault().getLayoutPath();
        LayoutResources.copyDir(sourceDir, toDir);
        try {
            LibraryPlugin.getDefault().copyLocalizedFiles("layout/scripts/", new File(toDir, "scripts"), true, false);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void unzip(File zipFile, File toDir) {
        Expand exp = new Expand();
        exp.setOverwrite(true);
        exp.setSrc(zipFile);
        exp.setDest(toDir);
        exp.setProject(new Project());
        exp.execute();
    }
}

