/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.xml.sax.SAXException;

public class ImportExportUtil {
    public static void replace(ProcessComponent procComp, String dir) throws IOException, ParserConfigurationException, FactoryConfigurationError, SAXException {
        File newProcCompFile = new File(dir, "model.xmi");
        if (!newProcCompFile.exists()) {
            throw new FileNotFoundException(MessageFormat.format(LibraryResources.ImportExportUtil_MSG8, newProcCompFile));
        }
        String oldModelFileStr = procComp.eResource().getURI().toFileString();
        String oldProcCompDir = new File(oldModelFileStr).getParent();
        String suffix = MultiFileSaveUtil.getBackupFileSuffix();
        File tempDir = null;
        try {
            tempDir = new File(oldProcCompDir, suffix);
            if (!tempDir.mkdir()) {
                throw new IOException(MessageFormat.format(LibraryResources.ImportExportUtil_MSG9, tempDir));
            }
            FileUtil.copyDir((File)new File(dir), (File)tempDir);
            newProcCompFile = new File(tempDir, "model.xmi");
            ResourceSet resourceSet = procComp.eResource().getResourceSet();
            Resource newResource = resourceSet.getResource(URI.createFileURI((String)newProcCompFile.getAbsolutePath()), true);
            ProcessComponent newProcComp = (ProcessComponent)PersistenceUtil.getMethodElement((Resource)newResource);
            Process newProc = newProcComp.getProcess();
            newProc.setDefaultContext(procComp.getProcess().getDefaultContext());
            newProc.getValidContext().clear();
            newProc.getValidContext().addAll(procComp.getProcess().getValidContext());
            TreeIterator iter = newProcComp.eAllContents();
            while (iter.hasNext()) {
                Object element = iter.next();
                if (!(element instanceof TaskDescriptor)) continue;
                TaskDescriptor taskDesc = (TaskDescriptor)element;
                Task task = taskDesc.getTask();
                String taskName = task == null ? "NONE" : "'" + task.getName() + "'";
                System.out.println("Task: " + taskName);
                if (task == null) continue;
                taskDesc.getSelectedSteps().clear();
                taskDesc.getSelectedSteps().addAll(task.getSteps());
            }
            ResourceManager resMgr = MultiFileSaveUtil.getResourceManager((Resource)procComp.eResource());
            if (resMgr != null) {
                MultiFileSaveUtil.getResourceManager((Resource)newResource).setGuid(resMgr.getGuid());
            }
            newProcComp.setGuid(procComp.getGuid());
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            HashMap saveOptions = manager != null ? manager.getSaveOptions() : new HashMap();
            newResource.save(saveOptions);
            File file = new File(oldModelFileStr);
            FileUtil.moveFile((File)file, (File)new File(String.valueOf(oldModelFileStr) + ".bak" + suffix));
            FileUtil.moveFile((File)newProcCompFile, (File)new File(oldModelFileStr));
            File newContentFile = new File(tempDir, "content.xmi");
            String contentFileStr = String.valueOf(oldProcCompDir) + File.separator + "content.xmi";
            File oldContentFile = new File(contentFileStr);
            FileUtil.moveFile((File)oldContentFile, (File)new File(String.valueOf(contentFileStr) + ".bak" + suffix));
            if (newContentFile.exists()) {
                FileUtil.moveFile((File)newContentFile, (File)oldContentFile);
            }
        }
        finally {
            if (tempDir != null) {
                FileUtil.deleteAllFiles((String)tempDir.getAbsolutePath());
                tempDir.delete();
            }
        }
    }
}

