/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModelStorage {
    public static List<MethodPlugin> getBaseModels() {
        MethodLibrary lib = LibraryService.getInstance().getCurrentMethodLibrary();
        if (lib != null) {
            return new ArrayList<MethodPlugin>(lib.getMethodPlugins());
        }
        return Collections.emptyList();
    }

    public static Resource newLibrary(ILibraryResourceSet resourceSet, String name, String dir, boolean bMultiple) throws Exception {
        String lib_filename = null;
        lib_filename = bMultiple ? "library.xmi" : name;
        resourceSet.unload();
        Resource res = resourceSet.createResource(URI.createFileURI((String)(String.valueOf(dir) + File.separator + lib_filename)));
        MethodLibrary lib = UmaFactory.eINSTANCE.createMethodLibrary();
        lib.setName(name);
        res.getContents().add((Object)lib);
        resourceSet.save(null);
        return res;
    }

    public static MethodPlugin initialize(MethodPlugin emptyModel) {
        emptyModel.setUserChangeable(Boolean.TRUE);
        ModelStorage.createContentPackages(emptyModel, ModelStructure.DEFAULT_DOMAIN_PATH);
        ModelStorage.createContentPackages(emptyModel, ModelStructure.DEFAULT.disciplineDefinitionPath);
        ModelStorage.createContentPackages(emptyModel, ModelStructure.DEFAULT.roleSetPath);
        ModelStorage.createContentPackages(emptyModel, ModelStructure.DEFAULT.coreContentPath);
        ModelStorage.createContentPackages(emptyModel, ModelStructure.DEFAULT.workProductTypePath);
        ModelStorage.createContentPackages(emptyModel, ModelStructure.DEFAULT.toolPath);
        ModelStorage.createContentPackages(emptyModel, ModelStructure.DEFAULT.standardCategoryPath);
        ContentPackage contentPkg = ModelStorage.createContentPackages(emptyModel, ModelStructure.DEFAULT.customCategoryPath);
        TngUtil.createRootCustomCategory((ContentPackage)contentPkg);
        ProcessPackage pkg = UmaFactory.eINSTANCE.createProcessPackage();
        pkg.setName(ModelStructure.DEFAULT.deliveryProcessPath[0]);
        emptyModel.getMethodPackages().add(pkg);
        ModelStructure.createProcessContributionPackage((MethodPlugin)emptyModel);
        pkg = UmaFactory.eINSTANCE.createProcessPackage();
        int len = ModelStructure.DEFAULT.capabilityPatternPath.length - 1;
        pkg.setName(ModelStructure.DEFAULT.capabilityPatternPath[len]);
        String[] path = new String[len];
        System.arraycopy(ModelStructure.DEFAULT.capabilityPatternPath, 0, path, 0, len);
        ContentPackage contPkg = UmaUtil.findContentPackage((MethodPlugin)emptyModel, (String[])path);
        contPkg.getChildPackages().add(pkg);
        return emptyModel;
    }

    private static ContentPackage createContentPackages(MethodPlugin model, String[] path) {
        List list = model.getMethodPackages();
        ContentPackage pkg = UmaUtil.findContentPackage((List)list, (String)path[0]);
        if (pkg == null) {
            pkg = UmaFactory.eINSTANCE.createContentPackage();
            pkg.setName(path[0]);
            list.add(pkg);
        }
        int i = 1;
        while (i < path.length) {
            list = pkg.getChildPackages();
            if ((pkg = UmaUtil.findContentPackage((List)list, (String)path[i])) == null) {
                pkg = UmaFactory.eINSTANCE.createContentPackage();
                pkg.setName(path[i]);
                list.add(pkg);
            }
            ++i;
        }
        return pkg;
    }

    public static void loadContainmentProxies(EObject obj) {
        EList list = obj.eContents();
        int i = 0;
        while (i < list.size()) {
            InternalEObject o = (InternalEObject)list.get(i);
            if (o.eProxyURI() != null) {
                System.out.println("proxy URI = " + o.eProxyURI());
                ResourceSet resourceSet = o.eResource().getResourceSet();
                Resource res = resourceSet.getResource(o.eProxyURI(), true);
                InternalEObject resolvedObj = null;
                try {
                    resolvedObj = (InternalEObject)res.getContents().get(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("resolvedObj = " + resolvedObj);
                System.out.println("-----------------------------------");
                if (resolvedObj != null) {
                    EcoreUtil.replace((EObject)o, (EObject)resolvedObj);
                    ((BasicEList)res.getContents()).setData(1, new Object[]{resolvedObj});
                    o = resolvedObj;
                }
            }
            ModelStorage.loadContainmentProxies((EObject)o);
            ++i;
        }
    }

    public static void loadAllProxies(EObject obj) {
        TreeIterator iter = obj.eAllContents();
        while (iter.hasNext()) {
            EObject element = (EObject)iter.next();
            Iterator iterator = element.eCrossReferences().iterator();
            while (iterator.hasNext()) {
                iterator.next();
            }
        }
    }

    public static void loadCrossReferenceProxies(EObject obj) {
        EList list = obj.eCrossReferences();
        int size = list.size();
        int i = 0;
        while (i < size) {
            EObject o = (EObject)list.get(i);
            ModelStorage.loadCrossReferenceProxies(o);
            ++i;
        }
    }

    public static MethodElement findMethodElement(List methodElements, String name) {
        int size = methodElements.size();
        int i = 0;
        while (i < size) {
            MethodElement element = (MethodElement)methodElements.get(i);
            if (name.equals(element.getName())) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public static int indexOf(List methodElements, String name) {
        int size = methodElements.size();
        int i = 0;
        while (i < size) {
            MethodElement element = (MethodElement)methodElements.get(i);
            if (name.equals(element.getName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

