/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.richtext.actions;

import java.io.UnsupportedEncodingException;
import org.eclipse.epf.common.html.HTMLFormatter;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextPlugin;
import org.eclipse.epf.richtext.actions.RichTextAction;

public class TidyAction
extends RichTextAction {
    boolean forceOutput = false;
    boolean makeBare = false;
    boolean word2000 = false;
    protected HTMLFormatter htmlFormatter;

    public TidyAction(IRichText richText, boolean forceOutput, boolean makeBare, boolean word2000) {
        super(richText, 1);
        this.forceOutput = forceOutput;
        this.makeBare = makeBare;
        this.word2000 = word2000;
        this.setImageDescriptor(RichTextImages.IMG_DESC_TIDY);
        this.setDisabledImageDescriptor(RichTextImages.DISABLED_IMG_DESC_TIDY);
        this.htmlFormatter = new HTMLFormatter();
    }

    public void execute(IRichText richText) {
        String html = richText instanceof RichTextEditor ? ((RichTextEditor)richText).getText() : richText.getText();
        try {
            html = this.htmlFormatter.formatHTML(html, false, this.forceOutput, this.makeBare, this.word2000);
        }
        catch (UnsupportedEncodingException e) {
            RichTextPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        if (richText instanceof RichTextEditor) {
            ((RichTextEditor)richText).setText(html);
        } else {
            richText.setText(html);
        }
        richText.checkModify();
    }

    public boolean disableInSourceMode() {
        return false;
    }
}

