/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.custom.policies;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.epf.diagram.ad.edit.parts.ActivityPartitionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.CreateCommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.LabelEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.EditCommandRequestWrapper;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.UMLPackage;

public class ActivityPartitionCreationEditPolicy
extends CreationEditPolicy {
    protected Command getCreateCommand(CreateViewRequest request) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        for (CreateViewRequest.ViewDescriptor descriptor : request.getViewDescriptors()) {
            View containerView = (View)this.getHost().getModel();
            CreateCommand createCommand = new CreateCommand(editingDomain, descriptor, containerView);
            cc.compose((IUndoableOperation)createCommand);
        }
        return new ICommandProxy(cc.reduce());
    }

    protected Command getReparentCommand(ChangeBoundsRequest request) {
        Iterator editParts = request.getEditParts().iterator();
        View container = (View)this.getHost().getAdapter(View.class);
        EObject context = container == null ? null : ViewUtil.resolveSemanticElement((View)container);
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        while (editParts.hasNext()) {
            View view;
            EditPart ep = (EditPart)editParts.next();
            if (ep instanceof LabelEditPart || (view = (View)ep.getAdapter(View.class)) == null) continue;
            EObject semantic = ViewUtil.resolveSemanticElement((View)view);
            if (semantic == null) {
                cc.compose((IUndoableOperation)this.getReparentViewCommand((IGraphicalEditPart)ep));
                cc.compose((IUndoableOperation)this.adjustLocationCommand((IGraphicalEditPart)ep, request));
                continue;
            }
            if (context == null || !this.shouldReparent(semantic, context)) continue;
            cc.compose((IUndoableOperation)this.getReparentCommand((IGraphicalEditPart)ep));
            cc.compose((IUndoableOperation)this.adjustLocationCommand((IGraphicalEditPart)ep, request));
        }
        return cc.isEmpty() ? null : new ICommandProxy(cc.reduce());
    }

    protected ICommand getReparentCommand(IGraphicalEditPart gep) {
        CompositeCommand cc = new CompositeCommand(DiagramUIMessages.AddCommand_Label);
        View container = (View)this.getHost().getModel();
        EObject context = ViewUtil.resolveSemanticElement((View)container);
        View view = (View)gep.getModel();
        EObject element = ViewUtil.resolveSemanticElement((View)view);
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        if (element != null) {
            Command moveSemanticCmd = this.getHost().getCommand((Request)new EditCommandRequestWrapper((IEditCommandRequest)new MoveRequest(editingDomain, context, UMLPackage.eINSTANCE.getActivityPartition_Node(), element)));
            if (moveSemanticCmd == null) {
                return UnexecutableCommand.INSTANCE;
            }
            cc.compose((IUndoableOperation)new CommandProxy(moveSemanticCmd));
        }
        cc.compose((IUndoableOperation)this.getReparentViewCommand(gep));
        return cc;
    }

    private ICommand adjustLocationCommand(IGraphicalEditPart child, ChangeBoundsRequest request) {
        if (child instanceof ShapeEditPart) {
            Point location = request.getMoveDelta();
            Point childLocation = child.getFigure().getBounds().getLocation();
            int x = childLocation.x + location.x - ((ActivityPartitionEditPart)this.getHost()).getLocation().x;
            int y = childLocation.y + location.y - ((ActivityPartitionEditPart)this.getHost()).getLocation().y;
            SetBoundsCommand boundsCommand = new SetBoundsCommand(((ShapeEditPart)child).getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)((View)child.getModel())), new Point(x, y));
            return boundsCommand;
        }
        return null;
    }

    static ICommand createAdjustLocationCommand(IGraphicalEditPart child, ChangeBoundsRequest request, IGraphicalEditPart newParent) {
        if (child instanceof ShapeEditPart) {
            Point location = request.getMoveDelta();
            Point newLocation = child.getFigure().getBounds().getLocation().getCopy().translate(location);
            SetBoundsCommand boundsCommand = new SetBoundsCommand(((ShapeEditPart)child).getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)((View)child.getModel())), newLocation);
            return boundsCommand;
        }
        return null;
    }
}

