/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.ad.edit.parts;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.ad.custom.figures.DecisionNodeFigure;
import org.eclipse.epf.diagram.ad.edit.policies.MergeNodeItemSemanticEditPolicy;
import org.eclipse.epf.diagram.ad.part.UMLVisualIDRegistry;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.gef.editpolicies.NonResizableEditPolicy;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramColorRegistry;
import org.eclipse.gmf.runtime.draw2d.ui.figures.ConstrainedToolbarLayout;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.gef.ui.figures.DefaultSizeNodeFigure;
import org.eclipse.gmf.runtime.gef.ui.figures.NodeFigure;
import org.eclipse.gmf.runtime.notation.FillStyle;
import org.eclipse.gmf.runtime.notation.LineStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.swt.graphics.Color;

public class MergeNodeEditPart
extends ShapeNodeEditPart {
    public static final int VISUAL_ID = 1002;
    protected IFigure contentPane;
    protected IFigure primaryShape;
    public static final Color DECISIONDIAMONDFIGURE_BACK = new Color(null, 185, 205, 230);

    public MergeNodeEditPart(View view) {
        super(view);
    }

    protected void createDefaultEditPolicies() {
        super.createDefaultEditPolicies();
        this.installEditPolicy("SemanticPolicy", (EditPolicy)new MergeNodeItemSemanticEditPolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.createLayoutEditPolicy());
    }

    protected LayoutEditPolicy createLayoutEditPolicy() {
        LayoutEditPolicy lep = new LayoutEditPolicy(){

            protected EditPolicy createChildEditPolicy(EditPart child) {
                EditPolicy result = child.getEditPolicy((Object)"PrimaryDrag Policy");
                if (result == null) {
                    result = new NonResizableEditPolicy();
                }
                return result;
            }

            protected Command getMoveChildrenCommand(Request request) {
                return null;
            }

            protected Command getCreateCommand(CreateRequest request) {
                return null;
            }
        };
        return lep;
    }

    protected IFigure createNodeShape() {
        DecisionDiamondFigure figure = new DecisionDiamondFigure();
        this.primaryShape = figure;
        return this.primaryShape;
    }

    public DecisionDiamondFigure getPrimaryShape() {
        return (DecisionDiamondFigure)this.primaryShape;
    }

    protected NodeFigure createNodePlate() {
        DefaultSizeNodeFigure result = new DefaultSizeNodeFigure(this.getMapMode().DPtoLP(40), this.getMapMode().DPtoLP(40));
        return result;
    }

    protected NodeFigure createNodeFigure() {
        NodeFigure figure = this.createNodePlate();
        figure.setLayoutManager((LayoutManager)new StackLayout());
        IFigure shape = this.createNodeShape();
        figure.add(shape);
        this.contentPane = this.setupContentPane(shape);
        return figure;
    }

    protected IFigure setupContentPane(IFigure nodeShape) {
        if (nodeShape.getLayoutManager() == null) {
            ConstrainedToolbarLayout layout = new ConstrainedToolbarLayout();
            layout.setSpacing(this.getMapMode().DPtoLP(5));
            nodeShape.setLayoutManager((LayoutManager)layout);
        }
        return nodeShape;
    }

    public IFigure getContentPane() {
        if (this.contentPane != null) {
            return this.contentPane;
        }
        return super.getContentPane();
    }

    public EditPart getPrimaryChildEditPart() {
        return this.getChildBySemanticHint(UMLVisualIDRegistry.getType(4002));
    }

    protected void handleNotificationEvent(Notification notification) {
        Object feature = notification.getFeature();
        if (NotationPackage.eINSTANCE.getSize_Width().equals(feature) || NotationPackage.eINSTANCE.getSize_Height().equals(feature) || NotationPackage.eINSTANCE.getLocation_X().equals(feature) || NotationPackage.eINSTANCE.getLocation_Y().equals(feature)) {
            this.refreshBounds();
        } else if (NotationPackage.eINSTANCE.getFillStyle_FillColor().equals(feature)) {
            Integer c = (Integer)notification.getNewValue();
            this.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(c));
            this.getPrimaryShape().setBackgroundColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getLineStyle_LineColor().equals(feature)) {
            Integer c = (Integer)notification.getNewValue();
            this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(c));
            this.getPrimaryShape().setForegroundColor(DiagramColorRegistry.getInstance().getColor(c));
        } else if (NotationPackage.eINSTANCE.getFontStyle().isInstance(notification.getNotifier())) {
            this.refreshFont();
        } else if (notification.getFeature() == NotationPackage.eINSTANCE.getView_Element() && (EObject)notification.getNotifier() == this.getNotationView()) {
            this.handleMajorSemanticChange();
        } else {
            super.handleNotificationEvent(notification);
        }
    }

    public class DecisionDiamondFigure
    extends DecisionNodeFigure {
        private WrapLabel fDiamondLabel;
        private boolean myUseLocalCoordinates;

        public DecisionDiamondFigure() {
            super(MergeNodeEditPart.this.getMapMode().DPtoLP(50), MergeNodeEditPart.this.getMapMode().DPtoLP(50), MergeNodeEditPart.this.getMapMode().DPtoLP(50));
            this.myUseLocalCoordinates = false;
            LineStyle linestyle = (LineStyle)MergeNodeEditPart.this.getPrimaryView().getStyle(NotationPackage.Literals.LINE_STYLE);
            if (linestyle != null && linestyle.getLineColor() != 0xB0B0B0) {
                this.setForegroundColor(DiagramColorRegistry.getInstance().getColor(new Integer(linestyle.getLineColor())));
            } else {
                this.setForegroundColor(ColorConstants.darkBlue);
            }
            FillStyle style = (FillStyle)MergeNodeEditPart.this.getPrimaryView().getStyle(NotationPackage.Literals.FILL_STYLE);
            if (style != null && style.getFillColor() != 0xFFFFFF) {
                this.setBackgroundColor(DiagramColorRegistry.getInstance().getColor(new Integer(style.getFillColor())));
            } else {
                this.setBackgroundColor(DECISIONDIAMONDFIGURE_BACK);
            }
            this.setPreferredSize(MergeNodeEditPart.this.getMapMode().DPtoLP(50), MergeNodeEditPart.this.getMapMode().DPtoLP(50));
            this.setSize(MergeNodeEditPart.this.getMapMode().DPtoLP(50), MergeNodeEditPart.this.getMapMode().DPtoLP(50));
            this.createContents();
        }

        private void createContents() {
            WrapLabel fig_0 = new WrapLabel();
            this.setFigureDiamondLabel(fig_0);
            Object layData0 = null;
            this.add((IFigure)fig_0, layData0);
        }

        public WrapLabel getFigureDiamondLabel() {
            return this.fDiamondLabel;
        }

        private void setFigureDiamondLabel(WrapLabel fig) {
            this.fDiamondLabel = fig;
        }

        protected boolean useLocalCoordinates() {
            return this.myUseLocalCoordinates;
        }

        protected void setUseLocalCoordinates(boolean useLocalCoordinates) {
            this.myUseLocalCoordinates = useLocalCoordinates;
        }
    }
}

