/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.ui.preferences;

import java.util.List;
import org.eclipse.epf.common.ui.util.PreferenceUtil;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.export.msp.ui.ExportMSPUIPlugin;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.jface.preference.IPreferenceStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportMSPUIPreferences {
    private static final String PUBLISH_WEBSITE = "publishWebSite";
    private static final String PUBLISH_CONFIGURATION = "publishConfiguration";
    private static final String EXPORT_ONLY_PLANNED_WBS_ELEMENTS = "exportOnlyPlannedWBSElements";
    private static final String PROCESS_NAME = "processName";
    private static final String CONFIGURATION_NAME = "configurationName";
    private static final String MS_PROJECT_NAMES = "msprojectNames";
    private static final String EXPORT_DIRECTORIES = "exportDirs";
    private static final String DEFAULT_EXPORT_DIR_NAME = "Export" + FileUtil.FILE_SEP + "MSP";
    private static IPreferenceStore prefStore = ExportMSPUIPlugin.getDefault().getPreferenceStore();
    private static String defaultExportDir = null;

    static {
        prefStore.setDefault(PUBLISH_WEBSITE, true);
        prefStore.setDefault(PUBLISH_CONFIGURATION, true);
        prefStore.setDefault(EXPORT_ONLY_PLANNED_WBS_ELEMENTS, false);
        prefStore.setDefault(CONFIGURATION_NAME, "");
        prefStore.setDefault(PROCESS_NAME, "");
        prefStore.setDefault(MS_PROJECT_NAMES, "");
        prefStore.setDefault(EXPORT_DIRECTORIES, ExportMSPUIPreferences.getDefaultExportDir());
    }

    public static boolean getPublishWebSite() {
        return prefStore.getBoolean(PUBLISH_WEBSITE);
    }

    public static void setPublishWebSite(boolean value) {
        prefStore.setValue(PUBLISH_WEBSITE, value);
    }

    public static boolean getPublishConfiguration() {
        return prefStore.getBoolean(PUBLISH_CONFIGURATION);
    }

    public static void setPublishConfiguration(boolean value) {
        prefStore.setValue(PUBLISH_CONFIGURATION, value);
    }

    public static boolean getExportOnlyPlannedWBSElements() {
        return prefStore.getBoolean(EXPORT_ONLY_PLANNED_WBS_ELEMENTS);
    }

    public static void setExportOnlyPlannedWBSElements(boolean value) {
        prefStore.setValue(EXPORT_ONLY_PLANNED_WBS_ELEMENTS, value);
    }

    public static String getProcessName() {
        return prefStore.getString(PROCESS_NAME);
    }

    public static void setProcessName(String value) {
        prefStore.setValue(PROCESS_NAME, value);
    }

    public static String getConfigurationName() {
        return prefStore.getString(CONFIGURATION_NAME);
    }

    public static void setConfigurationName(String value) {
        prefStore.setValue(CONFIGURATION_NAME, value);
    }

    public static String[] getMSProjectNames() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)MS_PROJECT_NAMES);
    }

    public static List<String> getMSProjectNamesList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)MS_PROJECT_NAMES);
    }

    public static void addMSProjectName(String name) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)MS_PROJECT_NAMES, (String)name);
    }

    public static String getDefaultExportDir() {
        if (defaultExportDir == null) {
            defaultExportDir = System.getProperty("user.home");
            String appName = LibraryUIPreferences.getApplicationShortName();
            defaultExportDir = appName != null && appName.length() > 0 ? String.valueOf(defaultExportDir) + FileUtil.FILE_SEP + appName + FileUtil.FILE_SEP + DEFAULT_EXPORT_DIR_NAME : String.valueOf(defaultExportDir) + FileUtil.FILE_SEP + DEFAULT_EXPORT_DIR_NAME;
        }
        return defaultExportDir;
    }

    public static String[] getExportDirectories() {
        return PreferenceUtil.getStringValues((IPreferenceStore)prefStore, (String)EXPORT_DIRECTORIES);
    }

    public static List<String> getExportDirectoriesList() {
        return PreferenceUtil.getList((IPreferenceStore)prefStore, (String)EXPORT_DIRECTORIES);
    }

    public static void addExportDir(String dir) {
        PreferenceUtil.addToList((IPreferenceStore)prefStore, (String)EXPORT_DIRECTORIES, (String)dir);
    }
}

