/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;

public class DirCopy {
    File srcDir;
    File targetDir;
    List newFiles = new ArrayList();
    List oldFiles = new ArrayList();
    List deletedFiles = new ArrayList();
    private static String CP_FODLER = "capabilitypatterns/";
    private static String DP_FODLER = "deliveryprocesses/";
    private static final String CVS_FOLDER = String.valueOf(File.separator) + "CVS" + File.separator;
    private static final String SVN_FOLDER = String.valueOf(File.separator) + ".svn" + File.separator;
    private static final String[] ignoreFiles = new String[]{".copyarea.dat", ".copyarea.db"};

    public DirCopy(File srcDir, File targetDir) {
        this.srcDir = srcDir;
        this.targetDir = targetDir;
        this.prepare();
    }

    public IStatus execute() {
        ArrayList<String> files = new ArrayList<String>();
        for (String path : this.oldFiles) {
            if (!DirCopy.needCopy(new File(this.srcDir, path), new File(this.targetDir, path))) continue;
            files.add(new File(this.targetDir, path).getAbsolutePath());
        }
        IStatus fileCheckedOutStatus = FileModifyChecker.checkModify(files);
        if (!fileCheckedOutStatus.isOK()) {
            return fileCheckedOutStatus;
        }
        IFileManager fileMgr = Services.getFileManager();
        for (String path : this.deletedFiles) {
            File folder;
            String[] items;
            File f = new File(this.targetDir, path);
            fileMgr.delete(f.getAbsolutePath());
            path = path.replace(File.separatorChar, '/');
            if (!path.startsWith(CP_FODLER) && !path.startsWith(DP_FODLER) || (items = (folder = f.getParentFile()).list()) != null && items.length != 0) continue;
            fileMgr.delete(folder.getAbsolutePath());
        }
        for (String path : this.oldFiles) {
            FileUtil.copyFile((File)new File(this.srcDir, path), (File)new File(this.targetDir, path));
        }
        for (String path : this.newFiles) {
            FileUtil.copyFile((File)new File(this.srcDir, path), (File)new File(this.targetDir, path));
        }
        return fileCheckedOutStatus;
    }

    private void prepare() {
        List allSrcFiles = this.getAllFiles(this.srcDir);
        List allTargetFiles = this.getAllFiles(this.targetDir);
        while (allTargetFiles.size() > 0) {
            String path = (String)allTargetFiles.remove(0);
            if (allSrcFiles.contains(path)) {
                this.oldFiles.add(path);
                allSrcFiles.remove(path);
                continue;
            }
            this.deletedFiles.add(path);
        }
        this.newFiles.addAll(allSrcFiles);
    }

    private List getAllFiles(File dir) {
        ArrayList<String> files = new ArrayList<String>();
        FileUtil.getAllFiles((File)dir, files, (boolean)true);
        URI baseUrl = dir.toURI();
        int i = 0;
        while (i < files.size()) {
            File f = (File)files.get(i);
            if (this.canIgnore(f.getAbsolutePath()) || this.canIgnore(f)) {
                files.remove(i);
                continue;
            }
            URI rel = baseUrl.relativize(f.toURI());
            files.set(i, rel.getPath());
            ++i;
        }
        return files;
    }

    private boolean canIgnore(String path) {
        if (path.indexOf(CVS_FOLDER) >= 0) {
            return true;
        }
        return path.indexOf(SVN_FOLDER) >= 0;
    }

    private boolean canIgnore(File file) {
        String name = file.getName();
        int i = 0;
        while (i < ignoreFiles.length) {
            if (name.equals(ignoreFiles[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean needCopy(File source, File dest) {
        boolean ret = true;
        if (dest.exists()) {
            ret = dest.lastModified() != source.lastModified() || dest.length() != source.length();
        }
        return ret;
    }
}

