/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.IActivator;
import org.eclipse.epf.common.ui.util.MsgDialog;
import org.eclipse.epf.export.services.DiagramHandler;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.ElementDiffTree;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.importing.services.LibraryDiffManager;
import org.eclipse.epf.importing.services.ResourceScanner;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileXMIHelperImpl;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.DiagramElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.util.UmaUtil;

public class LibraryImportManager {
    private Map<String, String> renamePluginMap = new HashMap<String, String>();
    private Map renameElementMap = new HashMap();
    private Map setElementMap = null;
    private LibraryDiffManager diffMgr;
    private ElementDiffTree rootTree;
    private boolean configFolderError = false;
    private MethodLibrary baseLibrary = null;
    private MethodLibrary importingLibrary = null;
    private Map replacedElementMap = new HashMap();
    private List newElements = new ArrayList();
    private List deletedElements = new ArrayList();
    private boolean debug = ImportPlugin.getDefault().isDebugging();
    List checkedList = new ArrayList();
    IStatus fileCheckedOutStatus = null;
    List newResources = new ArrayList();
    ResourceScanner resScanner;
    private DiagramHandler diagramHandler;
    static MethodElement newCont = null;
    static MethodElement newElem = null;
    private List processedNewElements = new ArrayList();

    public LibraryImportManager(LibraryDiffManager diffMgr, List checkedItems) {
        this.diffMgr = diffMgr;
        this.rootTree = diffMgr.getDiffTree();
        if (checkedItems != null) {
            this.checkedList.addAll(checkedItems);
            for (ElementDiffTree diffTree : checkedItems) {
                MethodPackage pkg;
                List children;
                MethodElement e = diffTree.getBaseElement();
                if (e != null) {
                    this.checkedList.add(e);
                }
                if (e instanceof ProcessComponent) {
                    LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)e), (List)this.checkedList);
                }
                if (e instanceof MethodPackage && (children = ((MethodPackage)e).getChildPackages()).size() == 1 && TngUtil.isRootCutomCategoryPackage((MethodPackage)(pkg = (MethodPackage)children.get(0)))) {
                    this.checkedList.add(pkg);
                }
                if ((e = diffTree.getImportElement()) != null) {
                    this.checkedList.add(e);
                }
                if (e instanceof ProcessComponent) {
                    LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)e), (List)this.checkedList);
                }
                if (!diffTree.isNew()) continue;
                if (e instanceof MethodPlugin) {
                    this.checkedList.addAll(LibraryUtil.getAllPackages((MethodPlugin)((MethodPlugin)e)));
                    continue;
                }
                if (!(e instanceof MethodPackage)) continue;
                LibraryUtil.getAllChildPackages((MethodPackage)((MethodPackage)e), (List)this.checkedList);
            }
        } else {
            this.checkedList = null;
        }
        this.init();
        this.baseLibrary = (MethodLibrary)this.rootTree.getBaseElement();
        this.importingLibrary = (MethodLibrary)this.rootTree.getImportElement();
        this.resScanner = new ResourceScanner(LibraryUtil.getLibraryRootPath((MethodLibrary)this.importingLibrary), LibraryUtil.getLibraryRootPath((MethodLibrary)this.baseLibrary), this.renamePluginMap);
        this.diagramHandler = new DiagramHandler(LibraryUtil.getLibraryRootPath((MethodLibrary)this.importingLibrary), LibraryUtil.getLibraryRootPath((MethodLibrary)this.baseLibrary)){

            protected File[] getFiles(MethodElement elem) {
                return super.getFiles(elem, false);
            }
        };
    }

    private void init() {
    }

    private boolean isSelected(ElementDiffTree diffTree) {
        if (this.checkedList == null || this.checkedList.contains(diffTree)) {
            return true;
        }
        MethodElement e = diffTree.getBaseElement();
        if (e == null) {
            e = diffTree.getImportElement();
        }
        return this.isSelected(e);
    }

    private boolean isSelected(MethodElement e) {
        if (this.checkedList == null || e instanceof ContentDescription || e.eContainer() instanceof ContentDescription || e instanceof MethodLibrary) {
            return true;
        }
        if (this.checkedList.size() == 0) {
            return false;
        }
        if (e instanceof MethodConfiguration) {
            return this.checkedList.contains(e);
        }
        MethodElement o = (MethodElement)LibraryUtil.getSelectable((EObject)e);
        if (o == null) {
            return false;
        }
        if (o instanceof MethodLibrary) {
            return true;
        }
        return this.checkedList.contains(o);
    }

    public void doMerge(boolean replaceExisting, IProgressMonitor monitor) throws Exception {
        List unlockedPlugins;
        this.configFolderError = false;
        if (this.debug) {
            System.out.println("Merging configuration ...");
        }
        if (this.debug) {
            System.out.println("loading library ...");
        }
        if (!(unlockedPlugins = this.unlockPlugins()).isEmpty() && this.fileCheckedOutStatus != null && !this.fileCheckedOutStatus.isOK()) {
            this.fileCheckOutError();
            return;
        }
        LibraryUtil.loadAll((MethodLibrary)this.baseLibrary);
        LibraryUtil.loadAll((MethodLibrary)this.importingLibrary);
        LibraryUtil.detachFromResource((MethodLibrary)this.importingLibrary);
        this.importingLibrary.setName("ImportingLib: " + this.importingLibrary.getName());
        if (this.debug) {
            System.out.println("Process configuration diff tree ...");
        }
        ArrayList oldResources = new ArrayList(this.baseLibrary.eResource().getResourceSet().getResources());
        this.processDiffTree(this.rootTree, replaceExisting);
        this.handleSetElements();
        if (this.debug) {
            System.out.println("perform integrity checking ...");
        }
        this.doIntegrityCheck();
        this.handleNewResources(oldResources);
        LibraryImportManager.handleNameReplace(this.renameElementMap);
        this.diagramHandler.postRegisterElements();
        if (this.debug) {
            System.out.println("check out files ...");
        }
        this.deleteResoruces();
        this.checkModifiedFiles();
        if (this.fileCheckedOutStatus.isOK()) {
            if (this.debug) {
                System.out.println("copying resource files ...");
            }
            this.resScanner.execute();
            this.diagramHandler.execute();
            if (this.debug) {
                System.out.println("saving library ...");
            }
            if (!this.configFolderError) {
                if (unlockedPlugins.size() > 0) {
                    LibraryImportManager.lockUnlockedPlugins(unlockedPlugins);
                }
                LibraryUtil.saveLibrary((MethodLibrary)this.baseLibrary, (boolean)false, (boolean)false);
            }
        } else {
            this.fileCheckOutError();
        }
        if (this.debug) {
            System.out.println("Merging configuration done...");
        }
    }

    private void fileCheckOutError() {
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                String title = ImportResources.importConfigWizard_title;
                String msg = ImportResources.ImportConfigurationWizard_ERR_Import_configuration;
                new MsgDialog((IActivator)ImportPlugin.getDefault()).displayError(title, msg, LibraryImportManager.this.fileCheckedOutStatus);
            }
        });
        if (this.debug) {
            System.out.println("Checkout files failed ...");
        }
    }

    private void handleNewResources(List oldResources) {
        for (Resource res : this.baseLibrary.eResource().getResourceSet().getResources()) {
            if (oldResources.contains(res)) continue;
            this.logNewResource(res);
        }
    }

    private void processDiffTree(ElementDiffTree diffTree, boolean replaceExisting) throws Exception {
        List children;
        if (diffTree == null || !this.isSelected(diffTree)) {
            return;
        }
        int state = diffTree.getDiffState();
        MethodElement base = diffTree.getBaseElement();
        MethodElement imp = diffTree.getImportElement();
        if (replaceExisting && state == 4) {
            if (base instanceof MethodConfiguration) {
                this.doReplaceConfiguration((MethodConfiguration)base, (MethodConfiguration)imp);
            } else if (base instanceof MethodPlugin) {
                this.doReplacePlugin((MethodPlugin)base, (MethodPlugin)imp);
            } else if (base instanceof MethodPackage) {
                this.doReplacePackage((MethodPackage)base, (MethodPackage)imp);
            } else if (this.debug) {
                System.out.println("What is this: " + LibraryUtil.getTypeName((MethodElement)base));
            }
        } else if (state == 1) {
            this.doAdd((EObject)diffTree.getBaseParentElement(), diffTree.getImportElement());
        }
        if (state != 1 && (children = diffTree.getChildren()) != null && children.size() > 0) {
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.processDiffTree((ElementDiffTree)it.next(), replaceExisting);
            }
        }
    }

    private void doReplaceConfiguration(MethodConfiguration oldObj, MethodConfiguration newObj) {
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        List features = LibraryUtil.getStructuralFeatures((MethodElement)oldObj);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                Object newValue = newObj.eGet(feature);
                this.setFeatureValue((MethodElement)oldObj, feature, newValue, false);
                ++i;
            }
        }
    }

    private void doReplacePlugin(MethodPlugin oldObj, MethodPlugin newObj) {
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        List features = LibraryUtil.getStructuralFeatures((MethodElement)oldObj);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPlugin_MethodPackages()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue((MethodElement)oldObj, feature, newValue, true);
                }
                ++i;
            }
        }
    }

    private void doReplacePackage(MethodPackage oldObj, MethodPackage newObj) {
        if (this.isReplaced((MethodElement)oldObj)) {
            return;
        }
        this.setReplaced((MethodElement)oldObj);
        if (this.debug) {
            System.out.println("Replacing package " + LibraryUtil.getTypeName((MethodElement)oldObj));
        }
        List features = LibraryUtil.getStructuralFeatures((MethodElement)oldObj);
        boolean isProcessPackage = oldObj instanceof ProcessPackage;
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPackage_ChildPackages() || isProcessPackage) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue((MethodElement)oldObj, feature, newValue, true);
                }
                ++i;
            }
        }
    }

    private void doReplaceElement(MethodElement oldObj, MethodElement newObj) {
        List features;
        if (this.isReplaced(oldObj)) {
            return;
        }
        if (this.diffMgr.selectable(oldObj)) {
            return;
        }
        if (!this.isSelected(oldObj)) {
            return;
        }
        if (oldObj instanceof ContentDescription && newObj instanceof ContentDescription && LibraryUtil.isIdentical((MethodElement)((ContentDescription)oldObj), (MethodElement)((ContentDescription)newObj))) {
            Resource res;
            if (this.debug && (res = oldObj.eResource()) != null) {
                System.out.println("Identical element not replaced: " + res.getURI().toFileString());
            }
            this.scanResources(oldObj, true);
            return;
        }
        this.setReplaced(oldObj);
        if (this.debug) {
            System.out.println("Replacing element " + LibraryUtil.getTypeName((MethodElement)oldObj));
        }
        if ((features = LibraryUtil.getStructuralFeatures((MethodElement)oldObj)) != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                if (feature != UmaPackage.eINSTANCE.getMethodPlugin_MethodPackages() && feature != UmaPackage.eINSTANCE.getMethodPackage_ChildPackages() && !feature.isDerived()) {
                    Object newValue = newObj.eGet(feature);
                    this.setFeatureValue(oldObj, feature, newValue, true);
                }
                ++i;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private void setFeatureValue(MethodElement element, EStructuralFeature feature, Object newValue, boolean doDelete) {
        block35: {
            if (this.canIgnore(feature)) {
                return;
            }
            oldNotify = element.eDeliver();
            try {
                element.eSetDeliver(false);
                if (this.canReset(feature)) {
                    element.eSet(feature, newValue);
                    break block35;
                }
                if (!feature.isMany() || !(newValue instanceof List)) ** GOTO lbl51
                oldValue = (List)element.eGet(feature);
                if (feature.getName().equals("methodElementProperty")) {
                    this.setMepFeatureValue(element, feature, oldValue, (List)newValue);
                    return;
                }
                try {
                    diff = new ElementListDiff(oldValue, (List)newValue);
                    if (doDelete && diff.deletedItems.size() > 0) {
                        oldValue.removeAll(diff.deletedItems);
                        this.logRemovedElements(diff.deletedItems);
                        if (this.debug) {
                            System.out.println("  Deleting feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", values: " + diff.deletedItems);
                        }
                    }
                    if (diff.newItems.size() > 0) {
                        for (MethodElement newObj : diff.newItems) {
                            if (!this.isSelected(newObj)) continue;
                            oldObj = this.diffMgr.getExistingElement(newObj.getGuid());
                            if (oldObj == null) {
                                oldValue.add(newObj);
                                this.logNewElementUnderExistingPlugin(newObj);
                                continue;
                            }
                            oldValue.add(oldObj);
                            this.doReplaceElement(oldObj, newObj);
                        }
                        if (this.debug) {
                            System.out.println("  Adding feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", values: " + diff.newItems);
                        }
                    }
                    if (diff.oldNewMap.size() > 0) {
                        for (Map.Entry<K, V> entry : diff.oldNewMap.entrySet()) {
                            oldObj = (MethodElement)entry.getKey();
                            if (!this.isSelected(oldObj)) continue;
                            newObj = (MethodElement)entry.getValue();
                            if (this.canReset(oldObj)) {
                                if (this.debug) {
                                    System.out.println("  Resetting feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", value: " + LibraryUtil.getTypeName((MethodElement)oldObj));
                                }
                                EcoreUtil.replace((EObject)element, (EStructuralFeature)feature, (Object)oldObj, (Object)newObj);
                                this.logResetElement(newObj);
                                continue;
                            }
                            this.doReplaceElement(oldObj, newObj);
                        }
                    }
                    break block35;
lbl51:
                    // 1 sources

                    if (newValue instanceof MethodElement) {
                        o = (MethodElement)element.eGet(feature);
                        n = (MethodElement)newValue;
                        if ((o == null || this.isSelected(o)) && this.isSelected(n)) {
                            if (this.debug) {
                                System.out.println("  Replacinging feature value, feature: " + feature.getName() + ",  element: " + LibraryUtil.getTypeName((MethodElement)element) + ", value: " + LibraryUtil.getTypeName((MethodElement)o));
                            }
                            if (newValue instanceof ContentDescription) {
                                if (o.eContainer() != null || n.eContainer() != null) {
                                    if (o.eContainer() == null) {
                                        element.eSet(feature, (Object)o);
                                    }
                                    this.doReplaceElement(o, n);
                                }
                            } else if (this.canReset(n)) {
                                element.eSet(feature, newValue);
                                this.logNewElementUnderExistingPlugin(n);
                            } else if (o != null && n != null && o.getGuid().equals(n.getGuid())) {
                                this.doReplaceElement(o, n);
                            } else {
                                this.registerSetElement(element, feature, newValue);
                                element.eSet(feature, newValue);
                                this.logNewElementUnderExistingPlugin(n);
                            }
                        }
                    } else if (feature == UmaPackage.eINSTANCE.getNamedElement_Name()) {
                        if (!(newValue instanceof String)) {
                            throw new UnsupportedOperationException();
                        }
                        oldName = (String)element.eGet(feature);
                        if (!newValue.equals(oldName)) {
                            LibraryImportManager.ensureUniqueNameForExistingElement(element, oldName, (String)newValue, this.renameElementMap);
                        }
                    } else {
                        element.eSet(feature, newValue);
                        this.scanResources(element, feature, newValue);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            finally {
                element.eSetDeliver(oldNotify);
            }
        }
    }

    private void setMepFeatureValue(MethodElement element, EStructuralFeature feature, List oldValue, List newValue) {
        int sz = newValue.size();
        if (oldValue.size() == sz) {
            if (sz == 0) {
                return;
            }
            boolean same = true;
            int i = 0;
            while (i < sz) {
                MethodElementProperty oldMep = (MethodElementProperty)oldValue.get(i);
                MethodElementProperty newMep = (MethodElementProperty)newValue.get(i);
                if (!oldMep.getName().equals(newMep.getName()) || !oldMep.getValue().equals(newMep.getValue())) {
                    same = false;
                    break;
                }
                ++i;
            }
            if (same) {
                return;
            }
        }
        oldValue.removeAll(oldValue);
        oldValue.addAll(newValue);
    }

    private void scanResources(MethodElement element, boolean recursive) {
        if (element == null) {
            return;
        }
        List features = LibraryUtil.getStructuralFeatures((MethodElement)element);
        if (features != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                if (feature instanceof EAttribute) {
                    Object value = element.eGet(feature);
                    this.scanResources(element, feature, value);
                }
                ++i;
            }
        }
        if (!recursive) {
            return;
        }
        TreeIterator it = element.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj instanceof MethodLibrary || obj instanceof MethodPlugin || obj instanceof MethodPackage || obj instanceof MethodConfiguration || !(obj instanceof MethodElement)) continue;
            this.scanResources((MethodElement)obj, false);
        }
    }

    private void scanResources(MethodElement element, EStructuralFeature feature, Object newValue) {
        this.diagramHandler.registerElement(element);
        if (feature == UmaPackage.eINSTANCE.getGuidanceDescription_Attachments()) {
            String urls = (String)newValue;
            if (urls != null && urls.length() != 0) {
                StringTokenizer st = new StringTokenizer(urls, "|");
                while (st.hasMoreTokens()) {
                    String url = st.nextToken();
                    this.resScanner.copyResource(element, url);
                }
            }
        } else if (newValue instanceof String) {
            this.resScanner.scan(element, newValue.toString());
        } else if (newValue instanceof URI) {
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)element);
            this.resScanner.copyResource(((URI)newValue).getPath(), plugin);
        }
    }

    private void doAdd(EObject owner, MethodElement newObj) throws Exception {
        if (this.debug) {
            System.out.println("Adding element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if (owner == null) {
            return;
        }
        LibraryImportManager.ensureUniqueName(owner, newObj, this.renameElementMap);
        boolean error = false;
        if (owner instanceof MethodLibrary) {
            if (newObj instanceof MethodPlugin) {
                MethodPlugin plugin = (MethodPlugin)newObj;
                this.checkModifiedFiles();
                boolean bl = error = !this.fileCheckedOutStatus.isOK();
                if (!error) {
                    ((MethodLibrary)owner).getMethodPlugins().add(plugin);
                    try {
                        MultiFileXMIHelperImpl.unmodifiedGetValue = true;
                        LibraryUtil.saveLibrary((MethodLibrary)((MethodLibrary)owner), (boolean)false, (boolean)false);
                    }
                    finally {
                        MultiFileXMIHelperImpl.unmodifiedGetValue = false;
                    }
                }
            } else if (newObj instanceof MethodConfiguration) {
                this.checkModifiedFiles();
                boolean bl = error = this.configFolderError || !this.fileCheckedOutStatus.isOK();
                if (!error) {
                    MethodLibrary lib = (MethodLibrary)owner;
                    lib.getPredefinedConfigurations().add((MethodConfiguration)newObj);
                    ILibraryPersister persister = ((MultiFileResourceSetImpl)lib.eResource().getResourceSet()).getPersister();
                    if (persister instanceof IFileBasedLibraryPersister) {
                        IFileBasedLibraryPersister ip = (IFileBasedLibraryPersister)persister;
                        File configFolder = ip.getDefaultMethodConfigurationFolder(lib);
                        if (configFolder != null) {
                            ip.setDefaultMethodConfigurationFolder(lib, configFolder);
                        } else {
                            error = true;
                            this.configFolderError = true;
                        }
                    }
                    if (!error) {
                        try {
                            MultiFileXMIHelperImpl.unmodifiedGetValue = true;
                            LibraryUtil.saveLibrary((MethodLibrary)((MethodLibrary)owner), (boolean)false, (boolean)false);
                        }
                        finally {
                            MultiFileXMIHelperImpl.unmodifiedGetValue = false;
                        }
                    }
                }
            } else {
                error = true;
            }
        } else if (owner instanceof MethodPackage && owner.eContainer() != null && newObj instanceof MethodPackage) {
            ((MethodPackage)owner).getChildPackages().add((MethodPackage)newObj);
        } else {
            error = true;
        }
        if (error) {
            String ownerStr = owner instanceof MethodElement ? LibraryUtil.getTypeName((MethodElement)((MethodElement)owner)) : owner.toString();
            String msg = "can't add " + LibraryUtil.getTypeName((MethodElement)newObj) + " to " + ownerStr;
            ImportPlugin.getDefault().getLogger().logError(msg);
            if (this.debug) {
                System.out.println(msg);
            }
        } else {
            this.logNewElement(newObj);
        }
    }

    private boolean checkModifiedConfigs(MethodPlugin plugin) {
        List configList = LibraryUtil.getAssociatedConfigurations((MethodPlugin)plugin);
        List baseConfigs = this.baseLibrary.getPredefinedConfigurations();
        HashMap<String, MethodConfiguration> baseConfigMap = new HashMap<String, MethodConfiguration>();
        int i = 0;
        while (i < baseConfigs.size()) {
            MethodConfiguration config = (MethodConfiguration)baseConfigs.get(i);
            baseConfigMap.put(config.getGuid(), config);
            ++i;
        }
        final ArrayList<String> modifiedFiles = new ArrayList<String>();
        int i2 = 0;
        while (i2 < configList.size()) {
            Resource res;
            MethodConfiguration config = (MethodConfiguration)configList.get(i2);
            if ((config = (MethodConfiguration)baseConfigMap.get(config.getGuid())) != null && (res = config.eResource()) != null) {
                modifiedFiles.add(res.getURI().toFileString());
            }
            ++i2;
        }
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                LibraryImportManager.this.fileCheckedOutStatus = FileModifyChecker.checkModify(modifiedFiles);
            }
        });
        this.fileCheckOutError();
        return this.fileCheckedOutStatus.isOK();
    }

    private void doIntegrityCheck() {
        while (this.newElements.size() > 0) {
            MethodElement newObj = (MethodElement)this.newElements.remove(0);
            try {
                if (newObj instanceof DiagramElement) {
                    this.fixDiagram((DiagramElement)newObj);
                    continue;
                }
                this.fixNewElementReferences(newObj);
            }
            catch (Exception e) {
                if (this.debug) {
                    System.out.println("Exception while fixing new element " + LibraryUtil.getTypeName((MethodElement)newObj));
                }
                e.printStackTrace();
            }
        }
        List configs = this.baseLibrary.getPredefinedConfigurations();
        for (MethodConfiguration config : configs) {
            LibraryUtil.validateMethodConfiguration(null, (MethodConfiguration)config);
        }
    }

    private void fixNewElementReferences(MethodElement newObj) {
        List features;
        if (this.processedNewElements.contains(newObj)) {
            return;
        }
        this.processedNewElements.add(newObj);
        if (this.debug) {
            System.out.println("Fixing element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if ((features = LibraryUtil.getStructuralFeatures((MethodElement)newObj)) != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                Object value = newObj.eGet(feature);
                if (value instanceof List) {
                    for (Object o : new ArrayList((List)value)) {
                        this.fixNewElementFeatureValue(newObj, feature, o);
                    }
                } else {
                    this.fixNewElementFeatureValue(newObj, feature, value);
                }
                ++i;
            }
        }
    }

    private void fixDiagram(DiagramElement newObj) {
        List features;
        if (this.processedNewElements.contains(newObj)) {
            return;
        }
        this.processedNewElements.add(newObj);
        if (this.debug) {
            System.out.println("Fixing diagram element " + LibraryUtil.getTypeName((MethodElement)newObj));
        }
        if ((features = LibraryUtil.getStructuralFeatures((MethodElement)newObj)) != null) {
            int i = 0;
            while (i < features.size()) {
                EStructuralFeature feature = (EStructuralFeature)features.get(i);
                Object value = newObj.eGet(feature);
                if (value instanceof List) {
                    for (Object o : new ArrayList((List)value)) {
                        if (!(o instanceof MethodElement)) continue;
                        if (feature == UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element()) {
                            this.fixNewElementFeatureValue((MethodElement)newObj, feature, o);
                            continue;
                        }
                        if (!(o instanceof DiagramElement)) continue;
                        this.fixDiagram((DiagramElement)o);
                    }
                } else if (value instanceof MethodElement) {
                    if (feature == UmaPackage.eINSTANCE.getUMASemanticModelBridge_Element()) {
                        this.fixNewElementFeatureValue((MethodElement)newObj, feature, value);
                    } else if (value instanceof DiagramElement) {
                        this.fixDiagram((DiagramElement)value);
                    }
                }
                ++i;
            }
        }
    }

    private void fixNewElementFeatureValue(MethodElement element, EStructuralFeature feature, Object obj) {
        block12: {
            if (!(obj instanceof MethodElement)) {
                return;
            }
            if (this.debug) {
                System.out.println("fixing element feature value " + LibraryUtil.getTypeName((MethodElement)element) + ", feature=" + feature.getName());
            }
            boolean oldNotify = element.eDeliver();
            try {
                try {
                    element.eSetDeliver(false);
                    MethodElement newObj = (MethodElement)obj;
                    MethodElement oldObj = this.getReplaced(newObj.getGuid());
                    if (oldObj == null) {
                        oldObj = this.diffMgr.getExistingElement(newObj.getGuid());
                    }
                    if (oldObj == null) {
                        this.fixNewElementReferences(newObj);
                        break block12;
                    }
                    try {
                        EcoreUtil.replace((EObject)element, (EStructuralFeature)feature, (Object)newObj, (Object)oldObj);
                    }
                    catch (Exception exception) {
                        EcoreUtil.remove((EObject)element, (EStructuralFeature)feature, (Object)newObj);
                        if (this.debug) {
                            System.out.println("Replaceing feature value failed for element [" + LibraryUtil.getTypeName((MethodElement)element) + "], feature [" + feature.getName() + "], value=" + newObj + ". The feature value is removed. ");
                        }
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    element.eSetDeliver(oldNotify);
                }
            }
            finally {
                element.eSetDeliver(oldNotify);
            }
        }
    }

    private boolean canReset(MethodElement e) {
        boolean reset = false;
        if (e == null || e instanceof DiagramElement) {
            reset = true;
        }
        return reset;
    }

    private boolean canReset(EStructuralFeature feature) {
        return false;
    }

    private boolean canIgnore(EStructuralFeature feature) {
        if (feature == UmaPackage.eINSTANCE.getMethodPlugin_UserChangeable()) {
            return true;
        }
        return feature == UmaPackage.eINSTANCE.getArtifact_ContainerArtifact();
    }

    private boolean isReplaced(MethodElement oldObj) {
        return this.replacedElementMap.containsKey(oldObj.getGuid());
    }

    private void setReplaced(MethodElement oldObj) {
        String guid = oldObj.getGuid();
        if (!this.replacedElementMap.containsKey(guid)) {
            this.replacedElementMap.put(guid, oldObj);
            this.setModified((EObject)oldObj);
        }
    }

    private MethodElement getReplaced(String guid) {
        return (MethodElement)this.replacedElementMap.get(guid);
    }

    private void copyNewElementResources(MethodElement newObj) {
        this.scanResources(newObj, true);
    }

    private void logNewElement(MethodElement newObj) {
        if (!this.newElements.contains(newObj) && this.diffMgr.getExistingElement(newObj.getGuid()) == null) {
            this.newElements.add(newObj);
            this.copyNewElementResources(newObj);
            this.setModified((EObject)newObj);
        }
    }

    private void logResetElement(MethodElement newObj) {
        if (!this.newElements.contains(newObj)) {
            this.newElements.add(newObj);
            this.setModified((EObject)newObj);
        }
    }

    private void logNewResource(Resource res) {
        if (res != null) {
            res.setModified(true);
            String file = res.getURI().toFileString();
            if (!this.newResources.contains(file)) {
                this.newResources.add(file);
            }
        }
    }

    private void logRemovedElements(List items) {
        if (items == null || items.size() == 0) {
            return;
        }
        for (MethodElement e : items) {
            if (e.eContainer() != null || this.deletedElements.contains(e)) continue;
            this.deletedElements.add(e);
        }
    }

    private void setModified(EObject obj) {
        Resource res;
        if (obj != null && (res = obj.eResource()) != null) {
            if (!res.isModified()) {
                res.setModified(true);
            }
            if (this.debug && res.isModified()) {
                System.out.println("Modified: " + res.getURI().toFileString());
            }
        }
    }

    private List getModifiedResources(MethodLibrary lib) {
        ArrayList<String> modifiedList = new ArrayList<String>();
        Resource res2 = lib.eResource();
        if (res2 != null) {
            ResourceSet resSet = res2.getResourceSet();
            for (Resource res2 : resSet.getResources()) {
                String file;
                if (res2 == null || !res2.isModified() || this.newResources.contains(file = res2.getURI().toFileString())) continue;
                if (this.debug) {
                    System.out.println("Resource modified: " + file);
                }
                modifiedList.add(file);
            }
        }
        return modifiedList;
    }

    private void deleteResoruces() {
        if (this.deletedElements.size() == 0) {
            return;
        }
        IFileManager fileMgr = Services.getFileManager();
        for (MethodElement e : this.deletedElements) {
            Resource res;
            ContentDescription obj = null;
            if (e instanceof DescribableElement) {
                obj = ((DescribableElement)e).getPresentation();
            } else if (e instanceof ContentDescription) {
                obj = e;
            }
            if (obj == null || (res = obj.eResource()) == null) continue;
            String file = res.getURI().toFileString();
            if (this.debug) {
                System.out.println("deleting resource: " + file);
            }
            if (fileMgr.delete(file) || !this.debug) continue;
            System.out.println("unable to delete file: " + file);
        }
    }

    public static void handleNameReplace(Map renameElementMap) {
        MethodElement element;
        Object[] val;
        for (Map.Entry entry : renameElementMap.entrySet()) {
            val = (Object[])entry.getValue();
            element = (MethodElement)val[0];
            String newName = val.length == 4 ? element.getGuid() : (String)val[1];
            LibraryImportManager.rename(element, newName);
            if (val.length != 4) continue;
            element = (MethodElement)val[2];
            newName = (String)val[3];
            LibraryImportManager.rename(element, newName);
            element = (MethodElement)val[0];
            newName = (String)val[1];
            LibraryImportManager.rename(element, newName);
        }
        for (Map.Entry entry : renameElementMap.entrySet()) {
            val = (Object[])entry.getValue();
            element = (MethodElement)val[0];
            element.eResource().setModified(true);
        }
    }

    private static void rename(MethodElement element, String newName) {
        if (newName.equals(element.getName())) {
            return;
        }
        if (element instanceof ContentDescription || element.eResource() == null) {
            element.setName(newName);
            if (element instanceof ProcessComponent) {
                Process proc = ((ProcessComponent)element).getProcess();
                proc.setName(newName);
            }
        } else {
            LibraryView.runRename((NamedElement)element, (String)newName);
        }
    }

    private void registerSetElement(MethodElement element, EStructuralFeature feature, Object newValue) {
        String guid0 = ((MethodElement)newValue).getGuid();
        String guid1 = element.getGuid();
        Object[] val = new Object[]{feature, newValue, element};
        if (this.setElementMap == null) {
            this.setElementMap = new HashMap();
        }
        this.setElementMap.put(String.valueOf(element.getName()) + guid0 + guid1, val);
    }

    private void handleSetElements() {
        if (this.setElementMap == null) {
            return;
        }
        for (Map.Entry entry : this.setElementMap.entrySet()) {
            Object[] val = (Object[])entry.getValue();
            EStructuralFeature feature = (EStructuralFeature)val[0];
            MethodElement newValue = (MethodElement)val[1];
            MethodElement element = (MethodElement)val[2];
            String guid = newValue.getGuid();
            MethodElement mergedValue = (MethodElement)this.replacedElementMap.get(guid);
            if (mergedValue == null || mergedValue == newValue) continue;
            element.eSet(feature, (Object)mergedValue);
        }
    }

    public static void ensureUniqueName(EObject owner, MethodElement newObj, Map renameElementMap) {
        String name;
        if (owner == null) {
            return;
        }
        Class<?> cls = newObj.getClass();
        HashMap<String, MethodElement> nameMap = new HashMap<String, MethodElement>();
        int i = 0;
        while (i < owner.eContents().size()) {
            Object oldObj = owner.eContents().get(i);
            if (oldObj.getClass() == cls && oldObj != newObj) {
                MethodElement oldElem = (MethodElement)oldObj;
                nameMap.put(oldElem.getName(), oldElem);
            }
            ++i;
        }
        String renamed = name = newObj.getName();
        while (nameMap.containsKey(renamed)) {
            renamed = String.valueOf(renamed) + "_renamed";
        }
        if (renamed != name) {
            newObj.setName(renamed);
            Object[] entryVal = new Object[]{newObj, name, nameMap.get(name), renamed};
            renameElementMap.put(newObj.getGuid(), entryVal);
        }
    }

    public static void ensureUniqueNameForExistingElement(MethodElement element, String oldName, String newName, Map renameElementMap) {
        EObject elementOwner = element.eContainer();
        if (elementOwner != null) {
            element.setName(newName);
            LibraryImportManager.ensureUniqueName(elementOwner, element, renameElementMap);
            if (!element.getName().equals(newName)) {
                return;
            }
            element.setName(oldName);
        }
        Object[] entryVal = new Object[]{element, newName};
        renameElementMap.put(element.getGuid(), entryVal);
    }

    private void checkModifiedFiles() {
        final List modifiedFiles = this.getModifiedResources(this.baseLibrary);
        modifiedFiles.addAll(this.resScanner.getFilesTobeReplaced());
        modifiedFiles.addAll(this.diagramHandler.getModifiedFiles());
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                LibraryImportManager.this.fileCheckedOutStatus = FileModifyChecker.checkModify(modifiedFiles);
            }
        });
    }

    private List unlockPlugins() {
        ArrayList<String> pluginIds = new ArrayList<String>();
        HashMap<String, MethodPlugin> map = new HashMap<String, MethodPlugin>();
        HashMap<String, MethodPlugin> guidMap = new HashMap<String, MethodPlugin>();
        List basePlugins = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        int i = 0;
        while (i < basePlugins.size()) {
            MethodPlugin plugin = (MethodPlugin)basePlugins.get(i);
            map.put(plugin.getName(), plugin);
            guidMap.put(plugin.getGuid(), plugin);
            ++i;
        }
        if (map.isEmpty()) {
            return pluginIds;
        }
        ArrayList<String> fileNameToCheck = new ArrayList<String>();
        List importPlugins = this.importingLibrary.getMethodPlugins();
        int i2 = 0;
        while (i2 < importPlugins.size()) {
            String name0;
            MethodPlugin plugin = (MethodPlugin)importPlugins.get(i2);
            String name = plugin.getName();
            String guid = plugin.getGuid();
            MethodPlugin basePlugin0 = (MethodPlugin)guidMap.get(guid);
            if (basePlugin0 != null && !(name0 = basePlugin0.getName()).equals(name)) {
                this.renamePluginMap.put(name0, name);
            }
            MethodPlugin basePlugin = (MethodPlugin)map.get(name);
            boolean toAdd = false;
            if (basePlugin != null && !basePlugin.getGuid().equals(guid) && !basePlugin.getUserChangeable().booleanValue()) {
                toAdd = true;
            } else {
                basePlugin = (MethodPlugin)guidMap.get(guid);
                if (basePlugin != null && !basePlugin.getUserChangeable().booleanValue()) {
                    toAdd = true;
                }
            }
            if (toAdd) {
                pluginIds.add(basePlugin.getGuid());
                basePlugin.setUserChangeable(new Boolean(true));
                Resource res = basePlugin.eResource();
                if (res != null && res.getURI() != null) {
                    String fileName = res.getURI().toFileString();
                    fileNameToCheck.add(fileName);
                }
            }
            ++i2;
        }
        if (fileNameToCheck.size() > 0) {
            final ArrayList<String> modifiedFiles = fileNameToCheck;
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    LibraryImportManager.this.fileCheckedOutStatus = FileModifyChecker.checkModify(modifiedFiles);
                }
            });
        }
        return pluginIds;
    }

    public static void lockUnlockedPlugins(List unlockedPlugins) {
        List plugins = LibraryService.getInstance().getCurrentMethodLibrary().getMethodPlugins();
        for (MethodPlugin plugin : plugins) {
            if (!unlockedPlugins.contains(plugin.getGuid())) continue;
            plugin.setUserChangeable(new Boolean(false));
        }
    }

    private void logNewElementUnderExistingPlugin(MethodElement newObj) {
        ILibraryResourceManager libResMgr = ResourceHelper.getResourceMgr((MethodElement)newObj);
        String pluginPath = libResMgr.getPhysicalPluginPath(newObj);
        if (pluginPath != null) {
            this.logNewElement(newObj);
        }
    }

    public class ElementListDiff {
        List newItems = new ArrayList();
        List deletedItems = new ArrayList();
        Map oldNewMap = new LinkedHashMap();

        public ElementListDiff(List oldList, List newList) {
            Map newListGuidMap = this.getGuidMap(newList);
            this.newItems.addAll(newList);
            for (MethodElement oldObj : oldList) {
                String guid = oldObj.getGuid();
                Object newObj = newListGuidMap.get(guid);
                if (newObj != null) {
                    this.oldNewMap.put(oldObj, newObj);
                    this.newItems.remove(newObj);
                    continue;
                }
                this.deletedItems.add(oldObj);
            }
        }

        private Map getGuidMap(List items) {
            HashMap<String, MethodElement> m = new HashMap<String, MethodElement>();
            for (MethodElement e : items) {
                m.put(e.getGuid(), e);
            }
            return m;
        }
    }
}

