/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.WorkProductComposite;
import org.eclipse.epf.diagram.model.WorkProductDescriptorNode;
import org.eclipse.epf.diagram.model.impl.ActivityDetailDiagramImpl;
import org.eclipse.epf.diagram.model.impl.DiagramImpl;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.diagram.model.impl.NodeContainerImpl;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Dimension;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Property;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.WorkProductDescriptor;

public class WorkProductCompositeImpl
extends NodeContainerImpl
implements WorkProductComposite {
    protected static final int TYPE_EDEFAULT = 0;
    protected int type = 0;
    private TaskNode taskNode;

    protected WorkProductCompositeImpl() {
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.WORK_PRODUCT_COMPOSITE;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int newType) {
        int oldType = this.type;
        this.type = newType;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 8, oldType, this.type));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 8: {
                return new Integer(this.getType());
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 8: {
                this.setType((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 8: {
                this.setType(0);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 8: {
                return this.type != 0;
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (type: ");
        result.append(this.type);
        result.append(')');
        return result.toString();
    }

    private IFilter getFilter() {
        DiagramImpl diagram = (DiagramImpl)this.getDiagram();
        if (diagram.filter == null) {
            ConfigurableComposedAdapterFactory adapterFactory = (ConfigurableComposedAdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
            return adapterFactory.getFilter();
        }
        return diagram.filter;
    }

    public void setObject(Object newObject) {
        super.setObject(newObject);
        this.populateNodes(newObject);
    }

    protected void basicSetObject(Object newObject) {
        super.basicSetObject(newObject);
        if (this.isGraphicalDataRequired()) {
            if (this.type == 0) {
                List list = this.graphNode.getList(12);
                Property property = GraphicalDataHelper.getPropertyByKey(list, "wpCompositeType");
                if (property != null) {
                    property.setValue(property.getValue());
                    list.add(property);
                }
            } else {
                List list = this.graphNode.getList(12);
                Property property = GraphicalDataHelper.getPropertyByKey(list, "wpCompositeType");
                if (property != null) {
                    property.setValue(new Integer(this.getType()).toString());
                    list.add(property);
                }
            }
        }
    }

    private WorkProductDescriptorNode createWorkProductDescriptorNode(WorkProductDescriptor wpd) {
        WorkProductDescriptorNode wpdNode = null;
        for (Node node : this.getNodes()) {
            if (!(node instanceof WorkProductDescriptorNode) || node.getLinkedElement() != wpd) continue;
            wpdNode = (WorkProductDescriptorNode)node;
        }
        if (wpdNode == null) {
            wpdNode = ModelFactory.eINSTANCE.createWorkProductDescriptorNode();
            wpdNode.setDiagram(this.getDiagram());
        }
        wpdNode.setObject(wpd);
        return wpdNode;
    }

    public void populateNodes(Object newObject) {
        if (newObject instanceof TaskDescriptor) {
            ArrayList wplist = new ArrayList();
            if (this.getType() == 1) {
                if (!((TaskDescriptor)newObject).getMandatoryInput().isEmpty()) {
                    wplist.addAll(((TaskDescriptor)newObject).getMandatoryInput());
                }
            } else if (!((TaskDescriptor)newObject).getOutput().isEmpty()) {
                wplist.addAll(((TaskDescriptor)newObject).getOutput());
            }
            IFilter filter = this.getFilter();
            Collection allElements = ((ActivityDetailDiagramImpl)this.getDiagram()).getAllBreakdownElements(false);
            AdapterFactory adapterFactory = this.getAdapterFactory();
            ArrayList<Node> nodes = new ArrayList<Node>();
            Suppression suppression = this.getDiagram().getSuppression();
            for (WorkProductDescriptor wpDescriptor : wplist) {
                if (filter != null && !filter.accept((Object)wpDescriptor)) continue;
                Object wrapper = null;
                for (Object element : allElements) {
                    if (TngUtil.unwrap(element) != wpDescriptor) continue;
                    wrapper = element;
                }
                if (wrapper == null && adapterFactory != null) {
                    wrapper = adapterFactory.adapt((Notifier)wpDescriptor, ITreeItemContentProvider.class);
                }
                if (wrapper == null) {
                    wrapper = wpDescriptor;
                }
                if (suppression.isSuppressed(wrapper)) continue;
                Node node = GraphicalDataHelper.findNode(this, (Object)wpDescriptor);
                if (node == null) {
                    node = this.createWorkProductDescriptorNode(wpDescriptor);
                } else {
                    node.setObject(wpDescriptor);
                }
                ((NamedNodeImpl)node).setItemProvider(allElements);
                nodes.add(node);
            }
            this.selectNodes(nodes);
        }
    }

    public void addNode(Collection collection) {
        ArrayList nodes = new ArrayList();
        for (WorkProductDescriptor descriptor : collection) {
            this.addNode(nodes, descriptor);
        }
        this.getNodes().addAll(nodes);
    }

    public void removeNode(Object oldValue) {
        HashSet<Node> removedNodes = new HashSet<Node>();
        if (oldValue instanceof TaskDescriptor) {
            Node node = this.findNode((ActivityDetailDiagram)this.getDiagram(), this.getObject());
            this.getDiagram().getNodes().remove((Object)node);
        }
        Iterator iter = this.nodes.iterator();
        while (iter.hasNext()) {
            Node node = (Node)iter.next();
            if (node.getObject() != oldValue) continue;
            iter.remove();
            removedNodes.add(node);
        }
    }

    public void addNode(Object descriptor) {
        this.addNode((Collection)this.getNodes(), descriptor);
    }

    private void addNode(Collection nodes, Object descriptor) {
        Node node;
        if (descriptor instanceof TaskDescriptor && (node = this.findNode((ActivityDetailDiagram)this.getDiagram(), descriptor)) == null) {
            node = ((ActivityDetailDiagramImpl)this.getDiagram()).createWorkProductComposite((TaskDescriptor)descriptor, this.type);
            this.getDiagram().getNodes().add((Object)node);
        }
        if (descriptor instanceof WorkProductDescriptor) {
            ActivityDetailDiagramImpl diagram = (ActivityDetailDiagramImpl)this.getDiagram();
            Node node2 = GraphicalDataHelper.findNode(this, descriptor);
            if (node2 == null) {
                if (descriptor instanceof WorkProductDescriptor) {
                    node2 = diagram.createNode((WorkProductDescriptor)descriptor);
                }
                nodes.add(node2);
            }
        }
    }

    public Class getMethodElementAdapterType() {
        return TaskDescriptorAdapter.class;
    }

    public Point getLocation() {
        if (this.getType() == 1) {
            return super.getLocation();
        }
        if (this.getType() == 2) {
            return super.getLocation();
        }
        return new Point(-1, -1);
    }

    public GraphNode getGraphNode(MethodElement methodElement) {
        if (this.isGraphicalDataRequired()) {
            if (this.getUMADiagram() == null) {
                return this.createGraphNode(methodElement);
            }
            GraphNode node = this.findGraphNode(this.getUMADiagram(), methodElement);
            if (node == null) {
                node = this.createGraphNode(methodElement);
                this.getUMADiagram().getContained().add(node);
            }
            return node;
        }
        return null;
    }

    public GraphNode findGraphNode(org.eclipse.epf.uma.Diagram diagram, Object methodElement) {
        for (GraphNode element : diagram.getContained()) {
            String typeString;
            List list;
            Property property;
            if (!(element.getSemanticModel() instanceof UMASemanticModelBridge) || methodElement != ((UMASemanticModelBridge)element.getSemanticModel()).getElement() || (property = GraphicalDataHelper.getPropertyByKey(list = element.getList(12), "wpCompositeType")) == null || (typeString = property.getValue()) == null || this.getType() != new Integer(typeString).intValue()) continue;
            return element;
        }
        return null;
    }

    private GraphNode createGraphNode(MethodElement element) {
        GraphNode graphNode = UmaFactory.eINSTANCE.createGraphNode();
        UMASemanticModelBridge modelBridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        modelBridge.setElement(element);
        graphNode.setSemanticModel((SemanticModelBridge)modelBridge);
        org.eclipse.epf.uma.Point point = UmaFactory.eINSTANCE.createPoint();
        point.setX(new Double(-1.0));
        point.setY(new Double(-1.0));
        graphNode.setPosition(point);
        Dimension dim = UmaFactory.eINSTANCE.createDimension();
        dim.setWidth(new Double(-1.0));
        dim.setHeight(new Double(-1.0));
        graphNode.setSize(dim);
        Property property = UmaFactory.eINSTANCE.createProperty();
        property.setKey("wpCompositeType");
        property.setValue(new Integer(this.getType()).toString());
        ArrayList<Property> list = new ArrayList<Property>();
        list.add(property);
        graphNode.set(12, list);
        return graphNode;
    }

    public Node findNode(ActivityDetailDiagram diagram, Object object) {
        for (Node element : diagram.getNodes()) {
            if (object != element.getObject() || !(element instanceof WorkProductComposite) || ((WorkProductComposite)element).getType() != this.type) continue;
            return element;
        }
        return null;
    }

    protected Object getMethodElementAdapter() {
        if (this.methodElementAdapter == null) {
            this.methodElementAdapter = new TaskDescriptorAdapter();
        }
        return this.methodElementAdapter;
    }

    private AdapterFactory getAdapterFactory() {
        ComposedAdapterFactory adapterFactory = null;
        IFilter filter = this.getFilter();
        if (filter == null) {
            adapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        } else if (filter instanceof IAdapterFactoryFilter) {
            adapterFactory = (ConfigurableComposedAdapterFactory)((IAdapterFactoryFilter)filter).getWPBSAdapterFactory();
        }
        return adapterFactory;
    }

    protected TaskNode getTaskNode() {
        return this.taskNode;
    }

    protected void setTaskNode(TaskNode taskNode) {
        this.taskNode = taskNode;
    }

    private class TaskDescriptorAdapter
    extends NodeImpl.TransactionalNodeLink {
        private TaskDescriptorAdapter() {
        }

        protected void handleNotification(Notification msg) {
            Diagram diagram;
            this.doHandleNotification(msg);
            if (WorkProductCompositeImpl.this.getNodes().isEmpty() && (diagram = WorkProductCompositeImpl.this.getDiagram()) != null) {
                diagram.getNodes().remove((Object)WorkProductCompositeImpl.this);
                diagram.setObject(diagram.getObject());
            }
        }

        private void doHandleNotification(Notification msg) {
            switch (msg.getFeatureID(TaskDescriptor.class)) {
                case 42: {
                    switch (msg.getEventType()) {
                        case 3: {
                            Object obj = msg.getNewValue();
                            if (obj != null && WorkProductCompositeImpl.this.type == 2) {
                                WorkProductCompositeImpl.this.addNode(obj);
                            }
                            return;
                        }
                        case 4: {
                            Object obj = msg.getOldValue();
                            if (obj != null && WorkProductCompositeImpl.this.type == 2) {
                                WorkProductCompositeImpl.this.removeNode(obj);
                            }
                            return;
                        }
                    }
                    break;
                }
                case 40: {
                    switch (msg.getEventType()) {
                        case 3: {
                            Object obj = msg.getNewValue();
                            if (obj != null && WorkProductCompositeImpl.this.type == 1) {
                                WorkProductCompositeImpl.this.addNode(obj);
                            }
                            return;
                        }
                        case 4: {
                            Object obj = msg.getOldValue();
                            if (obj != null && WorkProductCompositeImpl.this.type == 1) {
                                WorkProductCompositeImpl.this.removeNode(obj);
                            }
                            return;
                        }
                    }
                }
            }
        }
    }
}

