/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.DiagramResources;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.RoleTaskComposite;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.WorkProductComposite;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.diagram.model.util.INodeChangeListener;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.process.WorkProductDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.DiagramElement;
import org.eclipse.epf.uma.Dimension;
import org.eclipse.epf.uma.GraphConnector;
import org.eclipse.epf.uma.GraphEdge;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Property;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.SimpleSemanticModelElement;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.util.UmaUtil;

public class GraphicalDataHelper {
    public static final int ACTIVITY_DIAGRAM = 0;
    public static final int WORK_PRODUCT_DEPENDENCY_DIAGRAM = 1;
    public static final int ACTIVITY_DETAIL_DIAGRAM = 2;
    static final int[] DIAGRAM_TYPES;
    static final String[] DIAGRAM_TYPE_TEXTS;
    public static final String PROP_TYPE = "type";
    public static final String PROP_WORK_PRODUCT_COMPOSITE_TYPE = "wpCompositeType";
    public static final String PROP_AUTO_LAYOUT = "autolayout";
    public static final String PROP_INDEX = "index";
    public static final String PROP_AUTO_LAYOUT_VALUE_TRUE = "true";
    public static final String PROP_AUTO_LAYOUT_VALUE_FALSE = "false";
    public static final String GRAPH_NODE_SYNCH_BAR = "synchnonization bar";
    public static final String GRAPH_NODE_START = "start node";
    public static final String GRAPH_NODE_END = "end node";
    public static final String GRAPH_NODE_DECISION = "decision node";
    public static final String GRAPH_NODE_FREE_TEXT = "free text";
    public static final String DIAGRAM_WORKFLOW = "Workflow";
    public static final String DIAGRAM_WORK_PRODUCT_DEPENDENCY = "Work Product Dependency";
    public static final String DIAGRAM_ACTIVITY_DETAIL = "Activity Detail";
    public static final String ADD_DIAGRAM_TASKS_PER_ROW = "ACTIVITY_DETAIL_DIAGRAM_TASKS_PER_ROW";

    static {
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 1;
        DIAGRAM_TYPES = nArray;
        DIAGRAM_TYPE_TEXTS = new String[]{DiagramResources.type_activity, DiagramResources.type_WPD, DiagramResources.type_activityDetail};
    }

    public static Point toPoint(org.eclipse.epf.uma.Point p) {
        return new Point(p.getX().doubleValue(), p.getY().doubleValue());
    }

    public static org.eclipse.epf.uma.Point newModelPoint(int x, int y) {
        org.eclipse.epf.uma.Point p = UmaFactory.eINSTANCE.createPoint();
        p.setX(new Double(x));
        p.setY(new Double(y));
        return p;
    }

    public static Property findProperty(GraphNode node, String propKey) {
        int i = node.getProperty().size() - 1;
        while (i > -1) {
            Property prop = (Property)node.getProperty().get(i);
            if (propKey.equals(prop.getKey())) {
                return prop;
            }
            --i;
        }
        return null;
    }

    public static Dimension newModelDimension(int width, int height) {
        Dimension size = UmaFactory.eINSTANCE.createDimension();
        size.setWidth(new Double(width));
        size.setHeight(new Double(height));
        return size;
    }

    public static void fillConnections(Node node, GraphNode graphNode) {
        boolean old = node.eDeliver();
        try {
            node.eSetDeliver(false);
            Diagram diagram = (Diagram)node.eContainer();
            for (GraphConnector conn : graphNode.getAnchorage()) {
                for (GraphEdge edge : conn.getGraphEdge()) {
                    if (edge.getAnchor().size() <= 1) continue;
                    Link link = null;
                    if (edge.eContainer() != graphNode) continue;
                    GraphConnector targetConnector = (GraphConnector)edge.getAnchor().get(1);
                    GraphNode targetGraphNode = (GraphNode)targetConnector.eContainer();
                    if (graphNode.eContainer() != targetGraphNode.eContainer()) continue;
                    GraphNode linkedObject = targetGraphNode;
                    if (targetGraphNode.getSemanticModel() instanceof UMASemanticModelBridge) {
                        linkedObject = ((UMASemanticModelBridge)targetGraphNode.getSemanticModel()).getElement();
                    }
                    if (linkedObject != null) {
                        Node targetNode = GraphicalDataHelper.findNode(diagram, (Object)linkedObject);
                        link = ModelFactory.eINSTANCE.createLink();
                        link.setSource(node);
                        link.setTarget(targetNode);
                        link.setObject(edge);
                        continue;
                    }
                    if (!LibraryEditPlugin.getDefault().isDebugging()) continue;
                    System.out.println("Linked object is null: for: " + node.getGraphNode() + ": for graphConnector: " + targetConnector);
                }
            }
        }
        finally {
            node.eSetDeliver(old);
        }
    }

    public static Node findNode(Diagram diagram, GraphNode gNode, Class adapterType) {
        SemanticModelBridge bridge = gNode.getSemanticModel();
        if (bridge instanceof UMASemanticModelBridge) {
            INodeChangeListener listener = (INodeChangeListener)UmaUtil.getAdapter((EObject)((UMASemanticModelBridge)bridge).getElement(), (Class)adapterType);
            return listener.getNode();
        }
        for (Node element : diagram.getNodes()) {
            if (gNode != element.getObject()) continue;
            return element;
        }
        return null;
    }

    public static Node findNode(NodeContainer container, Object object) {
        for (Node element : container.getNodes()) {
            if (object != element.getObject() && object != element.getLinkedElement()) continue;
            return element;
        }
        return null;
    }

    public static Node findNode(NodeContainer container, Object object, boolean checkBase) {
        for (Node node : container.getNodes()) {
            if (object == node.getObject()) {
                return node;
            }
            if (!checkBase || !(node.getObject() instanceof VariabilityElement)) continue;
            VariabilityElement ve = ((VariabilityElement)node.getObject()).getVariabilityBasedOnElement();
            while (ve != null) {
                if (ve == object) {
                    return node;
                }
                ve = ve.getVariabilityBasedOnElement();
            }
        }
        return null;
    }

    public static Node findNode(ActivityDetailDiagram diagram, Object object) {
        Node node = null;
        for (Node element : diagram.getNodes()) {
            if ((element instanceof RoleTaskComposite || element instanceof WorkProductComposite) && (node = GraphicalDataHelper.findNode((NodeContainer)element, object)) != null) {
                return node;
            }
            if (object != element.getObject()) continue;
            return element;
        }
        return null;
    }

    public static Node findNode(ActivityDetailDiagram diagram, Object object, Class type) {
        Node node = null;
        for (Node element : diagram.getNodes()) {
            if ((element instanceof RoleTaskComposite || element instanceof WorkProductComposite) && (node = GraphicalDataHelper.findNode((NodeContainer)element, object)) != null) {
                return node;
            }
            if (object != element.getObject() || !type.isInstance(element)) continue;
            return element;
        }
        return null;
    }

    public static Link findLink(Node source, Object targetLinkedElement) {
        for (Link link : source.getOutgoingConnections()) {
            Node target = link.getTarget();
            if (target == null || target.getLinkedElement() != targetLinkedElement) continue;
            return link;
        }
        return null;
    }

    private static String getTypeString(int type) {
        switch (type) {
            case 2: {
                return GRAPH_NODE_DECISION;
            }
            case 4: {
                return GRAPH_NODE_END;
            }
            case 3: {
                return GRAPH_NODE_START;
            }
            case 1: {
                return GRAPH_NODE_SYNCH_BAR;
            }
            case 6: {
                return GRAPH_NODE_FREE_TEXT;
            }
        }
        return null;
    }

    public static GraphNode newTypedGraphNode(int type) {
        GraphNode graphNode = UmaFactory.eINSTANCE.createGraphNode();
        SimpleSemanticModelElement bridge = UmaFactory.eINSTANCE.createSimpleSemanticModelElement();
        bridge.setTypeInfo(GraphicalDataHelper.getTypeString(type));
        graphNode.setSemanticModel((SemanticModelBridge)bridge);
        org.eclipse.epf.uma.Point point = UmaFactory.eINSTANCE.createPoint();
        point.setX(new Double(-1.0));
        point.setY(new Double(-1.0));
        graphNode.setPosition(point);
        Dimension dim = UmaFactory.eINSTANCE.createDimension();
        dim.setWidth(new Double(-1.0));
        dim.setHeight(new Double(-1.0));
        graphNode.setSize(dim);
        if (type == 6) {
            graphNode.setName(DiagramResources.addFreeTxt);
        }
        if (type == 6) {
            Property property = UmaFactory.eINSTANCE.createProperty();
            property.setKey(GRAPH_NODE_FREE_TEXT);
            property.setValue(DiagramResources.addFreeTxt);
            ArrayList<Property> list = new ArrayList<Property>();
            list.add(property);
            graphNode.set(12, list);
        }
        return graphNode;
    }

    public static void removeGraphicalData(Link link) {
        GraphEdge edge = (GraphEdge)link.getObject();
        if (edge != null) {
            GraphicalDataManager.getInstance().removeGraphEdge(edge);
        }
    }

    public static void addGraphicalData(Link link) {
        GraphEdge edge = (GraphEdge)link.getObject();
        if (edge == null) {
            edge = GraphicalDataManager.getInstance().addGraphConnectorPair(link.getSource().getGraphNode(), link.getTarget().getGraphNode());
            link.setObject(edge);
            link.setSourceEndPoint(link.getSourceEndPoint());
            link.setTargetEndPoint(link.getTargetEndPoint());
        } else {
            GraphNode srcNode = link.getSource().getGraphNode();
            GraphNode targetNode = link.getTarget().getGraphNode();
            Object srcConnector = edge.getAnchor().get(0);
            srcNode.getAnchorage().add((GraphConnector)srcConnector);
            srcNode.getContained().add(edge);
            Object targetConnector = edge.getAnchor().get(1);
            targetNode.getAnchorage().add((GraphConnector)targetConnector);
        }
    }

    public static void setSemanticModel(Link link, WorkOrder workOrder) {
        GraphEdge edge = (GraphEdge)link.getObject();
        UMASemanticModelBridge bridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        bridge.setElement((MethodElement)workOrder);
        edge.setSemanticModel((SemanticModelBridge)bridge);
    }

    public static Collection getSourceNodes(TypedNode typedNode, Class type) {
        ArrayList actNodes = new ArrayList();
        GraphicalDataHelper.getSourceNodes(actNodes, typedNode, type);
        return actNodes;
    }

    public static Collection getTargetNodes(TypedNode typedNode, Class type) {
        ArrayList actNodes = new ArrayList();
        GraphicalDataHelper.getTargetNodes(actNodes, typedNode, type);
        return actNodes;
    }

    public static void getTargetNodes(Collection actNodes, TypedNode typedNode, Class type) {
        for (Link link : typedNode.getOutgoingConnections()) {
            Node target = link.getTarget();
            if (type.isInstance(target)) {
                actNodes.add(target);
                continue;
            }
            if (!(target instanceof TypedNode)) continue;
            GraphicalDataHelper.getTargetNodes(actNodes, (TypedNode)target, type);
        }
    }

    public static void getSourceNodes(Collection actNodes, TypedNode typedNode, Class type) {
        for (Link link : typedNode.getIncomingConnections()) {
            Node source = link.getSource();
            if (type.isInstance(source)) {
                actNodes.add(source);
                continue;
            }
            if (!(source instanceof TypedNode)) continue;
            GraphicalDataHelper.getSourceNodes(actNodes, (TypedNode)source, type);
        }
    }

    public static Node getFirstSourceNode(TypedNode typedNode, Class type) {
        for (Link link : typedNode.getIncomingConnections()) {
            Node source = link.getSource();
            if (type.isInstance(source)) {
                return source;
            }
            if (!(source instanceof TypedNode) || (source = GraphicalDataHelper.getFirstSourceNode((TypedNode)source, type)) == null) continue;
            return source;
        }
        return null;
    }

    public static WorkOrder removeWorkOrder(NamedNodeImpl node, Object predBreakdownElement) {
        boolean notify = node.isNotificationEnabled();
        try {
            node.setNotificationEnabled(false);
            WorkOrder workOrder = UmaUtil.removeWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)node.getObject()), (Object)predBreakdownElement);
            return workOrder;
        }
        finally {
            node.setNotificationEnabled(notify);
        }
    }

    public static WorkOrder addDefaultWorkOrder(NamedNodeImpl node, WorkBreakdownElement predBreakdownElement) {
        boolean notify = node.isNotificationEnabled();
        try {
            node.setNotificationEnabled(false);
            WorkOrder workOrder = UmaUtil.createDefaultWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)node.getObject()), (WorkBreakdownElement)predBreakdownElement);
            return workOrder;
        }
        finally {
            node.setNotificationEnabled(notify);
        }
    }

    public static boolean hasNoRoleDescriptorAssociated(TaskDescriptor taskDescriptor) {
        return taskDescriptor.getPerformedPrimarilyBy().isEmpty();
    }

    public static boolean contains(NodeContainer container, Node node) {
        for (Object child : container.getNodes()) {
            if (child == node) {
                return true;
            }
            if (!(child instanceof NodeContainer) || !GraphicalDataHelper.contains((NodeContainer)child, node)) continue;
            return true;
        }
        return false;
    }

    public static boolean refreshFromBase(org.eclipse.epf.uma.Diagram diagram) {
        SemanticModelBridge modelBridge = diagram.getSemanticModel();
        if (modelBridge instanceof UMASemanticModelBridge) {
            UMASemanticModelBridge umaModelBridge = (UMASemanticModelBridge)modelBridge;
            Activity act = (Activity)umaModelBridge.getElement();
            Activity base = (Activity)act.getVariabilityBasedOnElement();
            if (base == null || act.getVariabilityType() == VariabilityType.LOCAL_REPLACEMENT) {
                return false;
            }
            int diagramType = GraphicalDataManager.getInstance().getDiagramType(diagram);
            switch (diagramType) {
                case 0: {
                    GraphNode node;
                    org.eclipse.epf.uma.Diagram baseDiagram = GraphicalDataManager.getInstance().getUMADiagram(base, diagramType, false);
                    if (baseDiagram == null) {
                        return false;
                    }
                    ArrayList<GraphNode> oldNodes = new ArrayList<GraphNode>();
                    org.eclipse.epf.uma.Diagram copy = GraphicalDataHelper.copyDiagram(baseDiagram);
                    for (GraphNode baseNode : baseDiagram.getContained()) {
                        GraphNode node2;
                        modelBridge = baseNode.getSemanticModel();
                        if (modelBridge instanceof UMASemanticModelBridge) {
                            MethodElement e = ((UMASemanticModelBridge)modelBridge).getElement();
                            node = GraphicalDataManager.findGraphNode(diagram, e);
                            if (node == null) continue;
                            oldNodes.add(node);
                            continue;
                        }
                        if (!GraphicalDataHelper.isUIGraphNode(baseNode) || (node2 = GraphicalDataHelper.findUIGraphNode(diagram, baseNode.getGuid())) == null) continue;
                        oldNodes.add(node2);
                    }
                    diagram.getContained().removeAll(oldNodes);
                    Iterator iter = diagram.getContained().iterator();
                    while (iter.hasNext()) {
                        MethodElement e;
                        GraphNode node3 = (GraphNode)iter.next();
                        if (GraphicalDataHelper.isUIGraphNode(node3) && node3.getBriefDescription() != null && node3.getBriefDescription().length() > 0) {
                            iter.remove();
                            continue;
                        }
                        SemanticModelBridge bridge = node3.getSemanticModel();
                        if (!(bridge instanceof UMASemanticModelBridge) || !((e = ((UMASemanticModelBridge)bridge).getElement()) instanceof Activity) || ((Activity)e).getVariabilityBasedOnElement() == null) continue;
                        iter.remove();
                    }
                    for (Object element : act.getBreakdownElements()) {
                        VariabilityElement baseElement;
                        if (!(element instanceof Activity) || (node = GraphicalDataManager.findGraphNode(copy, baseElement = ((Activity)element).getVariabilityBasedOnElement())) == null) continue;
                        UMASemanticModelBridge bridge = (UMASemanticModelBridge)node.getSemanticModel();
                        bridge.setElement((MethodElement)element);
                    }
                    diagram.getContained().addAll(copy.getContained());
                    break;
                }
                default: {
                    org.eclipse.epf.uma.Diagram baseDiagram = GraphicalDataManager.getInstance().getUMADiagram(base, diagramType, false);
                    if (baseDiagram == null) {
                        return false;
                    }
                    ArrayList<GraphNode> oldNodes = new ArrayList<GraphNode>();
                    org.eclipse.epf.uma.Diagram copy = GraphicalDataHelper.copyDiagram(baseDiagram);
                    for (GraphNode baseNode : baseDiagram.getContained()) {
                        MethodElement e;
                        GraphNode node;
                        modelBridge = baseNode.getSemanticModel();
                        if (!(modelBridge instanceof UMASemanticModelBridge) || (node = GraphicalDataManager.findGraphNode(diagram, e = ((UMASemanticModelBridge)modelBridge).getElement())) == null) continue;
                        oldNodes.add(node);
                    }
                    diagram.getContained().removeAll(oldNodes);
                    diagram.getContained().addAll(copy.getContained());
                }
            }
        }
        return false;
    }

    private static GraphNode findUIGraphNode(org.eclipse.epf.uma.Diagram diagram, String baseGuid) {
        for (GraphNode node : diagram.getContained()) {
            if (!GraphicalDataHelper.isUIGraphNode(node) || !baseGuid.equals(node.getBriefDescription())) continue;
            return node;
        }
        return null;
    }

    public static boolean isUIGraphNode(GraphNode gNode) {
        String typeInfo;
        SemanticModelBridge modelBridge = gNode.getSemanticModel();
        return modelBridge instanceof SimpleSemanticModelElement && ((typeInfo = ((SimpleSemanticModelElement)modelBridge).getTypeInfo()).equals(GRAPH_NODE_DECISION) || typeInfo.equals(GRAPH_NODE_END) || typeInfo.equals(GRAPH_NODE_START) || typeInfo.equals(GRAPH_NODE_SYNCH_BAR) || typeInfo.equals(GRAPH_NODE_FREE_TEXT));
    }

    public static org.eclipse.epf.uma.Diagram copyDiagram(org.eclipse.epf.uma.Diagram baseDiagram) {
        org.eclipse.epf.uma.Diagram copy = (org.eclipse.epf.uma.Diagram)TngUtil.copy((MethodElement)baseDiagram);
        int size = copy.getContained().size();
        int i = 0;
        while (i < size) {
            GraphNode gNode = (GraphNode)copy.getContained().get(i);
            if (GraphicalDataHelper.isUIGraphNode(gNode)) {
                gNode.setBriefDescription(((DiagramElement)baseDiagram.getContained().get(i)).getGuid());
            }
            ++i;
        }
        return copy;
    }

    public static Collection getDiagrams(Activity act) {
        return GraphicalDataHelper.getDiagrams(act, false);
    }

    public static Collection getDiagrams(Activity act, boolean create) {
        ArrayList<org.eclipse.epf.uma.Diagram> diagrams = new ArrayList<org.eclipse.epf.uma.Diagram>();
        int i = 0;
        while (i < DIAGRAM_TYPES.length) {
            org.eclipse.epf.uma.Diagram diagram = GraphicalDataManager.getInstance().getUMADiagram(act, DIAGRAM_TYPES[i], create);
            if (diagram != null) {
                diagrams.add(diagram);
            }
            ++i;
        }
        return diagrams;
    }

    public static String getDiagramTypeText(org.eclipse.epf.uma.Diagram diagram) {
        int type = GraphicalDataManager.getInstance().getDiagramType(diagram);
        if (type != -1) {
            return DIAGRAM_TYPE_TEXTS[type];
        }
        return DiagramResources.type_unknown;
    }

    public static void setAllDiagramSuppressed(Process proc, boolean suppressed) {
        AbstractTreeIterator iter = new AbstractTreeIterator(proc){
            private static final long serialVersionUID = -618949014476371114L;

            protected Iterator getChildren(Object object) {
                Activity act = (Activity)object;
                ArrayList children = new ArrayList();
                for (Object element : act.getBreakdownElements()) {
                    if (!(element instanceof Activity)) continue;
                    children.add(element);
                }
                return children.iterator();
            }
        };
        while (iter.hasNext()) {
            Collection diagrams = GraphicalDataHelper.getDiagrams((Activity)iter.next(), suppressed);
            for (org.eclipse.epf.uma.Diagram diagram : diagrams) {
                diagram.setSuppressed(Boolean.valueOf(suppressed));
            }
        }
    }

    public static void removeLink(Link link) {
        Node sourceNode = link.getSource();
        Node targetNode = link.getTarget();
        boolean srcNotify = sourceNode != null ? sourceNode.eDeliver() : false;
        boolean targetNotify = targetNode != null ? targetNode.eDeliver() : false;
        try {
            if (sourceNode != null) {
                sourceNode.eSetDeliver(false);
            }
            if (targetNode != null) {
                targetNode.eSetDeliver(false);
            }
            link.setSource(null);
            link.setTarget(null);
        }
        finally {
            if (sourceNode != null) {
                sourceNode.eSetDeliver(srcNotify);
            }
            if (targetNode != null) {
                targetNode.eSetDeliver(targetNotify);
            }
        }
    }

    public static Object findElement(Collection allElements, Object e) {
        for (Object element : allElements) {
            Object childElement;
            if (e == TngUtil.unwrap(element)) {
                return element;
            }
            if (!(element instanceof WorkProductDescriptorWrapperItemProvider) || (childElement = GraphicalDataHelper.findElement(((WorkProductDescriptorWrapperItemProvider)element).getChildren(element), e)) == null) continue;
            return childElement;
        }
        return null;
    }

    public static boolean anyDuplicatePredecessors(WorkBreakdownElement e) {
        ArrayList list = new ArrayList();
        ArrayList predlist = new ArrayList();
        GraphicalDataHelper.getPreds(e, predlist);
        for (Object obj : predlist) {
            if (!list.contains(obj)) {
                list.add(obj);
                continue;
            }
            return true;
        }
        return false;
    }

    public static void getPreds(WorkBreakdownElement e, List list) {
        List predlist = e.getLinkToPredecessor();
        for (WorkOrder workorder : predlist) {
            list.add(workorder.getPred());
        }
    }

    public static boolean canRemoveAllPreds(Link link, Node oldSource, Node oldTarget) {
        if (oldTarget instanceof WorkBreakdownElementNode) {
            EList<Link> inlist = oldTarget.getIncomingConnections();
            for (Link incominglink : inlist) {
                Collection col;
                if (!(incominglink.getSource() instanceof TypedNode && ((TypedNode)incominglink.getSource()).getType() == 1 ? (col = GraphicalDataHelper.getSourceNodes((TypedNode)incominglink.getSource(), WorkBreakdownElementNode.class)).contains(oldSource) : incominglink.getSource() instanceof WorkBreakdownElementNode && incominglink.getSource().equals(oldSource))) continue;
                return false;
            }
        }
        return true;
    }

    public static void getSyncBarSourceNodes(TypedNode typedNode, Collection actNodes) {
        for (Link link : typedNode.getIncomingConnections()) {
            Node source = link.getSource();
            if (source instanceof WorkBreakdownElementNode) {
                actNodes.add(source);
                continue;
            }
            if (!(source instanceof TypedNode) || ((TypedNode)source).getType() != 1) continue;
            GraphicalDataHelper.getSyncBarSourceNodes((TypedNode)source, actNodes);
        }
    }

    public static void getSyncBarTargetNodes(TypedNode typedNode, Collection actNodes) {
        for (Link link : typedNode.getOutgoingConnections()) {
            Node target = link.getTarget();
            if (target instanceof WorkBreakdownElementNode) {
                actNodes.add(target);
                continue;
            }
            if (!(target instanceof TypedNode) || ((TypedNode)target).getType() != 1) continue;
            GraphicalDataHelper.getSyncBarTargetNodes((TypedNode)target, actNodes);
        }
    }

    public static Node findNode(NodeContainer container, Object object, Class nodeType) {
        for (Node element : container.getNodes()) {
            if (object != element.getObject() || !nodeType.isInstance(element)) continue;
            return element;
        }
        return null;
    }

    public static Property createProperty(GraphNode graphNode, String key, String value) {
        Property property = null;
        if (graphNode != null) {
            property = GraphicalDataHelper.findProperty(graphNode, key);
        }
        if (property == null) {
            property = UmaFactory.eINSTANCE.createProperty();
            property.setKey(key);
            property.setValue(value);
            ArrayList<Property> list = graphNode.getList(12);
            if (list == null) {
                list = new ArrayList<Property>();
                graphNode.set(12, list);
            }
            list.add(property);
        } else {
            property.setValue(value);
        }
        return property;
    }

    public static String getAutoLayoutFlag(ActivityDetailDiagram diagram) {
        Property property;
        List propList;
        String flag = null;
        GraphNode graphNode = diagram.getGraphNode();
        if (graphNode != null && (propList = graphNode.getList(12)) != null && propList.size() > 0 && (property = GraphicalDataHelper.findProperty(graphNode, PROP_AUTO_LAYOUT)) != null) {
            flag = property.getValue();
        }
        return flag;
    }

    public static boolean isAutoLayout(ActivityDetailDiagram diagram) {
        String temp;
        Property property;
        List propList;
        GraphNode graphNode = diagram.getGraphNode();
        if (graphNode != null && (propList = graphNode.getList(12)) != null && propList.size() > 0 && (property = GraphicalDataHelper.findProperty(graphNode, PROP_AUTO_LAYOUT)) != null && (temp = property.getValue()) != null && temp != "" && (PROP_AUTO_LAYOUT_VALUE_TRUE.equals(temp) || PROP_AUTO_LAYOUT_VALUE_FALSE.equals(temp))) {
            return new Boolean(temp);
        }
        return false;
    }

    public static int getTasksPerRow() {
        int count = Providers.getAuthoringPluginPreferenceStore().getInt(ADD_DIAGRAM_TASKS_PER_ROW);
        if (count <= 0) {
            return 10;
        }
        return count;
    }

    public static Property getPropertyByKey(List list, String key) {
        if (!list.isEmpty()) {
            for (Property property : list) {
                if (property == null || !property.getKey().equals(key)) continue;
                return property;
            }
        }
        return null;
    }

    public static Property getProperty(Node node, String key) {
        List list;
        GraphNode graphNode = node.getGraphNode();
        if (graphNode != null && (list = graphNode.getProperty()) != null && !list.isEmpty()) {
            int i = list.size() - 1;
            while (i > -1) {
                Property prop = (Property)list.get(i);
                if (key.equals(prop.getKey())) {
                    return prop;
                }
                --i;
            }
        }
        return null;
    }
}

