/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.commands;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateConnectionViewRequest;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.util.Assert;

public class DeferredCreateConnectionViewCommand
extends AbstractTransactionalCommand {
    protected EObject element = null;
    protected String semanticHint = null;
    protected IAdaptable sourceViewAdapter;
    protected IAdaptable targetViewAdapter;
    protected EditPartViewer viewer;
    private Command createConnectionCmd;
    protected PreferencesHint preferencesHint;

    public DeferredCreateConnectionViewCommand(TransactionalEditingDomain editingDomain, EObject element, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer viewer, PreferencesHint preferencesHint) {
        super(editingDomain, "Deferred Create Connection View Command", null);
        this.element = element;
        this.sourceViewAdapter = sourceViewAdapter;
        this.targetViewAdapter = targetViewAdapter;
        this.viewer = viewer;
        this.preferencesHint = preferencesHint;
    }

    public DeferredCreateConnectionViewCommand(TransactionalEditingDomain editingDomain, String semanticHint, IAdaptable sourceViewAdapter, IAdaptable targetViewAdapter, EditPartViewer viewer, PreferencesHint preferencesHint) {
        super(editingDomain, "Deferred Create Connection View Command", null);
        this.semanticHint = semanticHint;
        this.sourceViewAdapter = sourceViewAdapter;
        this.targetViewAdapter = targetViewAdapter;
        this.viewer = viewer;
        this.preferencesHint = preferencesHint;
    }

    public List getAffectedFiles() {
        View view;
        EditPart editpart;
        if (this.viewer != null && (editpart = this.viewer.getRootEditPart().getContents()) instanceof IGraphicalEditPart && (view = (View)((IGraphicalEditPart)editpart).getModel()) != null) {
            IFile f = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            return f != null ? Collections.singletonList(f) : Collections.EMPTY_LIST;
        }
        return super.getAffectedFiles();
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
        Map epRegistry = this.viewer.getEditPartRegistry();
        IGraphicalEditPart sourceEP = (IGraphicalEditPart)epRegistry.get(this.sourceViewAdapter.getAdapter(View.class));
        IGraphicalEditPart targetEP = (IGraphicalEditPart)epRegistry.get(this.targetViewAdapter.getAdapter(View.class));
        Assert.isNotNull((Object)sourceEP);
        Assert.isNotNull((Object)targetEP);
        if (this.element != null) {
            this.createConnectionCmd = CreateConnectionViewRequest.getCreateCommand(this.element, (EditPart)sourceEP, (EditPart)targetEP, this.preferencesHint);
        } else {
            CreateConnectionViewRequest.ConnectionViewDescriptor viewDescriptor = new CreateConnectionViewRequest.ConnectionViewDescriptor(null, this.semanticHint, this.preferencesHint);
            CreateConnectionViewRequest createRequest = new CreateConnectionViewRequest(viewDescriptor);
            this.createConnectionCmd = CreateConnectionViewRequest.getCreateCommand(createRequest, (EditPart)sourceEP, (EditPart)targetEP);
        }
        if (this.createConnectionCmd.canExecute()) {
            this.createConnectionCmd.execute();
        }
        this.viewer = null;
        return CommandResult.newOKCommandResult();
    }
}

