/*
 * Decompiled with CFR 0.152.
 */
package org.apache.naming.factory;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import org.apache.naming.ResourceRef;
import org.apache.naming.factory.TyrexFactory;
import tyrex.resource.Resources;

public class TyrexResourceFactory
extends TyrexFactory {
    public static final String RESOURCE_NAME = "name";
    public static final String DEFAULT_RESOURCE_NAME = "tomcat";

    public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment) throws NamingException {
        Reference ref;
        if (obj instanceof ResourceRef && (ref = (Reference)obj).getClassName().equals("tyrex.resource.Resource")) {
            try {
                Resources resources = this.getTransactionDomain().getResources();
                RefAddr nameAddr = ref.get(RESOURCE_NAME);
                if (nameAddr != null) {
                    return resources.getResource(nameAddr.getContent().toString()).getClientFactory();
                }
                return resources.getResource(DEFAULT_RESOURCE_NAME).getClientFactory();
            }
            catch (Throwable t) {
                this.log("Cannot create Tyrex Resource, Exception", t);
                throw new NamingException("Exception creating Tyrex Resource: " + t.getMessage());
            }
        }
        return null;
    }

    private void log(String message) {
        System.out.print("TyrexResourceFactory:  ");
        System.out.println(message);
    }

    private void log(String message, Throwable exception) {
        this.log(message);
        exception.printStackTrace(System.out);
    }
}

