/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.ui.wizards;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.publishing.ui.PublishingUIPlugin;
import org.eclipse.epf.publishing.ui.PublishingUIResources;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectConfigPage
extends BaseWizardPage {
    public static final String PAGE_NAME = SelectConfigPage.class.getName();
    protected Table table;
    protected TableViewer configViewer;
    protected Text briefDescText;
    protected List processViews;
    protected String selectedConfigName;
    private MethodConfiguration selectedConfig;
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getColumnText(Object object, int columnIndex) {
            return super.getColumnText(object, columnIndex);
        }

        public Image getColumnImage(Object object, int columnIndex) {
            return super.getColumnImage(object, columnIndex);
        }
    };

    public SelectConfigPage() {
        super(PAGE_NAME);
        this.setTitle(PublishingUIResources.selectConfigWizardPage_title);
        this.setDescription(PublishingUIResources.selectConfigWizardPage_text);
        this.setImageDescriptor(PublishingUIPlugin.getDefault().getImageDescriptor("full/wizban/PublishConfiguration.gif"));
    }

    public void createControl(Composite parent) {
        Composite composite = SelectConfigPage.createGridLayoutComposite((Composite)parent, (int)1);
        SelectConfigPage.createLabel((Composite)composite, (String)PublishingUIResources.configLabel_text);
        this.table = new Table(composite, 2560);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 120;
        gridData.widthHint = 280;
        this.table.setLayoutData((Object)gridData);
        this.configViewer = new TableViewer(this.table);
        SelectConfigPage.createLabel((Composite)composite, (String)AuthoringUIText.DESCRIPTION_TEXT);
        this.briefDescText = SelectConfigPage.createMultiLineText((Composite)composite, (String)"", (int)360, (int)80, (int)1);
        this.initControls();
        this.addListeners();
        this.setControl((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, AuthoringUIHelpContexts.CONFIGURATION_PUBLISH_WIZARD_ALL_PAGES_CONTEXT);
    }

    protected void initControls() {
        this.configViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.configViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        MethodConfiguration[] configs = LibraryServiceUtil.getMethodConfigurations((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary());
        ArrayList configsList = new ArrayList();
        configsList.addAll(Arrays.asList(configs));
        Collections.sort(configsList, Comparators.DEFAULT_COMPARATOR);
        this.configViewer.setInput((Object)configsList.toArray());
        if (configsList.size() > 0) {
            this.table.select(0);
            this.setBriefDescription((MethodConfiguration)configsList.get(0));
        }
    }

    protected void addListeners() {
        this.configViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    Object[] configs = selection.toArray();
                    SelectConfigPage.this.setBriefDescription((MethodConfiguration)configs[0]);
                }
                SelectConfigPage.this.setPageComplete(SelectConfigPage.this.isPageComplete());
                SelectConfigPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        this.setErrorMessage(null);
        if (this.table.getSelectionCount() > 0) {
            TableItem[] items = this.table.getSelection();
            this.selectedConfigName = items[0].getText();
            MethodConfiguration config = items[0].getData() instanceof MethodConfiguration ? (MethodConfiguration)items[0].getData() : null;
            this.setSelectedConfig(config);
            this.processViews = null;
            if (config != null) {
                this.processViews = this.getValidConfigViews(config);
            }
            if (this.processViews != null && this.processViews.size() > 0) {
                return true;
            }
            this.setErrorMessage(PublishingUIResources.missingViewError_msg);
        }
        return false;
    }

    public Object getNextPageData() {
        return this.getConfigName();
    }

    protected List<ContentCategory> getValidConfigViews(MethodConfiguration config) {
        String msg;
        StringBuffer message = new StringBuffer();
        ArrayList<ContentCategory> views = new ArrayList<ContentCategory>();
        for (ContentCategory view : config.getProcessViews()) {
            if (ConfigurationHelper.isContributor((VariabilityElement)view)) {
                msg = PublishingUIResources.bind((String)PublishingUIResources.invalidViewContributorInfo_msg, (Object)view.getPresentationName());
                message.append("\t").append(msg).append(StrUtil.LINE_FEED);
                continue;
            }
            if ((view = (ContentCategory)ConfigurationHelper.getCalculatedElement((MethodElement)view, (MethodConfiguration)config)) == null) continue;
            if (views.contains(view)) {
                msg = PublishingUIResources.bind((String)PublishingUIResources.invalidViewSameViewInfo_msg, (Object)view.getPresentationName());
                message.append("\t").append(msg).append(StrUtil.LINE_FEED);
                continue;
            }
            views.add(view);
        }
        if (message.length() > 0) {
            msg = PublishingUIResources.bind((String)PublishingUIResources.invalidViewsInfo_msg, (Object)config.getName());
            message.insert(0, String.valueOf(msg) + StrUtil.LINE_FEED + StrUtil.LINE_FEED);
            this.briefDescText.setText(message.toString());
        }
        return views;
    }

    public String getConfigName() {
        return this.selectedConfig.getName();
    }

    private void setBriefDescription(MethodConfiguration config) {
        this.briefDescText.setText(config.getBriefDescription());
    }

    public MethodConfiguration getSelectedConfig() {
        return this.selectedConfig;
    }

    private void setSelectedConfig(MethodConfiguration selectedConfig) {
        this.selectedConfig = selectedConfig;
    }

    protected class ConfigurationTableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        protected ConfigurationTableLabelProvider() {
        }

        public Image getColumnImage(Object element, int index) {
            return null;
        }

        public String getColumnText(Object element, int index) {
            MethodConfiguration config = (MethodConfiguration)element;
            return config.getName();
        }
    }
}

