/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

public class ProcessPropertyPage
extends PropertyPage {
    private static Font fHeadingFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");

    protected Control createContents(Composite ancestor) {
        this.noDefaultAndApplyButton();
        Composite parent = SWTFactory.createComposite(ancestor, ancestor.getFont(), 1, 1, 1808);
        IProcess proc = this.getProcess();
        SWTFactory.createLabel(parent, DebugPreferencesMessages.ProcessPropertyPage_0, fHeadingFont, 1);
        Text text = SWTFactory.createText(parent, 8, 1);
        ((GridData)text.getLayoutData()).horizontalIndent = 10;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)text, "org.eclipse.debug.ui.process_page_run_at_time_widget");
        text.setText(this.getTimeText(proc));
        text.setBackground(parent.getBackground());
        SWTFactory.createVerticalSpacer(parent, 2);
        SWTFactory.createLabel(parent, DebugPreferencesMessages.ProcessPropertyPage_1, fHeadingFont, 1);
        text = SWTFactory.createText(parent, 72, 1);
        ((GridData)text.getLayoutData()).horizontalIndent = 10;
        text.setText(this.getPathText(proc));
        text.setBackground(parent.getBackground());
        SWTFactory.createVerticalSpacer(parent, 2);
        SWTFactory.createLabel(parent, DebugPreferencesMessages.ProcessPropertyPage_Command_Line__1, fHeadingFont, 1);
        text = SWTFactory.createText(parent, 2632, 1, this.convertWidthInCharsToPixels(80), this.convertHeightInCharsToPixels(15), 1808);
        text.setBackground(parent.getBackground());
        ((GridData)text.getLayoutData()).horizontalIndent = 10;
        String commandLineText = this.getCommandLineText(proc);
        if (commandLineText != null) {
            text.setText(commandLineText);
        }
        this.setTitle(DebugPreferencesMessages.ProcessPropertyPage_2);
        return parent;
    }

    private IProcess getProcess() {
        IProcess proc = null;
        IAdaptable obj = this.getElement();
        if (obj instanceof IDebugElement) {
            obj = ((IDebugElement)obj).getDebugTarget().getProcess();
        }
        if (obj instanceof IProcess) {
            proc = (IProcess)obj;
        }
        return proc;
    }

    private String getPathText(IProcess proc) {
        String text = DebugPreferencesMessages.ProcessPropertyPage_3;
        if (proc != null) {
            String tmp = proc.getLabel();
            int idx = tmp.lastIndexOf("(");
            if (idx < 0) {
                idx = tmp.length();
            }
            text = tmp.substring(0, idx);
        }
        return text;
    }

    private String getTimeText(IProcess proc) {
        Pattern pattern;
        Matcher matcher;
        String text = DebugPreferencesMessages.ProcessPropertyPage_4;
        if (proc != null && (matcher = (pattern = Pattern.compile("\\(.*\\)")).matcher(proc.getLabel())).find()) {
            text = matcher.group(0);
        }
        return text;
    }

    private String getCommandLineText(IProcess proc) {
        String cmdline = DebugPreferencesMessages.ProcessPropertyPage_5;
        if (proc != null) {
            cmdline = proc.getAttribute(IProcess.ATTR_CMDLINE);
        }
        return cmdline;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.debug.ui.process_property_page_context");
    }
}

