/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import com.ibm.icu.text.BreakIterator;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.epf.authoring.gef.commands.ChangeNameCommand;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.figures.Colors;
import org.eclipse.epf.authoring.gef.figures.SelectableLabel;
import org.eclipse.epf.authoring.gef.figures.TextFigure;
import org.eclipse.epf.authoring.gef.util.TemplateConstants;
import org.eclipse.epf.diagram.model.ActivityDetailDiagram;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TaskNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.WorkProductDescriptorNode;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.editpolicies.DirectEditPolicy;
import org.eclipse.gef.requests.DirectEditRequest;
import org.eclipse.swt.graphics.Image;

public abstract class NamedNodeEditPart
extends NodeEditPart {
    protected static final int WRAP_WIDTH = 12;
    protected static final int WORK_PRODUCT_WRAP_WIDTH = 3;

    public NamedNodeEditPart(NamedNode model) {
        super((Node)model);
    }

    protected IFigure createFigure() {
        SelectableLabel l = new SelectableLabel();
        l.setLabelAlignment(1);
        if (this.getImage() != null) {
            l.setIcon(this.getImage());
        }
        l.setTextPlacement(4);
        l.setFont(TemplateConstants.DEFAULT_FONT);
        this.setLabelForegroundColor(l);
        return l;
    }

    private void setLabelForegroundColor(Label l) {
        NamedNode node = (NamedNode)this.getModel();
        boolean suppressed = node.isSuppressed();
        if (node.isReadOnly()) {
            if (!suppressed) {
                l.setForegroundColor(Colors.INHERITED_ELEMENT_LABEL);
            }
        } else if (!suppressed) {
            l.setForegroundColor(ColorConstants.black);
        }
        if (suppressed) {
            l.setForegroundColor(Colors.SUPRESSED_ELEMENT_LABEL);
        }
    }

    protected Image getImage() {
        return null;
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        if (!((Node)this.getModel()).isReadOnly()) {
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)this.createDirectEditPolicy());
        }
    }

    protected DirectEditPolicy createDirectEditPolicy() {
        return new DirectEditPolicy(){

            protected Command getDirectEditCommand(DirectEditRequest request) {
                return new ChangeNameCommand((NamedNode)NamedNodeEditPart.this.getModel(), (String)request.getCellEditor().getValue());
            }

            protected void showCurrentEditValue(DirectEditRequest request) {
                IFigure fig = NamedNodeEditPart.this.getDirectEditFigure();
                String s = (String)request.getCellEditor().getValue();
                if (fig instanceof Label) {
                    ((Label)fig).setText(s);
                } else if (fig instanceof TextFigure) {
                    ((TextFigure)fig).setText(s);
                }
                fig.getUpdateManager().performUpdate();
            }
        };
    }

    protected void handlePropertyChanged(Notification msg) {
        switch (msg.getFeatureID(NamedNode.class)) {
            case 7: {
                this.refreshVisuals();
                return;
            }
        }
        super.handlePropertyChanged(msg);
    }

    public void performRequest(Request request) {
        if (request.getType() == "direct edit" && !((Node)this.getModel()).isReadOnly()) {
            this.performDirectEdit();
        } else {
            super.performRequest(request);
        }
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IFigure fig = this.getDirectEditFigure();
        if (fig instanceof Label) {
            WorkBreakdownElementNode node;
            Object wbelement;
            Label l = (Label)fig;
            this.setLabelForegroundColor(l);
            String text = this.getModel() instanceof WorkBreakdownElementNode ? ((wbelement = (node = (WorkBreakdownElementNode)this.getModel()).getObject()) instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)wbelement)) ? ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)wbelement)) : ((NamedNode)this.getModel()).getName()) : ((NamedNode)this.getModel()).getName();
            try {
                if (this.getParent() instanceof ActivityDetailDiagramEditPart || this.getParent().getParent() instanceof ActivityDetailDiagramEditPart) {
                    int w = 12;
                    if (this.getModel() instanceof WorkProductDescriptorNode) {
                        w = 3;
                    }
                    if (this.getModel() instanceof TaskNode && GraphicalDataHelper.isAutoLayout((ActivityDetailDiagram)((ActivityDetailDiagram)this.getParent().getParent().getModel())) && text.length() < 16) {
                        int gap = 16 - text.length();
                        int i = 0;
                        while (i < gap / 2) {
                            text = String.valueOf(text) + " ";
                            ++i;
                        }
                        i = 0;
                        while (i < gap / 2) {
                            text = " " + text;
                            ++i;
                        }
                    }
                    text = this.wrap(text, w);
                }
            }
            catch (NullPointerException nullPointerException) {}
            l.setText(text);
        }
    }

    protected String wrap(String s, int wrapWidth) {
        String wrapped = "";
        BreakIterator bi = BreakIterator.getLineInstance();
        String remaining = s;
        while (true) {
            if (remaining.length() <= wrapWidth) {
                wrapped = String.valueOf(wrapped) + remaining;
                break;
            }
            bi.setText(remaining);
            int pos = bi.following(wrapWidth);
            if (pos == -1) {
                wrapped = String.valueOf(wrapped) + remaining;
                break;
            }
            if (pos >= remaining.length()) {
                wrapped = String.valueOf(wrapped) + remaining;
                break;
            }
            wrapped = String.valueOf(wrapped) + remaining.substring(0, pos) + "\n";
            remaining = remaining.substring(pos);
        }
        return wrapped;
    }
}

