/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.authoring.ui.wizards.NewConfigurationWizard;
import org.eclipse.epf.authoring.ui.wizards.NewLibraryWizard;
import org.eclipse.epf.authoring.ui.wizards.NewPluginWizard;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.IWizardCategory;
import org.eclipse.ui.wizards.IWizardDescriptor;
import org.eclipse.ui.wizards.IWizardRegistry;

public class AuthoringPerspective
implements IPerspectiveFactory {
    public static final String PERSPECTIVE_ID = AuthoringPerspective.class.getName();
    private static List<String> newWizardShortcuts = new ArrayList<String>();

    static {
        newWizardShortcuts.add(NewLibraryWizard.WIZARD_ID);
        newWizardShortcuts.add(NewPluginWizard.WIZARD_ID);
        newWizardShortcuts.add(NewConfigurationWizard.WIZARD_ID);
    }

    public static IPerspectiveDescriptor open() {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (activePage != null) {
            IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
            IPerspectiveDescriptor oldPerspective = activePage.getPerspective();
            if (!oldPerspective.getId().equals(PERSPECTIVE_ID)) {
                IPerspectiveDescriptor perspective = registry.findPerspectiveWithId(PERSPECTIVE_ID);
                activePage.setPerspective(perspective);
            }
            return oldPerspective;
        }
        return null;
    }

    public void createInitialLayout(IPageLayout layout) {
        layout.setEditorAreaVisible(true);
        String editorArea = layout.getEditorArea();
        IFolderLayout topLeftFolder = layout.createFolder("topLeft", 1, 0.3f, editorArea);
        IFolderLayout bottomLeftFolder = layout.createFolder("bottomLeft", 4, 0.5f, "topLeft");
        topLeftFolder.addView(LibraryView.VIEW_ID);
        bottomLeftFolder.addView(ConfigurationView.VIEW_ID);
        IPlaceholderFolderLayout outputFolder = layout.createPlaceholderFolder("bottom", 4, 0.65f, editorArea);
        outputFolder.addPlaceholder("org.eclipse.ui.views.PropertySheet");
        outputFolder.addPlaceholder("org.eclipse.ui.views.ProblemView");
        outputFolder.addPlaceholder("org.eclipse.search.ui.views.SearchView");
        outputFolder.addPlaceholder("org.eclipse.ui.console.ConsoleView");
        outputFolder.addPlaceholder("org.eclipse.ui.views.BookmarkView");
        outputFolder.addPlaceholder("org.eclipse.ui.views.ProgressView");
        layout.addNewWizardShortcut(NewLibraryWizard.WIZARD_ID);
        layout.addNewWizardShortcut(NewPluginWizard.WIZARD_ID);
        layout.addNewWizardShortcut(NewConfigurationWizard.WIZARD_ID);
        IWizardRegistry newWizardRegistry = PlatformUI.getWorkbench().getNewWizardRegistry();
        IWizardCategory newWizardCategory = newWizardRegistry.findCategory("org.eclipse.epf.ui.newWizards.category");
        IWizardDescriptor[] wizardDescriptors = newWizardCategory.getWizards();
        int i = 0;
        while (i < wizardDescriptors.length) {
            IWizardDescriptor wizardDescriptor = wizardDescriptors[i];
            String wizardId = wizardDescriptor.getId();
            if (!newWizardShortcuts.contains(wizardId)) {
                layout.addNewWizardShortcut(wizardId);
            }
            ++i;
        }
        PerspectiveListUtil.addPerspectiveShortList(layout);
    }
}

