/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.io.File;
import java.io.IOException;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.dialogs.MethodAddImageDialog;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.ui.LibraryUIUtil;
import org.eclipse.epf.richtext.IRichText;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.RichTextImages;
import org.eclipse.epf.richtext.RichTextResources;
import org.eclipse.epf.richtext.actions.RichTextAction;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class MethodAddImageAction
extends RichTextAction {
    public MethodAddImageAction(IRichText richText) {
        super(richText, 1);
        this.setImageDescriptor(RichTextImages.IMG_DESC_ADD_IMAGE);
        this.setToolTipText(RichTextResources.addImageAction_toolTipText);
        this.setEnabled(true);
    }

    public void execute(IRichText richText) {
        if (richText != null && richText instanceof IMethodRichText) {
            MethodAddImageDialog dialog = new MethodAddImageDialog(Display.getCurrent().getActiveShell(), ((IMethodRichText)richText).getMethodElement());
            dialog.open();
            if (dialog.getReturnCode() == 0 && dialog.getFileToCopy() != null) {
                try {
                    String imageLink = NetUtil.decodedFileUrl((String)LibraryUIUtil.getURLForAttachment((Shell)Display.getCurrent().getActiveShell(), (File)dialog.getFileToCopy(), (MethodElement)((IMethodRichText)richText).getMethodElement(), (boolean)true));
                    if (imageLink == null) {
                        return;
                    }
                    if (richText instanceof RichTextEditor) {
                        ((RichTextEditor)richText).setFocus();
                        ((RichTextEditor)richText).addImage(imageLink, "" + dialog.getHeight(), "" + dialog.getWidth(), dialog.getAltTag());
                    } else {
                        richText.executeCommand("addImage", new String[]{imageLink, "" + dialog.getHeight(), "" + dialog.getWidth(), dialog.getAltTag()});
                    }
                }
                catch (IOException ex) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                }
            }
        }
    }

    public boolean disableInSourceMode() {
        return false;
    }
}

