/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.celleditors;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractCheckBoxCellEditor {
    private ICellModifier modifier = null;
    private TreeEditor treeEditor = null;
    private Tree tree = null;
    private Control control = null;
    private int columnIndex;

    public AbstractCheckBoxCellEditor(Composite tree) {
        this.tree = (Tree)tree;
        this.treeEditor = new TreeEditor(this.tree);
    }

    public void setCellModifier(ICellModifier modifier) {
        this.modifier = modifier;
    }

    protected ICellModifier getCellModifier() {
        return this.modifier;
    }

    public abstract Image getImage(TreeItem var1, String var2);

    public abstract void modify(TreeItem var1, String var2);

    public void setEditorTo(TreeItem item, String columnproperty) {
        if (this.treeEditor.getItem() != null) {
            return;
        }
        if (this.control == null) {
            this.control = this.createControl(this.tree);
        }
        this.hookControl(this.control, item, columnproperty);
        this.treeEditor.minimumWidth = this.control.getSize().x;
        this.treeEditor.horizontalAlignment = 0x1000000;
        this.treeEditor.setEditor(this.control, item, this.columnIndex);
    }

    public void deleteEditorFrom(TreeItem item, String columnproperty) {
        this.control.setVisible(false);
        this.treeEditor.setEditor(null, null, this.columnIndex);
    }

    protected abstract Control createControl(Tree var1);

    protected abstract void hookControl(Control var1, TreeItem var2, String var3);

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public void setColumnIndex(int columnIndex) {
        this.columnIndex = columnIndex;
    }
}

