/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.FilterSorter;
import org.eclipse.epf.authoring.ui.dialogs.FilterSorterForAll;
import org.eclipse.epf.authoring.ui.filters.DescriptorConfigurationFilter;
import org.eclipse.epf.authoring.ui.filters.ExProcessAuthoringConfigurator;
import org.eclipse.epf.authoring.ui.util.AuthoringAccessibleListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterHelper;
import org.eclipse.epf.library.edit.itemsfilter.ICategoryFilter;
import org.eclipse.epf.library.edit.itemsfilter.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.IProcessFilter;
import org.eclipse.epf.library.edit.process.BreakdownElementItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class ADDInfoDialog
extends Dialog
implements ISelectionChangedListener,
IDoubleClickListener {
    protected Button okButton;
    protected Button cancelButton;
    protected Text ctrl_brief_desc;
    private String dialogTitle;
    private String tabStr;
    private Object contentElement;
    private ArrayList selectedList = new ArrayList();
    private boolean viewerSelectionSingle = false;
    private String viewerLabel = null;
    private TreeViewer treeViewer;
    protected IStructuredContentProvider contentProvider;
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            if (object instanceof VariabilityElement) {
                return TngUtil.getLabel((VariabilityElement)((VariabilityElement)object), (String)"", (boolean)true);
            }
            return super.getText(object);
        }
    };
    private AdapterFactory adapterFactory;
    private ComposedAdapterFactory composedAdapterFactory;
    private List alreadySelectedList = new ArrayList();
    private org.eclipse.epf.library.edit.IFilter filter;
    Pattern regexPattern;
    protected FilterHelper helper;
    private Button expandButton;
    private Button collapseButton;
    private Object input;

    public ADDInfoDialog(Shell parentShell, Object contentElement, String tabStr, List alreadyExists) {
        super(parentShell);
        this.contentElement = contentElement;
        this.tabStr = tabStr;
        this.filter = null;
        this.alreadySelectedList = alreadyExists;
        this.helper = new FilterHelper(contentElement, tabStr, null, null, this.alreadySelectedList);
        this.initProviderForTabs();
    }

    public ADDInfoDialog(Shell parentShell, org.eclipse.epf.library.edit.IFilter filter, String tabStr, List alreadyExists, Object input) {
        this(parentShell, filter, null, tabStr, alreadyExists);
        this.input = input;
    }

    public ADDInfoDialog(Shell parentShell, org.eclipse.epf.library.edit.IFilter filter, Object contentElement, String tabStr) {
        super(parentShell);
        this.filter = filter;
        this.tabStr = tabStr;
        this.helper = new FilterHelper(contentElement, tabStr, null, null, null);
        this.initProviderForTabs();
    }

    public ADDInfoDialog(Shell parentShell, org.eclipse.epf.library.edit.IFilter filter, Object contentElement, String tabStr, List alreadyExists) {
        super(parentShell);
        this.filter = filter;
        this.tabStr = tabStr;
        this.alreadySelectedList = alreadyExists;
        this.helper = new FilterHelper(contentElement, tabStr, null, null, alreadyExists);
        this.contentElement = contentElement;
        this.initProviderForTabs();
    }

    public ADDInfoDialog(Shell parentShell) {
        super(parentShell);
        this.helper = new FilterHelper(null, null, null, null, null);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveValues();
        }
        super.buttonPressed(buttonId);
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
        this.close();
    }

    public void saveValues() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() > 0) {
            Object[] objectArr = selection.toArray();
            int i = 0;
            while (i < objectArr.length) {
                Object obj = LibraryUtil.unwrap((Object)objectArr[i]);
                if (obj instanceof Activity) {
                    this.selectedList.add(obj);
                }
                ++i;
            }
        }
    }

    protected void cancelPressed() {
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
        super.cancelPressed();
    }

    public void setTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.dialogTitle == null) {
            this.dialogTitle = this.tabStr;
        }
        shell.setText("Activity Detail Diagram Info: " + this.dialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        layout.numColumns = 3;
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText("Select the activity to modify ADD");
        GridData gD1 = new GridData(1);
        typeLabel.setLayoutData((Object)gD1);
        Composite buttonsComposite = new Composite(composite, 0);
        GridData gd2 = new GridData(896);
        gd2.horizontalSpan = 2;
        buttonsComposite.setLayoutData((Object)gd2);
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.numColumns = 2;
        buttonsLayout.marginRight = 0;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        this.expandButton = new Button(buttonsComposite, 524288);
        this.expandButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("expandall.gif"));
        this.expandButton.setToolTipText(AuthoringUIResources.FilterDialog_ExpandAll);
        this.expandButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.FilterDialog_ExpandAll));
        gd2 = new GridData(544);
        this.expandButton.setLayoutData((Object)gd2);
        this.collapseButton = new Button(buttonsComposite, 8);
        this.collapseButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("collapseall.gif"));
        this.collapseButton.setToolTipText(AuthoringUIResources.FilterDialog_CollapseAll);
        this.collapseButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.FilterDialog_CollapseAll));
        gd2 = new GridData(128);
        this.collapseButton.setLayoutData((Object)gd2);
        this.createLine(composite, 3);
        this.createViewerLabel(composite);
        this.createViewer(composite);
        new Label(composite, 0).setText(AuthoringUIResources.FilterDialog_BriefDescription);
        this.ctrl_brief_desc = new Text(composite, 2634);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.heightHint = 60;
        this.ctrl_brief_desc.setLayoutData((Object)gd);
        this.createLine(composite, 3);
        this.addListener();
        return composite;
    }

    private void createViewer(Composite parent) {
        this.treeViewer = this.viewerSelectionSingle ? new TreeViewer(parent, 2820) : new TreeViewer(parent, 2818);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setUseHashlookup(true);
        if (this.input != null) {
            this.treeViewer.setInput(this.input);
        } else if (this.contentElement != null) {
            if (this.contentElement instanceof Activity) {
                if (this.contentElement instanceof Process) {
                    if (((Process)this.contentElement).eContainer() instanceof ProcessComponent) {
                        if (this.tabStr.equals(FilterConstants.GUIDANCE) || this.tabStr.equals(FilterConstants.ROADMAP) || this.tabStr.equals(FilterConstants.SUPPORTING_MATERIALS)) {
                            this.treeViewer.setInput((Object)UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement)));
                        } else {
                            this.treeViewer.setInput((Object)((Process)this.contentElement).eContainer());
                        }
                    } else {
                        this.treeViewer.setInput(this.contentElement);
                    }
                } else {
                    this.treeViewer.setInput((Object)UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement)));
                }
            } else {
                this.treeViewer.setInput((Object)UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement)));
            }
        } else {
            this.treeViewer.setInput((Object)LibraryService.getInstance().getCurrentMethodLibrary());
        }
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.treeViewer.getTree().setFont(parent.getFont());
        if (this.tabStr.equalsIgnoreCase(FilterConstants.ALL_ELEMENTS)) {
            this.treeViewer.setSorter((ViewerSorter)new FilterSorterForAll());
        } else {
            this.treeViewer.setSorter((ViewerSorter)new FilterSorter());
        }
        GridData spec = new GridData(1808);
        spec.widthHint = 300;
        spec.heightHint = 300;
        spec.horizontalSpan = 3;
        this.treeViewer.getControl().setLayoutData((Object)spec);
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    private void createViewerLabel(Composite parent) {
        if (this.viewerLabel != null) {
            Label label = new Label(parent, 0);
            label.setText(this.viewerLabel);
        }
    }

    public void setViewerSelectionSingle(boolean single) {
        this.viewerSelectionSingle = single;
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if ((element = LibraryUtil.unwrap((Object)element)) instanceof ContentElement || element instanceof Process) {
            this.selectedList.add(element);
        } else if (element instanceof ProcessComponent) {
            this.selectedList.add(element);
        } else if (element instanceof BreakdownElement) {
            this.selectedList.add(element);
        } else if (element instanceof ProcessPackage) {
            this.selectedList.add(element);
        }
        this.close();
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    public void traverseTree(TreeItem[] items, List list) {
        int i = 0;
        while (i < items.length) {
            TreeItem[] itemsx = items[i].getItems();
            if (itemsx.length > 1) {
                list.add(items[i].getData());
                this.traverseTree(itemsx, list);
            } else {
                list.add(items[i].getData());
            }
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
    }

    protected void updateButtons() {
    }

    public Object getParentObject(Object contentElement) {
        return MethodElementUtil.getMethodModel((Object)contentElement);
    }

    protected void updateSelection(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        Object selected = sel.getFirstElement();
        if (selected instanceof BreakdownElementWrapperItemProvider || selected instanceof BreakdownElementItemProvider) {
            Object unwrap = TngUtil.unwrap((Object)selected);
            this.setBriefDescription(unwrap);
        } else {
            this.setBriefDescription(selected);
        }
    }

    private void setBriefDescription(Object element) {
        String desc;
        if (element instanceof MethodElement && (desc = ((MethodElement)element).getBriefDescription()) != null) {
            this.ctrl_brief_desc.setText(desc);
        }
    }

    public void addListener() {
        this.expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ADDInfoDialog.this.treeViewer.expandAll();
            }
        });
        this.collapseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ADDInfoDialog.this.treeViewer.collapseAll();
            }
        });
    }

    public ArrayList getSelectedItems() {
        return this.selectedList;
    }

    private void initProviderForTabs() {
        if (this.filter != null) {
            if (this.filter instanceof IFilter) {
                if (this.filter instanceof ICategoryFilter) {
                    this.helper.setContentCategoryTabStr(this.tabStr);
                }
                ((IFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof DescriptorConfigurationFilter) {
                ((DescriptorConfigurationFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof ExProcessAuthoringConfigurator) {
                ((ExProcessAuthoringConfigurator)this.filter).setHelper(this.helper);
            }
        }
        if (this.filter instanceof IProcessFilter) {
            if (this.tabStr.equalsIgnoreCase(FilterConstants.WORK_PRODUCT_DESCRIPTORS)) {
                this.adapterFactory = TngAdapterFactory.INSTANCE.getPBSFilter_AdapterFactory(this.filter);
                this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
                this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBSFilter_ComposedAdapterFactory();
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory());
            } else if (this.tabStr.equalsIgnoreCase(FilterConstants.ROLE_DESCRIPTORS)) {
                this.adapterFactory = TngAdapterFactory.INSTANCE.getOBSFilter_AdapterFactory(this.filter);
                this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
                this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBSFilter_ComposedAdapterFactory();
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
            }
        } else {
            this.adapterFactory = TngAdapterFactory.INSTANCE.getItemsFilter_AdapterFactory(this.filter);
            this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
            this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getItemsFilter_ComposedAdapterFactory();
        }
    }

    public void setExistingElements(List list) {
        this.alreadySelectedList = list;
        if (this.helper != null) {
            this.helper.setAlreadySelectedList(list);
        }
    }

    public FilterHelper getHelper() {
        return this.helper;
    }

    public String[] getFilterTypeArray() {
        return null;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider, ComposedAdapterFactory composedAdapterFactory) {
        this.contentProvider = contentProvider;
        this.composedAdapterFactory = composedAdapterFactory;
    }

    public void setFilter(org.eclipse.epf.library.edit.IFilter filter) {
        this.filter = filter;
        if (this.helper != null) {
            if (this.filter instanceof IFilter) {
                ((IFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof DescriptorConfigurationFilter) {
                ((DescriptorConfigurationFilter)this.filter).setHelper(this.helper);
            }
        }
    }

    public void setInput(Object input) {
        if (input != null) {
            this.input = input;
        }
    }

    public void setViewerLabel(String viewerLabel) {
        this.viewerLabel = viewerLabel;
    }
}

