/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.util.LibraryProblemMonitor;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolutionGenerator;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class LibraryProblemMarkerResolutionGenerator
implements IMarkerResolutionGenerator {
    private static final IMarkerResolution[] EMPTY_RESOLUTIONS = new IMarkerResolution[0];
    private static boolean localDebug = true;

    public IMarkerResolution[] getResolutions(IMarker marker) {
        try {
            if (marker.getType() == LibraryProblemMonitor.UnresolvedBasedPluginMARKER_ID) {
                return new IMarkerResolution[]{new MissingPluginResolution(marker)};
            }
            if (marker.getType() == "org.eclipse.epf.library.multipleReplacers") {
                return new IMarkerResolution[]{new MultipleReplacerResolution(marker)};
            }
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        return EMPTY_RESOLUTIONS;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class LibraryProblemMarkerResolution
    extends WorkbenchMarkerResolution {
        private IMarker currentMarker;

        public LibraryProblemMarkerResolution(IMarker currentMarker) {
            this.currentMarker = currentMarker;
        }

        public IMarker[] findOtherMarkers(IMarker[] markers) {
            ArrayList<IMarker> similarMarkerList = new ArrayList<IMarker>();
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                if (!this.currentMarker.equals((Object)marker) && this.acceptedType(marker)) {
                    similarMarkerList.add(marker);
                }
                ++i;
            }
            IMarker[] similarMarkers = new IMarker[similarMarkerList.size()];
            similarMarkerList.toArray(similarMarkers);
            return similarMarkers;
        }

        protected abstract boolean acceptedType(IMarker var1);

        public String getDescription() {
            return null;
        }

        public Image getImage() {
            return null;
        }

        protected void save(Set<Resource> resouresToSave) {
            if (resouresToSave == null) {
                return;
            }
            ILibraryPersister.FailSafeMethodLibraryPersister persister = LibraryServiceUtil.getCurrentPersister().getFailSafePersister();
            for (Resource res : resouresToSave) {
                try {
                    persister.save(res);
                    persister.commit();
                }
                catch (Exception e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                    persister.rollback();
                }
            }
        }
    }

    private static class MissingPluginResolution
    extends LibraryProblemMarkerResolution {
        public MissingPluginResolution(IMarker currentMarker) {
            super(currentMarker);
        }

        public String getLabel() {
            return AuthoringUIResources.LpmResolutionGenerator_removeUnresolvedBasePlugins;
        }

        public void run(IMarker marker) {
            LibraryService.getInstance().getLibraryProblemMonitor().fixProblem(marker);
        }

        protected boolean acceptedType(IMarker marker) {
            boolean ret = false;
            try {
                ret = LibraryProblemMonitor.UnresolvedBasedPluginMARKER_ID.equals(marker.getType());
            }
            catch (CoreException e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            return ret;
        }
    }

    private static class MultipleReplacerResolution
    extends LibraryProblemMarkerResolution {
        public MultipleReplacerResolution(IMarker currentMarker) {
            super(currentMarker);
        }

        public String getLabel() {
            return AuthoringUIResources.LpmResolutionGenerator_removeMultipleRepacers;
        }

        public void run(IMarker marker) {
            try {
                ILibraryManager libMgr = LibraryService.getInstance().getCurrentLibraryManager();
                if (libMgr != null) {
                    String replacerGuids = (String)marker.getAttribute("replacerGuids");
                    String[] guids = AbstractProcessElementLayout.getPathArray((String)replacerGuids);
                    if (guids == null || guids.length == 0) {
                        return;
                    }
                    HashSet<Resource> resouresToSave = new HashSet<Resource>();
                    int i = 0;
                    while (i < guids.length) {
                        MethodElement element = libMgr.getMethodElement(guids[i]);
                        if (element instanceof VariabilityElement) {
                            EReference feature = UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement();
                            element.eSet((EStructuralFeature)feature, null);
                            feature = UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType();
                            element.eSet((EStructuralFeature)feature, (Object)VariabilityType.NA);
                            marker.delete();
                            Resource res = element.eResource();
                            if (res != null) {
                                resouresToSave.add(res);
                            }
                        }
                        ++i;
                    }
                    this.save(resouresToSave);
                }
            }
            catch (Exception e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }

        protected boolean acceptedType(IMarker marker) {
            boolean ret = false;
            try {
                ret = "org.eclipse.epf.library.multipleReplacers".equals(marker.getType());
            }
            catch (CoreException e) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            }
            return ret;
        }
    }
}

