/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class UILayoutHelper {
    private static Composite editorComposite;
    private static Composite previewComposite;
    private static CTabFolder tabFolder;

    public static void createTabs(ScrolledForm form, FormToolkit toolkit) {
        tabFolder = new CTabFolder(form.getBody(), 0x800080);
        TableWrapData td = new TableWrapData(256);
        tabFolder.setLayoutData((Object)td);
        Color selectedColor = toolkit.getColors().getColor("org.eclipse.ui.forms.SEPARATOR");
        tabFolder.setSelectionBackground(new Color[]{selectedColor, toolkit.getColors().getBackground()}, new int[]{50});
        CTabItem editorItem = new CTabItem(tabFolder, 0);
        editorItem.setText(AuthoringUIText.EDITOR_TEXT);
        editorComposite = UILayoutHelper.createComposite(toolkit);
        editorItem.setControl((Control)editorComposite);
        CTabItem previewItem = new CTabItem(tabFolder, 0);
        previewItem.setText(AuthoringUIText.PREVIEW_PAGE_TITLE);
        previewComposite = UILayoutHelper.createComposite(toolkit);
        previewItem.setControl((Control)previewComposite);
        toolkit.paintBordersFor((Composite)tabFolder);
        toolkit.adapt((Control)tabFolder, true, true);
        tabFolder.setSelection(0);
    }

    private static Composite createComposite(FormToolkit toolkit) {
        Composite composite = toolkit.createComposite((Composite)tabFolder);
        composite.setLayoutData((Object)new TableWrapData(256));
        composite.setLayout((Layout)new TableWrapLayout());
        return composite;
    }

    public static Composite getEditorComposite() {
        return editorComposite;
    }

    public static Composite getPreviewComposite() {
        return previewComposite;
    }
}

