/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.publishing.services;

import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.publishing.services.PublishingContentValidator;
import org.eclipse.epf.uma.MethodElement;

public class PublishingRunnable
implements Runnable {
    int timeout_limit = 600000;
    HtmlBuilder htmlBuilder;
    String html_file;
    IElementLayout layout;

    public PublishingRunnable(HtmlBuilder htmlBuilder, int timeout) {
        this.timeout_limit = timeout;
        this.htmlBuilder = htmlBuilder;
    }

    private PublishingContentValidator getValidator() {
        return (PublishingContentValidator)this.htmlBuilder.getValidator();
    }

    public void run() {
        if (this.htmlBuilder != null && this.layout != null) {
            this.html_file = null;
            this.html_file = this.htmlBuilder.generateHtml(this.layout);
        }
    }

    public String generateHtml(IElementLayout layout) {
        this.layout = layout;
        MethodElement element = this.layout.getElement();
        Timer timer = new Timer();
        try {
            try {
                this.getValidator().setTargetElement(element);
                Thread t = new Thread(this);
                t.start();
                t.join(this.timeout_limit);
                if (t.isAlive()) {
                    timer.stop();
                    this.getValidator().logInfo(element, "publishing element takes " + timer.getTime() + " mini seconds already and is still not done yet ...");
                    timer.start();
                    t.join();
                }
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
                this.getValidator().setTargetElement(null);
                this.getValidator().getReferencedElements().remove(element);
                timer.stop();
                this.getValidator().logInfo(element, String.valueOf(timer.getTotalTime()) + " mini seconds publishing element");
            }
        }
        finally {
            this.getValidator().setTargetElement(null);
            this.getValidator().getReferencedElements().remove(element);
            timer.stop();
            this.getValidator().logInfo(element, String.valueOf(timer.getTotalTime()) + " mini seconds publishing element");
        }
        return this.html_file;
    }

    public void dispose() {
        this.layout = null;
        this.html_file = null;
        this.htmlBuilder = null;
    }
}

