/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.persistence;

import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.persistence.ILibraryResourceSetFactory;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.services.Services;
import org.osgi.framework.Bundle;

public class PersistenceService {
    private static final boolean DEBUG = PersistencePlugin.getDefault().isDebugging();
    public static final PersistenceService INSTANCE = new PersistenceService();
    private static HashMap<String, FactoryDef> typeToFactoryDefMap;

    private PersistenceService() {
    }

    public ILibraryResourceSet createResourceSet(String type) {
        ILibraryResourceSetFactory factory = PersistenceService.getFactory(type);
        if (factory != null) {
            return factory.createLibraryResourceSet();
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    public static final ILibraryResourceSetFactory getFactory(String persistenceType) {
        FactoryDef factory;
        if (typeToFactoryDefMap == null) {
            typeToFactoryDefMap = new HashMap();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.epf.library.persistence", "resourceSetFactories");
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    String pluginId = extension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)pluginId);
                    IConfigurationElement[] configElements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement configElement = configElements[j];
                        try {
                            String className = configElement.getAttribute("class");
                            String type = configElement.getAttribute("type");
                            if (className != null && className.trim().length() > 0 && type != null && type.trim().length() > 0) {
                                int version = Services.parseVersion((String)configElement.getAttribute("version"));
                                FactoryDef factoryDef = typeToFactoryDefMap.get(type);
                                if (factoryDef == null || factoryDef.version < version) {
                                    typeToFactoryDefMap.put(type, new FactoryDef(bundle, type, className, version));
                                }
                            }
                        }
                        catch (Exception e) {
                            CommonPlugin.INSTANCE.log((Object)e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if ((factory = typeToFactoryDefMap.get(persistenceType)) != null) {
            block14: {
                if (factory.instance == null) {
                    try {
                        ILibraryResourceSetFactory resourceSetFactory = (ILibraryResourceSetFactory)factory.bundle.loadClass(factory.className).newInstance();
                        if (persistenceType.equals(resourceSetFactory.getPersistenceType())) {
                            factory.instance = resourceSetFactory;
                        } else {
                            PersistencePlugin.getDefault().getLogger().logError(String.valueOf(factory.className) + " is registered with the wrong persistence type '" + persistenceType + "'. The correct type must be '" + resourceSetFactory.getPersistenceType() + "'");
                        }
                    }
                    catch (Exception e) {
                        PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
                        if (!DEBUG) break block14;
                        e.printStackTrace();
                    }
                }
            }
            return factory.instance;
        }
        return null;
    }

    private static class FactoryDef {
        Bundle bundle;
        String type;
        String className;
        int version;
        ILibraryResourceSetFactory instance;

        private FactoryDef(Bundle bundle, String type, String className, int version) {
            this.bundle = bundle;
            this.type = type;
            this.className = className;
            this.version = version;
        }
    }
}

