/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.library.persistence.internal.IFailSafeSavable;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.MultiFileXMISaveImpl;
import org.eclipse.epf.persistence.PersistencePlugin;
import org.eclipse.epf.persistence.TxRecord;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodLibraryPersister
implements IFileBasedLibraryPersister {
    public static final MethodLibraryPersister INSTANCE = new MethodLibraryPersister();
    public static final String RESOURCE_FOLDER = "resources";
    private static final List folderInfos = new ArrayList();
    protected List warnings;
    private static final ILibraryPersister.FailSafeMethodLibraryPersister nonFailSafePersister;

    static {
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getGuidance(), false));
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getWorkProduct(), true));
        folderInfos.add(new FolderInfo(UmaPackage.eINSTANCE.getActivity(), true));
        nonFailSafePersister = new NonFailSafePersister();
    }

    public static String getCorrectPath(ContentDescription content) {
        return MethodLibraryPersister.getCorrectPath((DescribableElement)content.eContainer(), content);
    }

    private static String getCorrectPath(DescribableElement e, ContentDescription content) {
        if (e == null) {
            return null;
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        if (plugin == null) {
            return null;
        }
        Resource resource = plugin.eResource();
        URI uri = MultiFileSaveUtil.getFinalURI(resource);
        File pluginDir = new File(uri.toFileString()).getParentFile();
        String folderPath = MethodLibraryPersister.staticGetFolderPath(e.eClass());
        String dir = new StringBuffer(pluginDir.getAbsolutePath()).append(File.separator).append(folderPath).append(File.separator).toString();
        return MethodLibraryPersister.getNextAvailableFileName(dir, e, content);
    }

    public static String getNextAvailableFileName(String dir, String requestedName, MultiResourceEObject e) {
        String path;
        File file;
        String currentFilename = null;
        File currentFile = null;
        MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)e.eDirectResource();
        if (resource != null && !(file = new File(dir, currentFilename = (currentFile = new File(path = ((MultiFileXMIResourceImpl)e.eResource()).getFinalURI().toFileString())).getName())).exists()) {
            return file.getAbsolutePath();
        }
        path = new StringBuffer(dir).append(requestedName).append(".xmi").toString();
        file = new File(path);
        if (file.equals(currentFile)) {
            return path;
        }
        if (currentFilename != null && currentFilename.equals(requestedName) || file.exists()) {
            int i = 2;
            while (true) {
                if (!new File(path = new StringBuffer(dir).append(requestedName).append(' ').append(i).append(".xmi").toString()).exists()) {
                    return path;
                }
                ++i;
            }
        }
        return path;
    }

    static String getNextAvailableFileName(String dir, ContentDescription content) {
        return MethodLibraryPersister.getNextAvailableFileName(dir, (DescribableElement)content.eContainer(), content);
    }

    private static String getNextAvailableFileName(String dir, DescribableElement e, ContentDescription content) {
        return MethodLibraryPersister.getNextAvailableFileName(dir, e.getName(), (MultiResourceEObject)content);
    }

    private static String staticGetFolderPath(EClass eClazz) {
        int size = folderInfos.size();
        FolderInfo info = null;
        int i = 0;
        while (i < size) {
            FolderInfo folderInfo = (FolderInfo)folderInfos.get(i);
            if (folderInfo.eClazz.isSuperTypeOf(eClazz)) {
                info = folderInfo;
            }
            ++i;
        }
        if (info != null) {
            if (info.eClazz == eClazz || info.shared) {
                return info.name;
            }
            return new StringBuffer(info.name).append(File.separatorChar).append(MethodLibraryPersister.lowerAndPluralize(eClazz.getName())).toString();
        }
        return MethodLibraryPersister.lowerAndPluralize(eClazz.getName());
    }

    public static String lowerAndPluralize(String name) {
        if ((name = name.toLowerCase()).endsWith("children")) {
            return name;
        }
        if (name.endsWith("child")) {
            return String.valueOf(name) + "ren";
        }
        if (name.endsWith("data")) {
            return name;
        }
        if (name.endsWith("datum")) {
            return String.valueOf(name.substring(0, name.length() - 2)) + "a";
        }
        if (name.endsWith("by")) {
            return String.valueOf(name) + "s";
        }
        if (name.endsWith("y")) {
            return String.valueOf(name.substring(0, name.length() - 1)) + "ies";
        }
        if (name.endsWith("ex")) {
            return String.valueOf(name.substring(0, name.length() - 2)) + "ices";
        }
        if (name.endsWith("x")) {
            return String.valueOf(name) + "es";
        }
        if (name.endsWith("us")) {
            return String.valueOf(name.substring(0, name.length() - 2)) + "i";
        }
        if (name.endsWith("ss")) {
            return String.valueOf(name) + "es";
        }
        if (name.endsWith("s")) {
            return name;
        }
        return String.valueOf(name) + "s";
    }

    public String geResourceVirtualPath(MethodElement e) {
        String folderPath = this.getElementVirtualPath(e);
        if (folderPath == null || folderPath.length() == 0) {
            return RESOURCE_FOLDER;
        }
        StringBuffer buffer = new StringBuffer(folderPath);
        if (!folderPath.endsWith(File.separator)) {
            buffer.append(File.separator);
        }
        buffer.append(RESOURCE_FOLDER);
        return buffer.toString();
    }

    public String getElementVirtualPath(MethodElement e) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        if (plugin == null) {
            if (!(e instanceof MethodConfiguration) && !(e instanceof MethodLibrary)) {
                System.err.println("error in MethodLibraryPersister.getElementPath(): plugin element without a valid plugin. This problem needs to be fixed.");
            }
            return "";
        }
        String folderPath = this.getFolderRelativePath(e);
        String pluginName = plugin.getName();
        return folderPath.length() == 0 ? String.valueOf(pluginName) + File.separator : new StringBuffer(pluginName).append(File.separatorChar).append(folderPath).append(File.separatorChar).toString();
    }

    private String getRelativeElementPath(MethodElement e) {
        String relPluginPath;
        String folderPath = this.getFolderRelativePath(e);
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
        if (plugin == null) {
            if (e instanceof MethodConfiguration || e instanceof MethodLibrary) {
                return folderPath;
            }
            System.err.println("error in MethodLibraryPersister.getElementPath(): plugin element without a valid plugin. This problem needs to be fixed.");
            return "";
        }
        if (plugin.eContainer() == null) {
            System.err.println("error in MethodLibraryPersister.getElementPath(): plugin without library set. This problem needs to be fixed.");
            return "";
        }
        if (plugin.eResource() != null) {
            Resource libRes = UmaUtil.getMethodLibrary((EObject)plugin).eResource();
            if (libRes == plugin.eResource()) {
                relPluginPath = plugin.getName();
            } else {
                URI uri = MultiFileSaveUtil.getFinalURI(plugin.eResource());
                URI libUri = MultiFileSaveUtil.getFinalURI(libRes);
                URI relUri = uri.deresolve(libUri);
                relPluginPath = relUri.trimSegments(1).toFileString();
            }
        } else {
            relPluginPath = plugin.getName();
        }
        return folderPath.length() == 0 ? String.valueOf(relPluginPath) + File.separator : new StringBuffer(relPluginPath).append(File.separatorChar).append(folderPath).append(File.separatorChar).toString();
    }

    public static void main(String[] args) {
        EClass eCls = UmaPackage.eINSTANCE.getTemplate();
        System.out.println(eCls.getName());
    }

    public void adjustLocation(Resource resource) {
        HashSet modifiedResources = new HashSet();
        MultiFileSaveUtil.adjustLocation(resource, modifiedResources);
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
        Iterator iter = modifiedResources.iterator();
        while (iter.hasNext()) {
            try {
                resourceSet.save((Resource)iter.next(), null);
            }
            catch (Exception e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    public void save(Resource resource) throws Exception {
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
        resourceSet.save(resource, null);
    }

    protected void deleteFiles(MethodElement e, String path, ResourceSet resourceSet) {
        if (new File(path).isDirectory() && !e.eIsProxy()) {
            Iterator iter = resourceSet.getResources().iterator();
            while (iter.hasNext()) {
                Resource res = (Resource)iter.next();
                MethodElement me = PersistenceUtil.getMethodElement(res);
                if (me == null || !UmaUtil.isContainedBy((EObject)me, (Object)e)) continue;
                res.unload();
                iter.remove();
            }
        }
        try {
            FileManager.getInstance().deleteResource(path, null);
        }
        catch (CoreException ex) {
            CommonPlugin.INSTANCE.log((Object)ex);
            throw new WrappedException((Exception)((Object)ex));
        }
    }

    protected void delete(MethodElement e, Set modifiedResources) {
        String path;
        MultiFileResourceSetImpl resourceSet;
        block9: {
            if (!UmaUtil.hasDirectResource((EObject)e)) {
                return;
            }
            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)e.eResource();
            resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
            for (Object element : resource.getContents()) {
                if (!(element instanceof MethodElement) || element == e) continue;
                resourceSet.removeURIMappings((EObject)e, modifiedResources);
                resource.getContents().remove((Object)e);
                modifiedResources.add(resource);
                return;
            }
            if (MultiFileSaveUtil.hasOwnFolder(e)) {
                path = new File(resource.getFinalURI().toFileString()).getParent();
                ArrayList<Resource> unloadedResources = new ArrayList<Resource>();
                do {
                    unloadedResources.clear();
                    for (Resource res : new ArrayList(resourceSet.getResources())) {
                        MethodElement me;
                        if (!res.isLoaded() || (me = PersistenceUtil.getMethodElement(res)) == null || !UmaUtil.isContainedBy((EObject)me, (Object)e)) continue;
                        unloadedResources.add(res);
                    }
                    for (Resource res : unloadedResources) {
                        res.unload();
                    }
                    resourceSet.getResources().removeAll(unloadedResources);
                } while (!unloadedResources.isEmpty());
            } else {
                path = resource.getFinalURI().toFileString();
            }
            try {
                resourceSet.cleanUp(resource, modifiedResources);
            }
            catch (Exception e1) {
                CommonPlugin.INSTANCE.log((Object)e1);
                if (!MultiFileSaveUtil.DEBUG) break block9;
                e1.printStackTrace();
            }
        }
        this.deleteFiles(e, path, (ResourceSet)resourceSet);
    }

    private static void getObjectsWithDirectResources(EObject e, Collection objectsWithDirectResources) {
        if (UmaUtil.hasDirectResource((EObject)e)) {
            objectsWithDirectResources.add(e);
        } else {
            Iterator iter = e.eContents().iterator();
            while (iter.hasNext()) {
                MethodLibraryPersister.getObjectsWithDirectResources((EObject)iter.next(), objectsWithDirectResources);
            }
        }
    }

    public void delete(MethodElement e) {
        ArrayList elements = new ArrayList();
        MethodLibraryPersister.getObjectsWithDirectResources((EObject)e, elements);
        this.deleteAndSave(elements);
    }

    private void deleteAndSave(ArrayList elements) {
        if (!elements.isEmpty()) {
            HashSet modifiedResources = new HashSet();
            Iterator iter = elements.iterator();
            while (iter.hasNext()) {
                this.delete((MethodElement)iter.next(), modifiedResources);
            }
            for (Resource resource : modifiedResources) {
                try {
                    this.save(resource);
                }
                catch (Exception ex) {
                    throw new WrappedException(ex);
                }
            }
        }
    }

    private static String staticGetFolderRelativePath(MethodElement e) {
        if (e instanceof MethodPlugin) {
            return "";
        }
        if (e instanceof ContentElement) {
            return MethodLibraryPersister.staticGetFolderPath(e.eClass());
        }
        if (e instanceof MethodConfiguration) {
            return "configurations";
        }
        MethodUnit unit = UmaUtil.getMethodUnit((MethodElement)e);
        if (unit instanceof ProcessComponent) {
            Process proc = ((ProcessComponent)unit).getProcess();
            if (proc instanceof CapabilityPattern) {
                return "capabilitypatterns";
            }
            if (proc instanceof DeliveryProcess) {
                return "deliveryprocesses";
            }
        } else if (unit instanceof ContentDescription) {
            return MethodLibraryPersister.staticGetFolderRelativePath((MethodElement)unit.eContainer());
        }
        return "";
    }

    public String getFolderRelativePath(MethodElement e) {
        return MethodLibraryPersister.staticGetFolderRelativePath(e);
    }

    public List getWarnings() {
        if (this.warnings == null) {
            this.warnings = new ArrayList();
        }
        return this.warnings;
    }

    FailSafePersister getFailSafePersister(Map options) {
        FailSafePersister persister = new FailSafePersister();
        persister.saveOptions.putAll(options);
        persister.saveOptions.put("TX_RECORD", persister.txRecord);
        return persister;
    }

    public boolean hasOwnFolder(Object e) {
        return MultiFileSaveUtil.hasOwnFolder(e);
    }

    public boolean hasOwnResource(Object e) {
        return MultiFileSaveUtil.hasOwnResource(e, MultiFileResourceSetImpl.DEFAULT_SAVE_SEPARATELY_CLASS_SET);
    }

    public ILibraryPersister.FailSafeMethodLibraryPersister getFailSafePersister() {
        return new FailSafePersister();
    }

    public String getFileExtension(Object e) {
        return ".xmi";
    }

    public void save(MethodElement element) throws Exception {
        MultiFileXMIResourceImpl resource;
        if (!this.hasOwnResourceWithoutReferrer(element)) {
            return;
        }
        MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)UmaUtil.getMethodLibrary((EObject)element).eResource().getResourceSet();
        Map<Object, Object> options = resourceSet.getDefaultSaveOptions();
        Resource.Internal res = ((InternalEObject)element).eDirectResource();
        if (res instanceof MultiFileXMIResourceImpl) {
            resource = (MultiFileXMIResourceImpl)res;
            resourceSet.save(resource, options);
        } else {
            URI uri = MultiFileSaveUtil.createURI(element, (ResourceSet)resourceSet);
            resource = MultiFileSaveUtil.save((ResourceSet)resourceSet, (EObject)element, uri, options, false);
        }
        resource.updateTimeStamps();
        String str = (String)options.get("REFRESH_NEW_RESOURCE");
        if (str != null && Boolean.valueOf(str).booleanValue()) {
            RefreshJob.getInstance().resourceSaved(resource);
            FileManager.getInstance().refresh(resource);
        }
    }

    public boolean hasOwnResourceWithoutReferrer(Object e) {
        return e instanceof MethodConfiguration;
    }

    public File createMethodPluginFolder(String pluginName, MethodLibrary library) {
        File libDir = new File(library.eResource().getURI().toFileString()).getParentFile();
        File pluginDir = new File(libDir, pluginName);
        if (!pluginDir.exists() && !pluginDir.mkdirs()) {
            throw new MultiFileIOException(NLS.bind((String)PersistenceResources.cannot_create_dir_msg, (Object)pluginDir));
        }
        return pluginDir;
    }

    public File getDefaultMethodConfigurationFolder(MethodLibrary library) {
        return this.getDefaultMethodConfigurationFolder(library, true);
    }

    public File getDefaultMethodConfigurationFolder(MethodLibrary library, boolean create) {
        File libDir = new File(library.eResource().getURI().toFileString()).getParentFile();
        File configDir = new File(libDir, "configurations");
        if (configDir.exists()) {
            return configDir;
        }
        if (create) {
            if (!configDir.mkdirs()) {
                throw new MultiFileIOException(NLS.bind((String)PersistenceResources.cannot_create_dir_msg, (Object)configDir));
            }
            return configDir;
        }
        return null;
    }

    public void setDefaultMethodConfigurationFolder(MethodLibrary library, File file) {
    }

    public boolean isContainedBy(Resource resource, Resource containerResource) {
        MethodElement e = PersistenceUtil.getMethodElement(containerResource);
        if (this.hasOwnFolder(e)) {
            String path = FileManager.toFileString(resource.getURI());
            String containerPath = FileManager.toFileString(containerResource.getURI());
            if (path == null || containerPath == null) {
                return false;
            }
            return new Path(containerPath).removeLastSegments(1).isPrefixOf((IPath)new Path(path));
        }
        return false;
    }

    public String getResourceFolderPath(MethodElement e) {
        String folderPath = this.getFolderAbsolutePath(e);
        return folderPath != null ? new File(folderPath, RESOURCE_FOLDER).getAbsolutePath() : RESOURCE_FOLDER;
    }

    public String getFolderAbsolutePath(MethodElement e) {
        MethodLibrary library = UmaUtil.getMethodLibrary((EObject)e);
        File libDir = null;
        if (library == null) {
            Resource.Internal resource;
            MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)e);
            if (plugin != null && (resource = ((InternalEObject)plugin).eDirectResource()) != null) {
                URI uri = MultiFileSaveUtil.getFinalURI((Resource)resource);
                libDir = new File(uri.toFileString()).getParentFile().getParentFile();
            }
        } else {
            URI uri = MultiFileSaveUtil.getFinalURI(library.eResource());
            libDir = new File(uri.toFileString()).getParentFile();
        }
        if (libDir != null) {
            return new File(libDir, this.getRelativeElementPath(e)).getAbsolutePath();
        }
        return null;
    }

    public void delete(Collection<MethodElement> elems) {
        ArrayList elements = new ArrayList();
        Iterator<MethodElement> it = elems.iterator();
        while (it.hasNext()) {
            MethodLibraryPersister.getObjectsWithDirectResources((EObject)it.next(), elements);
        }
        this.deleteAndSave(elements);
    }

    public File getFile(Resource resource) {
        URI uri = MultiFileSaveUtil.getFinalURI(resource);
        return new File(FileManager.toFileString(uri));
    }

    static class FailSafePersister
    extends MethodLibraryPersister
    implements ILibraryPersister.FailSafeMethodLibraryPersister {
        private Map saveOptions;
        private TxRecord txRecord = new TxRecord(){

            public void clear() {
                if (this.warnings != null && !this.warnings.isEmpty()) {
                    FailSafePersister.this.warnings = Collections.unmodifiableList(this.warnings);
                }
                super.clear();
            }
        };
        private Map elementToInfoMapToDeleteFiles;

        public FailSafePersister() {
            this.saveOptions = new HashMap<Object, Object>(MultiFileResourceSetImpl.DEFAULT_SAVE_OPTIONS);
            this.txRecord = new TxRecord();
            this.saveOptions.put("TX_RECORD", this.txRecord);
            this.elementToInfoMapToDeleteFiles = new HashMap();
        }

        public List getWarnings() {
            if (this.txRecord.getTxID() == null) {
                return super.getWarnings();
            }
            return this.txRecord.getWarnings();
        }

        public Map getSaveOptions() {
            return this.saveOptions;
        }

        void checkMove(Resource resource) {
            MultiFileXMIResourceImpl mfResource = (MultiFileXMIResourceImpl)resource;
            if (mfResource.txStarted()) {
                throw new MultiFileIOException(NLS.bind((String)PersistenceResources.moveResourceError_msg, (Object)resource));
            }
        }

        public void save(Resource resource) throws Exception {
            if (resource != null) {
                if (resource.getResourceSet() instanceof MultiFileResourceSetImpl && resource instanceof MultiFileXMIResourceImpl) {
                    Resource libResource;
                    MethodLibrary lib;
                    MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)resource.getResourceSet();
                    if (resourceSet == null) {
                        return;
                    }
                    Resource libResourceToSave = null;
                    MethodElement me = PersistenceUtil.getMethodElement(resource);
                    if (me != null && (lib = UmaUtil.getMethodLibrary((EObject)me)) != null && (libResource = lib.eResource()) != null && libResource != resource && PersistenceUtil.checkToolVersion(libResource) != 0) {
                        libResourceToSave = libResource;
                    }
                    if (MultiFileXMISaveImpl.checkModifyRequired(this.saveOptions)) {
                        ArrayList<Resource> resources;
                        if (libResourceToSave != null) {
                            resources = new ArrayList();
                            resources.add(resource);
                            resources.add(libResourceToSave);
                        } else {
                            resources = Collections.singletonList(resource);
                        }
                        MultiFileSaveUtil.checkModify(resources);
                        MultiFileSaveUtil.checkOutOfSynch(resources, this.saveOptions);
                        MultiFileSaveUtil.checkFilePathLength(resources);
                    }
                    resourceSet.save(resource, this.saveOptions);
                    if (libResourceToSave != null) {
                        resourceSet.save(libResourceToSave, this.saveOptions);
                    }
                } else if (resource instanceof IFailSafeSavable) {
                    IFailSafeSavable failSafeSavable = (IFailSafeSavable)resource;
                    failSafeSavable.setTxID(this.txRecord.getTxID());
                    resource.save(this.saveOptions);
                    this.txRecord.getResourcesToCommit().add(resource);
                } else {
                    throw new IllegalAccessException("Resource must implement org.eclipse.epf.library.persistence.internal.IFailSafeSavable");
                }
            }
        }

        public void adjustLocation(Resource resource) {
            this.checkMove(resource);
            HashSet<Resource> modifiedResources = new HashSet<Resource>();
            if (MultiFileSaveUtil.prepareAdjustLocation((MultiFileXMIResourceImpl)resource, modifiedResources)) {
                this.txRecord.getResourcesToCommit().add(resource);
                HashSet<Resource> resourcesToCheck = new HashSet<Resource>(modifiedResources);
                resourcesToCheck.addAll(resourcesToCheck);
                MultiFileSaveUtil.checkModify(resourcesToCheck);
                if (!modifiedResources.isEmpty()) {
                    MultiFileSaveUtil.checkOutOfSynch(modifiedResources, this.saveOptions);
                    Iterator iter = modifiedResources.iterator();
                    while (iter.hasNext()) {
                        try {
                            this.save((Resource)iter.next());
                        }
                        catch (Exception e) {
                            PersistencePlugin.getDefault().getLogger().logError((Throwable)e);
                            throw new MultiFileIOException(e.toString());
                        }
                    }
                }
            }
            this.commit();
        }

        public void adjustLocation(Collection resources) {
            if (resources == null || resources.isEmpty()) {
                return;
            }
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                this.checkMove((Resource)iter.next());
            }
            HashSet<Resource> modifiedResources = new HashSet<Resource>();
            HashSet<Resource> resourcesToCheck = new HashSet<Resource>();
            for (MultiFileXMIResourceImpl resource : resources) {
                if (!MultiFileSaveUtil.prepareAdjustLocation(resource, modifiedResources)) continue;
                this.txRecord.getResourcesToCommit().add(resource);
                resourcesToCheck.add(resource);
            }
            resourcesToCheck.addAll(modifiedResources);
            if (!resourcesToCheck.isEmpty()) {
                MultiFileSaveUtil.checkModify(resourcesToCheck);
            }
            if (!modifiedResources.isEmpty()) {
                MultiFileSaveUtil.checkOutOfSynch(modifiedResources, this.saveOptions);
                Iterator iter2 = modifiedResources.iterator();
                while (iter2.hasNext()) {
                    try {
                        this.save((Resource)iter2.next());
                    }
                    catch (Exception e) {
                        CommonPlugin.INSTANCE.log((Object)e);
                        throw new MultiFileIOException(e.toString());
                    }
                }
            }
            this.commit();
        }

        protected void deleteFiles(MethodElement e, String path, ResourceSet resourceSet) {
            this.elementToInfoMapToDeleteFiles.put(e, new Object[]{path, resourceSet});
        }

        private void superDeleteFiles(MethodElement e, String path, ResourceSet resourceSet) {
            super.deleteFiles(e, path, resourceSet);
        }

        public void commit() {
            int size = this.txRecord.getResourcesToCommit().size();
            int i = 0;
            while (i < size) {
                ((IFailSafeSavable)this.txRecord.getResourcesToCommit().get(i)).commit();
                ++i;
            }
            i = 0;
            while (i < size) {
                ((IFailSafeSavable)this.txRecord.getResourcesToCommit().get(i)).txFinished(true);
                ++i;
            }
            i = 0;
            while (i < size) {
                ((IFailSafeSavable)this.txRecord.getResourcesToCommit().get(i)).deleteBackup();
                ++i;
            }
            this.txRecord.clear();
            for (Map.Entry entry : this.elementToInfoMapToDeleteFiles.entrySet()) {
                Object[] info = (Object[])entry.getValue();
                String path = (String)info[0];
                try {
                    this.superDeleteFiles((MethodElement)entry.getKey(), path, (ResourceSet)info[1]);
                }
                catch (Exception e) {
                    IStatus status;
                    if (e instanceof WrappedException) {
                        e = ((WrappedException)e).exception();
                    }
                    String msg = PersistenceResources.ErrMsg_CouldNotDelete;
                    String otherMsg = null;
                    if (e instanceof CoreException && (status = ((CoreException)((Object)e)).getStatus()) != null) {
                        otherMsg = UmaUtil.getMessage((IStatus)status);
                    }
                    if (otherMsg == null) {
                        otherMsg = "";
                    }
                    msg = MessageFormat.format(msg, path, otherMsg);
                    e = new Exception(msg, e);
                    this.getWarnings().add(e);
                    CommonPlugin.INSTANCE.log((Object)e);
                    if (!MultiFileSaveUtil.DEBUG) continue;
                    e.printStackTrace();
                }
            }
            this.elementToInfoMapToDeleteFiles.clear();
        }

        public void rollback() {
            if (!this.txRecord.getResourcesToCommit().isEmpty()) {
                try {
                    IFailSafeSavable resource2;
                    int max = this.txRecord.getResourcesToCommit().size() - 1;
                    ArrayList<IFailSafeSavable> restoredResources = new ArrayList<IFailSafeSavable>();
                    int i = max;
                    while (i > -1) {
                        resource2 = (IFailSafeSavable)this.txRecord.getResourcesToCommit().get(i);
                        if (resource2.restore()) {
                            restoredResources.add(resource2);
                        }
                        --i;
                    }
                    for (IFailSafeSavable resource2 : restoredResources) {
                        resource2.setModified(true);
                    }
                    i = max;
                    while (i > -1) {
                        block12: {
                            resource2 = (Resource)this.txRecord.getResourcesToCommit().get(i);
                            if (resource2.hasTempURI()) {
                                try {
                                    new File(resource2.getURI().toFileString()).delete();
                                }
                                catch (Exception e) {
                                    CommonPlugin.INSTANCE.log((Object)e);
                                    if (!MultiFileSaveUtil.DEBUG) break block12;
                                    e.printStackTrace();
                                }
                            }
                        }
                        --i;
                    }
                    i = max;
                    while (i > -1) {
                        ((IFailSafeSavable)this.txRecord.getResourcesToCommit().get(i)).txFinished(false);
                        --i;
                    }
                }
                catch (RuntimeException e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                    if (MultiFileSaveUtil.DEBUG) {
                        e.printStackTrace();
                    }
                    throw e;
                }
            }
            this.txRecord.clear();
        }

        public ILibraryPersister.FailSafeMethodLibraryPersister getFailSafePersister() {
            return this;
        }

        public String getCurrentTxID() {
            return this.txRecord.getTxID();
        }
    }

    private static class FolderInfo {
        EClass eClazz;
        boolean shared;
        private String name;

        public FolderInfo(EClass clazz, boolean shared) {
            this.eClazz = clazz;
            this.shared = shared;
            this.name = MethodLibraryPersister.lowerAndPluralize(clazz.getName());
        }
    }

    public static class NonFailSafePersister
    extends MethodLibraryPersister
    implements ILibraryPersister.FailSafeMethodLibraryPersister {
        private Map saveOptions = new HashMap();

        public void commit() {
        }

        public void rollback() {
        }

        public String getCurrentTxID() {
            return null;
        }

        public void adjustLocation(Collection resources) {
            Iterator iter = resources.iterator();
            while (iter.hasNext()) {
                this.adjustLocation((Resource)iter.next());
            }
        }

        public Map getSaveOptions() {
            return this.saveOptions;
        }
    }
}

