/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.migration;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.epf.common.service.versioning.VersionUtil;
import org.eclipse.epf.persistence.migration.IMigrator;
import org.eclipse.epf.persistence.migration.UpgradeCallerInfo;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.osgi.framework.Bundle;

public final class MappingUtil {
    private static final boolean localDebug = false;
    private static Map migrators;
    private static Set oldNsUris;
    private static Map<String, String> adjustedLibNsURIMap;

    static {
        oldNsUris = new HashSet();
        adjustedLibNsURIMap = new HashMap<String, String>();
    }

    public static final IMigrator getMigrator(String libNsURI) {
        Migrator migrator;
        if (migrators == null) {
            migrators = new HashMap();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint("org.eclipse.epf.library.persistence", "migrators");
            if (extensionPoint != null) {
                IExtension[] extensions = extensionPoint.getExtensions();
                int i = 0;
                while (i < extensions.length) {
                    IExtension extension = extensions[i];
                    String pluginId = extension.getNamespaceIdentifier();
                    Bundle bundle = Platform.getBundle((String)pluginId);
                    IConfigurationElement[] configElements = extension.getConfigurationElements();
                    int j = 0;
                    while (j < configElements.length) {
                        IConfigurationElement configElement = configElements[j];
                        try {
                            String className = configElement.getAttribute("class");
                            String nsURI = configElement.getAttribute("libNsURI");
                            if (className != null && className.trim().length() > 0 && nsURI != null && nsURI.trim().length() > 0) {
                                migrators.put(nsURI, new Migrator(bundle, className, nsURI));
                            }
                        }
                        catch (Exception e) {
                            CommonPlugin.INSTANCE.log((Object)e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
        }
        if ((migrator = (Migrator)migrators.get(libNsURI)) != null) {
            if (migrator.instance == null) {
                try {
                    migrator.instance = (IMigrator)migrator.bundle.loadClass(migrator.className).newInstance();
                }
                catch (Exception e) {
                    CommonPlugin.INSTANCE.log((Object)e);
                }
            }
            return migrator.instance;
        }
        return null;
    }

    public static final synchronized boolean conversionRequired(String libPath, VersionUtil.VersionCheckInfo info) {
        boolean ret;
        String currentNsURI = PersistenceUtil.getUMANsURI();
        String libNsURI = PersistenceUtil.getUMANsURI(libPath);
        if (oldNsUris.contains(libNsURI = MappingUtil.getAdjustedLibNsURI(libNsURI, info))) {
            return true;
        }
        if (currentNsURI.equals(libNsURI)) {
            return false;
        }
        boolean bl = ret = MappingUtil.getMigrator(libNsURI) != null;
        if (ret) {
            oldNsUris.add(libNsURI);
        }
        return ret;
    }

    private static String getAdjustedLibNsURI(String libNsURI, VersionUtil.VersionCheckInfo info) {
        String ret = MappingUtil.getAdjustedLibNsURI_(libNsURI, info);
        if (ret != libNsURI) {
            adjustedLibNsURIMap.put(libNsURI, ret);
        }
        return ret;
    }

    private static String getAdjustedLibNsURI_(String libNsURI, VersionUtil.VersionCheckInfo info) {
        String currentNsURI = PersistenceUtil.getUMANsURI();
        if (!currentNsURI.equals(libNsURI)) {
            return libNsURI;
        }
        if (!libNsURI.equals("http://www.eclipse.org/epf/uma/1.0.4/uma.ecore")) {
            return libNsURI;
        }
        if (info.toolVersion.equals(info.currentMinToolVersion)) {
            return libNsURI;
        }
        return "http://www.eclipse.org/epf/uma/1.0.3/uma.ecore";
    }

    public static void migrate(String libPath, IProgressMonitor monitor, UpgradeCallerInfo info) throws Exception {
        IMigrator migrator = MappingUtil.getMigratorByLibPath(libPath);
        if (migrator == null && info.getUpgradableFiles() != null && !info.getUpgradableFiles().isEmpty()) {
            File upgradableFile = info.getUpgradableFiles().get(0);
            migrator = MappingUtil.getMigratorByLibPath(upgradableFile.getAbsolutePath());
        }
        if (migrator != null) {
            migrator.migrate(libPath, monitor, info);
        }
    }

    public static IMigrator getMigratorByLibPath(String libPath) {
        String nsURI = PersistenceUtil.getUMANsURI(libPath);
        String adjustedLibNsURI = adjustedLibNsURIMap.get(nsURI);
        if (adjustedLibNsURI != null) {
            nsURI = adjustedLibNsURI;
        }
        return MappingUtil.getMigrator(nsURI);
    }

    public static void main(String[] args) {
        String libPath = args[0];
        System.out.println("Start migrating method library at '" + libPath + "'...");
        try {
            MappingUtil.migrate(libPath, null, null);
            System.out.println();
            System.out.println("Migration successfull.");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println();
            System.err.println("Migration failed.");
        }
    }

    private static class Migrator {
        Bundle bundle;
        String className;
        String libNsURI;
        IMigrator instance;

        public Migrator(Bundle bundle, String className, String libNsURI) {
            this.bundle = bundle;
            this.className = className;
            this.libNsURI = libNsURI;
        }
    }
}

