/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.resourcemanager.impl;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.resourcemanager.ResourcemanagerPackage;
import org.eclipse.epf.resourcemanager.impl.ResourceDescriptorImpl;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.util.UmaUtil;

public class ResourceManagerImpl
extends MultiResourceEObject
implements ResourceManager {
    private static final long serialVersionUID = -5164471475509169204L;
    protected static final String GUID_EDEFAULT = null;
    protected String guid = GUID_EDEFAULT;
    protected static final String URI_BASE_EDEFAULT = null;
    protected String uriBase = URI_BASE_EDEFAULT;
    protected EList subManagers = null;
    protected EList resourceDescriptors = null;
    private Map idToResourceDescriptorMap;

    protected ResourceManagerImpl() {
        this.guid = UmaUtil.generateGUID();
    }

    protected EClass eStaticClass() {
        return ResourcemanagerPackage.Literals.RESOURCE_MANAGER;
    }

    public String getGuid() {
        return this.guid;
    }

    public void setGuid(String newGuid) {
        String oldGuid = this.guid;
        this.guid = newGuid;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldGuid, (Object)this.guid));
        }
    }

    public String getUriBase() {
        return this.uriBase;
    }

    public void setUriBase(String newUriBase) {
        String oldUriBase = this.uriBase;
        this.uriBase = newUriBase;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldUriBase, (Object)this.uriBase));
        }
    }

    public List getSubManagers() {
        if (this.subManagers == null) {
            this.subManagers = new EObjectContainmentEList.Resolving(ResourceManager.class, (InternalEObject)this, 2);
        }
        return this.subManagers;
    }

    public List getResourceDescriptors() {
        if (this.resourceDescriptors == null) {
            this.resourceDescriptors = new EObjectContainmentEList.Resolving(ResourceDescriptor.class, (InternalEObject)this, 3);
        }
        return this.resourceDescriptors;
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (guid: ");
        result.append(this.guid);
        result.append(", uriBase: ");
        result.append(this.uriBase);
        result.append(')');
        return result.toString();
    }

    public EObject eResolveProxy(InternalEObject proxy) {
        return super.eResolveProxy(proxy);
    }

    public void resolve() {
        URI base = MultiFileSaveUtil.getFinalURI(this.eResource());
        for (ResourceDescriptorImpl desc : this.getResourceDescriptors()) {
            desc.resolvedURI = URI.createURI((String)desc.getUri()).resolve(base);
        }
    }

    public void deresolve() {
        URI base = MultiFileSaveUtil.getFinalURI(this.eResource());
        for (ResourceDescriptor desc : this.getResourceDescriptors()) {
            desc.setUri(desc.getResolvedURI().deresolve(base).toString());
        }
    }

    public List removeResourceDescriptor(URI uri, boolean clearFolder) {
        ArrayList<ResourceDescriptor> removedList = new ArrayList<ResourceDescriptor>();
        Iterator iter = this.getResourceDescriptors().iterator();
        while (iter.hasNext()) {
            ResourceDescriptor desc = (ResourceDescriptor)iter.next();
            if (!uri.equals((Object)desc.getResolvedURI().trimFragment())) continue;
            iter.remove();
            removedList.add(desc);
        }
        if (clearFolder) {
            String oldDir = String.valueOf(new File(uri.toFileString()).getParent()) + File.separator;
            Iterator iter2 = this.getResourceDescriptors().iterator();
            while (iter2.hasNext()) {
                ResourceDescriptor desc = (ResourceDescriptor)iter2.next();
                if (!desc.getResolvedURI().toFileString().startsWith(oldDir)) continue;
                iter2.remove();
                removedList.add(desc);
            }
        }
        return removedList;
    }

    public ResourceDescriptor getResourceDescriptor(String guid) {
        if (this.idToResourceDescriptorMap == null) {
            this.idToResourceDescriptorMap = new HashMap();
            this.eAdapters().add((Object)new AdapterImpl(){

                public void notifyChanged(Notification msg) {
                    switch (msg.getFeatureID(ResourceManager.class)) {
                        case 3: {
                            switch (msg.getEventType()) {
                                case 3: {
                                    ResourceDescriptor desc = (ResourceDescriptor)msg.getNewValue();
                                    ResourceManagerImpl.this.idToResourceDescriptorMap.put(desc.getId(), desc);
                                    return;
                                }
                                case 5: {
                                    for (ResourceDescriptor desc : (Collection)msg.getNewValue()) {
                                        ResourceManagerImpl.this.idToResourceDescriptorMap.put(desc.getId(), desc);
                                    }
                                    return;
                                }
                                case 4: {
                                    ResourceManagerImpl.this.idToResourceDescriptorMap.remove(((ResourceDescriptor)msg.getOldValue()).getId());
                                    return;
                                }
                                case 6: {
                                    Iterator iter = ((Collection)msg.getOldValue()).iterator();
                                    while (iter.hasNext()) {
                                        ResourceManagerImpl.this.idToResourceDescriptorMap.remove(((ResourceDescriptor)iter.next()).getId());
                                    }
                                    return;
                                }
                            }
                        }
                    }
                }
            });
            for (ResourceDescriptor element : this.getResourceDescriptors()) {
                this.idToResourceDescriptorMap.put(element.getId(), element);
            }
        }
        return (ResourceDescriptor)this.idToResourceDescriptorMap.get(guid);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getSubManagers()).basicRemove((Object)otherEnd, msgs);
            }
            case 3: {
                return ((InternalEList)this.getResourceDescriptors()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getGuid();
            }
            case 1: {
                return this.getUriBase();
            }
            case 2: {
                return this.getSubManagers();
            }
            case 3: {
                return this.getResourceDescriptors();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setGuid((String)newValue);
                return;
            }
            case 1: {
                this.setUriBase((String)newValue);
                return;
            }
            case 2: {
                this.getSubManagers().clear();
                this.getSubManagers().addAll((Collection)newValue);
                return;
            }
            case 3: {
                this.getResourceDescriptors().clear();
                this.getResourceDescriptors().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setGuid(GUID_EDEFAULT);
                return;
            }
            case 1: {
                this.setUriBase(URI_BASE_EDEFAULT);
                return;
            }
            case 2: {
                this.getSubManagers().clear();
                return;
            }
            case 3: {
                this.getResourceDescriptors().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        EStructuralFeature feature = this.getFeatureWithOverridenDefaultValue(featureID);
        if (feature != null) {
            return this.isFeatureWithOverridenDefaultValueSet(feature);
        }
        switch (featureID) {
            case 0: {
                return GUID_EDEFAULT == null ? this.guid != null : !GUID_EDEFAULT.equals(this.guid);
            }
            case 1: {
                return URI_BASE_EDEFAULT == null ? this.uriBase != null : !URI_BASE_EDEFAULT.equals(this.uriBase);
            }
            case 2: {
                return this.subManagers != null && !this.subManagers.isEmpty();
            }
            case 3: {
                return this.resourceDescriptors != null && !this.resourceDescriptors.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public void dispose() {
        if (this.idToResourceDescriptorMap != null) {
            this.idToResourceDescriptorMap.clear();
            this.idToResourceDescriptorMap = null;
        }
        this.eAdapters().clear();
        Iterator iter = ((InternalEList)this.getSubManagers()).basicIterator();
        while (iter.hasNext()) {
            ResourceManager subMgr = (ResourceManager)iter.next();
            if (((InternalEObject)subMgr).eIsProxy()) continue;
            subMgr.dispose();
        }
    }
}

