/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.services;

import java.io.File;
import java.io.IOException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.dataexchange.util.BaseResourceHandler;
import org.eclipse.epf.dataexchange.util.UrlInfo;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryResourceManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.epf.xml.uma.MethodElement;

public class ExportResourceHandler
extends BaseResourceHandler {
    private static boolean localDebug = false;

    public ExportResourceHandler(File sourceLibRoot, File targetLibRoot) {
        super(sourceLibRoot, targetLibRoot);
    }

    public UrlInfo resolveFileUrl(Object owner, String srcUrl) throws Exception {
        return this.loadUrlInfoWithFixedPath(owner, srcUrl);
    }

    private UrlInfo loadUrlInfoWithFixedPath(Object owner, String srcUrl) {
        UrlInfo info = new UrlInfo();
        info.sourceUrl = srcUrl;
        info.targetUrl = srcUrl;
        String srcFile = this.getFileRelPath(owner, srcUrl);
        MethodElement ownerElem = null;
        if (owner instanceof MethodElement) {
            ownerElem = (MethodElement)owner;
        }
        if (srcFile != null && ownerElem != null) {
            MethodPlugin srcPlugin = ExportResourceHandler.getSourcePlugin(ownerElem);
            ILibraryResourceManager libResMgr = ResourceHelper.getResourceMgr((org.eclipse.epf.uma.MethodElement)srcPlugin);
            String srcPluginPath = libResMgr.getPhysicalPluginPath((org.eclipse.epf.uma.MethodElement)srcPlugin);
            File srcRoot = new File(srcPluginPath).getParentFile();
            info.sourceFile = new File(srcRoot, srcFile);
            if (!info.sourceFile.isFile() || !info.sourceFile.exists()) {
                String newSrcFile = null;
                try {
                    newSrcFile = NetUtil.decodeURL((String)srcFile);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (newSrcFile != null) {
                    srcFile = newSrcFile;
                    info.sourceFile = new File(srcRoot, srcFile);
                }
            }
            info.targetFile = new File(this.targetLibRoot, srcFile);
            info.targetUrl = srcFile.replace(File.separatorChar, '/');
        }
        return info;
    }

    protected static MethodPlugin getSourcePlugin(MethodElement ownerElem) {
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager == null) {
            throw new UnsupportedOperationException();
        }
        org.eclipse.epf.uma.MethodElement element = manager.getMethodElement(ownerElem.getId());
        if (element == null) {
            throw new UnsupportedOperationException();
        }
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)element);
        if (plugin == null) {
            throw new UnsupportedOperationException();
        }
        return plugin;
    }

    private String getFileRelPath(Object owner, String srcUrl) {
        try {
            if (owner instanceof MethodElement) {
                org.eclipse.epf.uma.MethodElement element;
                String id = ((MethodElement)owner).getId();
                ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
                if (manager != null && (element = manager.getMethodElement(id)) != null) {
                    ILibraryResourceManager libResMgr = ResourceHelper.getResourceMgr((org.eclipse.epf.uma.MethodElement)element);
                    if (libResMgr != null) {
                        File f;
                        String path;
                        String oldPath;
                        String elementPath = ResourceHelper.getFolderAbsolutePath((org.eclipse.epf.uma.MethodElement)element);
                        String pluginPath = libResMgr.getPhysicalPluginPath(element);
                        File pluginParent = new File(pluginPath).getParentFile();
                        File file = new File(elementPath, srcUrl);
                        String filePath = file.getCanonicalPath();
                        String retPath = filePath.substring(pluginParent.getCanonicalPath().length() + 1);
                        if (localDebug && !(oldPath = (path = (f = new File(new File(this.sourceLibRoot, ResourceHelper.getElementPath((org.eclipse.epf.uma.MethodElement)element)), srcUrl)).getCanonicalPath()).substring(this.sourceLibRoot.getCanonicalPath().length() + 1)).equals(retPath)) {
                            System.out.println("LD> oldPath: " + oldPath);
                            System.out.println("LD> retPath: " + retPath);
                            System.out.println("");
                        }
                        return retPath;
                    }
                    File f = new File(new File(this.sourceLibRoot, ResourceHelper.getElementPath((org.eclipse.epf.uma.MethodElement)element)), srcUrl);
                    String path = f.getCanonicalPath();
                    return path.substring(this.sourceLibRoot.getCanonicalPath().length() + 1);
                }
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    public void copyResource(String sourceFile, EObject obj, MethodPlugin umaPlugin) {
        ILibraryResourceManager libResMgr = ResourceHelper.getResourceMgr((org.eclipse.epf.uma.MethodElement)umaPlugin);
        String srcPluginPath = libResMgr.getPhysicalPluginPath((org.eclipse.epf.uma.MethodElement)umaPlugin);
        File srcPluginRoot = new File(srcPluginPath);
        File src = new File(srcPluginRoot.getParentFile(), sourceFile);
        if (src.exists()) {
            File tgt = new File(this.targetLibRoot, sourceFile);
            FileUtil.copyFile((File)src, (File)tgt);
        }
    }
}

