/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.migration.diagram.ad.map;

import java.util.ArrayList;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.util.DiagramCoreUtil;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.migration.diagram.ad.map.IMapConstants;
import org.eclipse.epf.migration.diagram.ad.map.MapUtil;
import org.eclipse.gmf.runtime.notation.Anchor;
import org.eclipse.gmf.runtime.notation.Bendpoints;
import org.eclipse.gmf.runtime.notation.Bounds;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.IdentityAnchor;
import org.eclipse.gmf.runtime.notation.LayoutConstraint;
import org.eclipse.gmf.runtime.notation.NotationFactory;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.RelativeBendpoint;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.UMLPackage;

public class MapNode
implements IMapConstants {
    protected Node node;
    protected org.eclipse.gmf.runtime.notation.Node notationNode;
    private Activity activity;
    private Diagram diagram;
    protected String name;
    protected ActivityNode umlNode;
    private static final int IMAGE_HEIGHT = 32;

    public MapNode(Node node) {
        this.node = node;
    }

    public MapNode() {
    }

    public org.eclipse.gmf.runtime.notation.Node updateResource() {
        ActivityNode tempUMLNode;
        org.eclipse.gmf.runtime.notation.Node tempNotationNode;
        Diagram diagram = this.getDiagram();
        if (graphUMLNodeMap.get(this.node) != null && (tempNotationNode = this.findNotationNode(diagram, tempUMLNode = (ActivityNode)graphUMLNodeMap.get(this.node))) != null) {
            return tempNotationNode;
        }
        this.updateNode();
        this.notationNode = MapUtil.createNotationNode_AD(diagram, this.umlNode);
        diagram.insertChild((View)this.notationNode);
        this.setLayoutConstraint(this.node, this.notationNode);
        this.notationNode.setElement((EObject)this.umlNode);
        this.setInheritedAttribute(this.node, this.notationNode);
        return this.notationNode;
    }

    private void setLayoutConstraint(Node node, org.eclipse.gmf.runtime.notation.Node notationNode) {
        Bounds bounds = NotationFactory.eINSTANCE.createBounds();
        int type = new Integer(notationNode.getType());
        if (node.getHeight() == -1) {
            if (type == 1005 || type == 1002) {
                bounds.setHeight(24);
            } else if (type == 1003 || type == 1006) {
                bounds.setHeight(5);
            } else if (type == 1001) {
                bounds.setHeight(24);
            }
        } else {
            bounds.setHeight(node.getHeight());
        }
        if (node.getWidth() == -1 && (type == 1005 || type == 1002)) {
            bounds.setWidth(48);
        } else {
            bounds.setWidth(node.getWidth());
        }
        int w = bounds.getWidth();
        int h = bounds.getHeight();
        Dimension dim = DiagramCoreUtil.getTextSizeInWrapLabel((String)this.name, null, (int)w, (int)h, null);
        int dimw = dim.width;
        if (w < dimw && dimw != 0) {
            bounds.setWidth(dimw);
        }
        bounds.setX(node.getLocation().x);
        bounds.setY(node.getLocation().y);
        notationNode.setLayoutConstraint((LayoutConstraint)bounds);
    }

    private void setInheritedAttribute(Node node, org.eclipse.gmf.runtime.notation.Node notationNode) {
        if (node.getLinkedElement() == null && node.getGraphNode().getBriefDescription() != null && !node.getGraphNode().getBriefDescription().trim().equals("")) {
            BridgeHelper.markInherited((EModelElement)notationNode);
        }
    }

    private org.eclipse.gmf.runtime.notation.Node findNotationNode(Diagram diagram, ActivityNode umlNode) {
        EList list = diagram.getChildren();
        if (list != null && list.size() > 0) {
            for (org.eclipse.gmf.runtime.notation.Node node : list) {
                if (!umlNode.equals(node.getElement())) continue;
                return node;
            }
        }
        return null;
    }

    public void updateNode() {
        if (this.node instanceof NamedNode) {
            this.name = ((NamedNode)this.node).getName();
        }
    }

    public void outgoingConnections(Node node) {
        EList connections = node.getOutgoingConnections();
        if (connections != null && connections.size() > 0) {
            for (Link link : connections) {
                Edge edge = this.createConnection(link);
                ActivityNode sourceNode = (ActivityNode)graphUMLNodeMap.get(node);
                org.eclipse.gmf.runtime.notation.Node sourceNotationNode = this.findNotationNode(this.getDiagram(), sourceNode);
                sourceNotationNode.getSourceEdges().add((Object)edge);
                sourceNotationNode.getDiagram().insertEdge(edge);
            }
        }
    }

    private ControlFlow createControlFlow() {
        ControlFlow controlFlow = (ControlFlow)this.getActivity().createEdge("", UMLPackage.eINSTANCE.getControlFlow());
        return controlFlow;
    }

    private void loadSourceAndTargetEndPoint(Edge edge, Link flow) {
        Bounds bounds;
        IdentityAnchor anchor;
        Point srcPoint = flow.getSourceEndPoint();
        Point targetPoint = flow.getTargetEndPoint();
        View srcView = edge.getSource();
        View targetView = edge.getTarget();
        int srcType = new Integer(srcView.getType());
        int targetType = new Integer(targetView.getType());
        if ((srcType == 1003 || srcType == 1006 || srcType == 1005 || srcType == 1002) && srcPoint != null && srcView instanceof org.eclipse.gmf.runtime.notation.Node && (anchor = this.createIdentityAnchor(srcPoint, bounds = (Bounds)((org.eclipse.gmf.runtime.notation.Node)srcView).getLayoutConstraint())) != null) {
            edge.setSourceAnchor((Anchor)anchor);
        }
        if ((targetType == 1003 || targetType == 1006 || targetType == 1005 || targetType == 1002) && targetPoint != null && targetView instanceof org.eclipse.gmf.runtime.notation.Node && (anchor = this.createIdentityAnchor(targetPoint, bounds = (Bounds)((org.eclipse.gmf.runtime.notation.Node)targetView).getLayoutConstraint())) != null) {
            edge.setTargetAnchor((Anchor)anchor);
        }
    }

    private IdentityAnchor createIdentityAnchor(Point point, Bounds bounds) {
        Point tempPoint = new Point(bounds.getX() + point.x, bounds.getY() + point.y);
        PrecisionPoint prePoint = MapUtil.getAnchorRelativeLocation(tempPoint, bounds);
        String id = MapUtil.composeTerminalString(prePoint);
        IdentityAnchor value = NotationFactory.eINSTANCE.createIdentityAnchor();
        value.setId(id);
        return value;
    }

    private void loadBendPoints(Edge edge, Link flow) {
        EList list = flow.getBendpoints();
        ArrayList<RelativeBendpoint> relativePoints = new ArrayList<RelativeBendpoint>();
        RelativeBendpoint rbp = new RelativeBendpoint(0, 0, 0, 0);
        relativePoints.add(rbp);
        if (list != null && list.size() > 0) {
            for (AbsoluteBendpoint abp : list) {
                Point targetPoint;
                Point srcPoint;
                org.eclipse.gmf.runtime.notation.Node srcNode = (org.eclipse.gmf.runtime.notation.Node)edge.getSource();
                org.eclipse.gmf.runtime.notation.Node targetNode = (org.eclipse.gmf.runtime.notation.Node)edge.getTarget();
                int srcType = new Integer(srcNode.getType());
                int targetType = new Integer(targetNode.getType());
                Bounds sourceBounds = (Bounds)srcNode.getLayoutConstraint();
                Bounds targetBounds = (Bounds)targetNode.getLayoutConstraint();
                int srcLine = MapUtil.getNoOfLines(srcNode);
                int targetLine = MapUtil.getNoOfLines(targetNode);
                int srcHeight = MapUtil.getTextHeight(srcNode);
                int targetHeight = MapUtil.getTextHeight(targetNode);
                int srcX = sourceBounds.getX() + sourceBounds.getWidth() / 2;
                int srcY = sourceBounds.getY() + (32 + srcLine * srcHeight) / 2;
                int tarX = targetBounds.getX() + targetBounds.getWidth() / 2;
                int tarY = targetBounds.getY() + (32 + targetLine * targetHeight) / 2;
                if ((srcType == 1003 || srcType == 1006 || srcType == 1005 || srcType == 1002) && (srcPoint = flow.getSourceEndPoint()) != null) {
                    srcX = sourceBounds.getX() + srcPoint.x;
                    srcY = sourceBounds.getY() + srcPoint.y;
                }
                if ((targetType == 1003 || targetType == 1006 || targetType == 1005 || targetType == 1002) && (targetPoint = flow.getTargetEndPoint()) != null) {
                    tarX = targetBounds.getX() + targetPoint.x;
                    tarY = targetBounds.getY() + targetPoint.y;
                }
                if (targetType == 1001) {
                    tarX = targetBounds.getX() + targetBounds.getWidth() / 2;
                    tarY = targetBounds.getY() + targetBounds.getHeight() / 2;
                }
                int rel1 = abp.x - srcX;
                int rel2 = abp.y - srcY;
                int rel3 = abp.x - tarX;
                int rel4 = abp.y - tarY;
                RelativeBendpoint rbp1 = new RelativeBendpoint(rel1, rel2, rel3, rel4);
                relativePoints.add(rbp1);
            }
        }
        relativePoints.add(rbp);
        if (relativePoints.size() > 0) {
            RelativeBendpoints bendpoints = NotationFactory.eINSTANCE.createRelativeBendpoints();
            bendpoints.setPoints(relativePoints);
            edge.setBendpoints((Bendpoints)bendpoints);
        }
    }

    private Edge findEdge(org.eclipse.gmf.runtime.notation.Node sourceNode, org.eclipse.gmf.runtime.notation.Node targetNode) {
        EList list = this.notationNode.getDiagram().getEdges();
        if (list != null && list.size() > 0) {
            for (Edge edge : list) {
                if (edge.getTarget() == null || !targetNode.equals(edge.getTarget()) || edge.getSource() == null || !sourceNode.equals(edge.getSource())) continue;
                return edge;
            }
        }
        return null;
    }

    public void incomingConnections(Node node) {
        EList connections = node.getIncomingConnections();
        if (connections != null && connections.size() > 0) {
            for (Link link : connections) {
                Edge edge = this.createConnection(link);
                ActivityNode sourceNode = (ActivityNode)graphUMLNodeMap.get(node);
                org.eclipse.gmf.runtime.notation.Node sourceNotationNode = this.findNotationNode(this.getDiagram(), sourceNode);
                sourceNotationNode.getTargetEdges().add((Object)edge);
                sourceNotationNode.getDiagram().insertEdge(edge);
            }
        }
    }

    private Edge createConnection(Link link) {
        org.eclipse.gmf.runtime.notation.Node targetNotationNode;
        Node sourceObj = link.getSource();
        Node targetObj = link.getTarget();
        ActivityNode sourceUMLNode = (ActivityNode)graphUMLNodeMap.get(sourceObj);
        ActivityNode targetUMLNode = (ActivityNode)graphUMLNodeMap.get(targetObj);
        org.eclipse.gmf.runtime.notation.Node sourceNotationNode = this.findNotationNode(this.getDiagram(), sourceUMLNode);
        Edge edge = this.findEdge(sourceNotationNode, targetNotationNode = this.findNotationNode(this.getDiagram(), targetUMLNode));
        if (edge == null && targetNotationNode != null) {
            ControlFlow controlFlow = this.createControlFlow();
            if (targetUMLNode instanceof ActivityNode) {
                controlFlow.setSource(sourceUMLNode);
                controlFlow.setTarget(targetUMLNode);
            }
            edge = MapUtil.createEdge_AD(sourceNotationNode, targetNotationNode, (ActivityEdge)controlFlow);
            edge.setElement((EObject)controlFlow);
            this.loadSourceAndTargetEndPoint(edge, link);
            this.loadBendPoints(edge, link);
        }
        return edge;
    }

    private Diagram getDiagram() {
        return this.diagram;
    }

    public Activity getActivity() {
        return this.activity;
    }

    public void setDiagram(Diagram diagram) {
        this.diagram = diagram;
    }

    public void setActivity(Activity activity) {
        this.activity = activity;
    }
}

