/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.commands.ChangeBoundsCommand;
import org.eclipse.epf.diagram.core.commands.ReconnectLinkCommand;
import org.eclipse.epf.diagram.core.util.DiagramCoreUtil;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class DiagramActionsService {
    public static final String ALIGN_HORZ_AVERAGE = "align_horizontal_to_average";
    public static final String ALIGN_HORZ_FIRST_SELECTED = "align_horizontal_to_first_selection";
    public static final String ALIGN_VERT_AVERAGE = "align_vertical_to_average";
    public static final String ALIGN_VERT_FIRST_SELECTED = "align_vertical_to_first_selection";
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private InternalTransactionalEditingDomain transactionDomain;

    public DiagramActionsService(InternalTransactionalEditingDomain transactionDomain, GraphicalViewer graphicalViewer, DefaultEditDomain editDomain, ActionRegistry actionRegistry) {
        this.transactionDomain = transactionDomain;
        this.graphicalViewer = graphicalViewer;
        this.editDomain = editDomain;
        this.actionRegistry = actionRegistry;
    }

    public void setGraphicalViewer(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    private GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public IAction registerHorizontalAlignAverageAction() {
        Action hAlignAverageAction = new Action(DiagramCoreResources.AbstractDiagramEditor_hAlignAverageAction_text){

            public void run() {
                DiagramActionsService.this.horizAlignToAverageSelected();
            }

            public String getId() {
                return DiagramActionsService.ALIGN_HORZ_AVERAGE;
            }
        };
        this.getActionRegistry().registerAction((IAction)hAlignAverageAction);
        return hAlignAverageAction;
    }

    public IAction registerHorizontalAlignFirstSelectedAction() {
        Action hAlignFirstSelectedAction = new Action(DiagramCoreResources.AbstractDiagramEditor_hAlignFirstSelectedAction_text){

            public void run() {
                DiagramActionsService.this.horzAlignToFirstSelected();
            }

            public String getId() {
                return DiagramActionsService.ALIGN_HORZ_FIRST_SELECTED;
            }
        };
        this.getActionRegistry().registerAction((IAction)hAlignFirstSelectedAction);
        return hAlignFirstSelectedAction;
    }

    public IAction registerVerticalAlignAverageAction() {
        Action vAlignAverageAction = new Action(DiagramCoreResources.AbstractDiagramEditor_vAlignAverageAction_text){

            public void run() {
                DiagramActionsService.this.verticalAlignToAverageSelected();
            }

            public String getId() {
                return DiagramActionsService.ALIGN_VERT_AVERAGE;
            }
        };
        this.getActionRegistry().registerAction((IAction)vAlignAverageAction);
        return vAlignAverageAction;
    }

    public IAction registerVerticalAlignFirstSelectedAction() {
        Action vAlignFirstSelectedAction = new Action(DiagramCoreResources.AbstractDiagramEditor_vAlignFirstSelectedAction_text){

            public void run() {
                DiagramActionsService.this.verticalAlignToFirstSelected();
            }

            public String getId() {
                return DiagramActionsService.ALIGN_VERT_FIRST_SELECTED;
            }
        };
        this.getActionRegistry().registerAction((IAction)vAlignFirstSelectedAction);
        return vAlignFirstSelectedAction;
    }

    public void horzAlignToFirstSelected() {
        List editParts = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart firstPart = null;
        int a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof ShapeNodeEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (firstPart == null) {
                    firstPart = ep;
                } else {
                    Rectangle bounds = ep.getFigure().getBounds();
                    int offset = (int)((double)(bounds.height - firstPart.getFigure().getBounds().height) / 2.0);
                    if (!(ep.getParent() instanceof DiagramEditPart)) {
                        ep = (AbstractGraphicalEditPart)ep.getParent();
                        Rectangle parentBounds = ep.getFigure().getBounds();
                        offset += bounds.y - parentBounds.y;
                        bounds = parentBounds;
                    }
                    ChangeBoundsCommand c = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), new Point(bounds.x, firstPart.getFigure().getBounds().y - offset), bounds.width, -1);
                    this.getCommandStack().execute((Command)c);
                }
            }
            ++a;
        }
    }

    public void horizAlignToAverageSelected() {
        List editParts = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart firstPart = null;
        int total = 0;
        int ysum = 0;
        int a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof ShapeNodeEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (firstPart == null) {
                    firstPart = ep;
                }
                ysum += ep.getFigure().getBounds().y;
                ++total;
            }
            ++a;
        }
        int yave = (int)((double)ysum / (double)total);
        int a2 = 0;
        while (a2 < editParts.size()) {
            if (editParts.get(a2) instanceof ShapeNodeEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)editParts.get(a2);
                Rectangle bounds = ep.getFigure().getBounds();
                int offset = (int)((double)(bounds.height - firstPart.getFigure().getBounds().height) / 2.0);
                if (!(ep.getParent() instanceof DiagramEditPart)) {
                    ep = (AbstractGraphicalEditPart)ep.getParent();
                    Rectangle parentBounds = ep.getFigure().getBounds();
                    offset += bounds.y - parentBounds.y;
                    bounds = parentBounds;
                }
                ChangeBoundsCommand c = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), new Point(bounds.x, yave - offset), bounds.width, -1);
                this.getCommandStack().execute((Command)c);
            }
            ++a2;
        }
    }

    public void verticalAlignToAverageSelected() {
        List editParts = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart firstPart = null;
        int total = 0;
        int xsum = 0;
        int a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof ShapeNodeEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (firstPart == null) {
                    firstPart = ep;
                }
                xsum += ep.getFigure().getBounds().x;
                ++total;
            }
            ++a;
        }
        int xave = (int)((double)xsum / (double)total);
        int a2 = 0;
        while (a2 < editParts.size()) {
            if (editParts.get(a2) instanceof ShapeNodeEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)editParts.get(a2);
                Rectangle bounds = ep.getFigure().getBounds();
                int offset = (int)((double)(bounds.width - firstPart.getFigure().getBounds().width) / 2.0);
                if (!(ep.getParent() instanceof DiagramEditPart)) {
                    ep = (AbstractGraphicalEditPart)ep.getParent();
                    Rectangle parentBounds = ep.getFigure().getBounds();
                    offset += bounds.x - parentBounds.x;
                    bounds = parentBounds;
                }
                ChangeBoundsCommand c = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), new Point(xave - offset, bounds.y), bounds.width, -1);
                this.getCommandStack().execute((Command)c);
            }
            ++a2;
        }
    }

    public void verticalAlignToFirstSelected() {
        AbstractGraphicalEditPart ep;
        List editParts = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart alignToPart = null;
        int a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof ShapeNodeEditPart) {
                ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (alignToPart == null) {
                    alignToPart = ep;
                    break;
                }
            }
            ++a;
        }
        a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof ShapeNodeEditPart) {
                Command c;
                int delta;
                Point centerPoint;
                boolean connected;
                ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (ep != alignToPart && !DiagramCoreUtil.isSyncBar((EditPart)alignToPart)) {
                    if (!DiagramCoreUtil.isSyncBar((EditPart)ep)) {
                        Rectangle bounds = ep.getFigure().getBounds();
                        int offset = (int)((double)(bounds.width - alignToPart.getFigure().getBounds().width) / 2.0);
                        if (!(ep.getParent() instanceof DiagramEditPart)) {
                            ep = (AbstractGraphicalEditPart)ep.getParent();
                            Rectangle parentBounds = ep.getFigure().getBounds();
                            offset += bounds.x - parentBounds.x;
                            bounds = parentBounds;
                        }
                        ChangeBoundsCommand c2 = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), new Point(alignToPart.getFigure().getBounds().x - offset, bounds.y), bounds.width, -1);
                        this.getCommandStack().execute((Command)c2);
                        ep.getFigure().setLocation(new Point(alignToPart.getFigure().getBounds().x - offset, bounds.y));
                    } else {
                        Point tp = ep.getFigure().getBounds().getCenter();
                        connected = false;
                        boolean source = false;
                        Point endPoint = null;
                        ConnectionNodeEditPart lp2 = null;
                        List list = ((ShapeNodeEditPart)ep).getTargetConnections();
                        for (ConnectionNodeEditPart lp2 : list) {
                            if (!lp2.getSource().equals(alignToPart)) continue;
                            connected = true;
                            break;
                        }
                        if (!connected) {
                            list = ((ShapeNodeEditPart)ep).getSourceConnections();
                            for (ConnectionNodeEditPart lp2 : list) {
                                if (!lp2.getTarget().equals(alignToPart)) continue;
                                connected = true;
                                source = true;
                                break;
                            }
                        }
                        if (connected && alignToPart instanceof ShapeNodeEditPart) {
                            centerPoint = alignToPart.getFigure().getBounds().getCenter();
                            delta = centerPoint.x - tp.x;
                            endPoint.x += delta;
                            c = new ReconnectLinkCommand(this.transactionDomain, (Edge)lp2.getModel(), (Node)ep.getModel(), source);
                            c.setEndPoint(endPoint);
                            this.getCommandStack().execute(c);
                        }
                    }
                }
                if (ep != alignToPart && !DiagramCoreUtil.isSyncBar((EditPart)alignToPart)) {
                    Point tp;
                    Point p;
                    Point sp = alignToPart.getFigure().getBounds().getCenter();
                    connected = false;
                    List list = ((ShapeNodeEditPart)alignToPart).getSourceConnections();
                    for (ConnectionNodeEditPart lp2 : list) {
                        if (!lp2.getTarget().equals(ep)) continue;
                        connected = true;
                        break;
                    }
                    if (!connected) {
                        list = ((ShapeNodeEditPart)alignToPart).getTargetConnections();
                        for (ConnectionNodeEditPart lp2 : list) {
                            if (!lp2.getSource().equals(ep)) continue;
                            connected = true;
                            break;
                        }
                    }
                    if (DiagramCoreUtil.isSyncBar((EditPart)ep)) {
                        p = new Point();
                        p.x = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)ep.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                        p.y = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)ep.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                        tp = p.getCopy();
                        Point alignToCenter = alignToPart.getFigure().getBounds().getCenter();
                        centerPoint = ep.getFigure().getBounds().getCenter();
                        delta = alignToCenter.x - centerPoint.x;
                        tp.x += delta;
                        c = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), tp, ep.getFigure().getBounds().width, -1);
                        this.getCommandStack().execute(c);
                        ep.getFigure().setLocation(new Point(tp.x, tp.y));
                    } else if (ep instanceof ShapeNodeEditPart) {
                        p = new Point();
                        p.x = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)ep.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                        p.y = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)ep.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                        tp = p.getCopy();
                        Point centerPoint2 = ep.getFigure().getBounds().getCenter();
                        int delta2 = sp.x - centerPoint2.x;
                        tp.x += delta2;
                        ChangeBoundsCommand c3 = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)ep.getModel()), tp, ep.getFigure().getBounds().width, -1);
                        this.getCommandStack().execute((Command)c3);
                        ep.getFigure().setLocation(new Point(tp.x, tp.y));
                    }
                }
            }
            ++a;
        }
    }

    public void createAlignMenu(IMenuManager menu, boolean canModify) {
        IContributionItem formatMenu = menu.find("formatMenu");
        MenuManager alignMenuManager = null;
        if (alignMenuManager == null) {
            alignMenuManager = new MenuManager(DiagramCoreResources.AbstractDiagramEditor_alignMenu_text){

                public boolean isEnabled() {
                    int total = 0;
                    List editParts = DiagramActionsService.this.graphicalViewer.getSelectedEditParts();
                    if (editParts.size() > 1) {
                        int a = 0;
                        while (a < editParts.size()) {
                            EditPart editPart = (EditPart)editParts.get(a);
                            if (editPart instanceof ShapeNodeEditPart && ++total > 1) break;
                            ++a;
                        }
                    }
                    return total > 1;
                }
            };
        }
        if (formatMenu != null && formatMenu instanceof IMenuManager && alignMenuManager.isEnabled() && canModify) {
            IContributionItem item = ((IMenuManager)formatMenu).find("alignMenu");
            if (item != null && item instanceof IMenuManager) {
                IMenuManager alignMenu = (IMenuManager)item;
                alignMenu.add(this.getActionRegistry().getAction((Object)ALIGN_HORZ_AVERAGE));
                alignMenu.add(this.getActionRegistry().getAction((Object)ALIGN_HORZ_FIRST_SELECTED));
                alignMenu.add(this.getActionRegistry().getAction((Object)ALIGN_VERT_AVERAGE));
                alignMenu.add(this.getActionRegistry().getAction((Object)ALIGN_VERT_FIRST_SELECTED));
            }
        } else {
            alignMenuManager.add(this.getActionRegistry().getAction((Object)ALIGN_HORZ_AVERAGE));
            alignMenuManager.add(this.getActionRegistry().getAction((Object)ALIGN_HORZ_FIRST_SELECTED));
            alignMenuManager.add(this.getActionRegistry().getAction((Object)ALIGN_VERT_AVERAGE));
            alignMenuManager.add(this.getActionRegistry().getAction((Object)ALIGN_VERT_FIRST_SELECTED));
            if (alignMenuManager.isEnabled() && canModify) {
                menu.appendToGroup("additions", (IContributionItem)new Separator());
                menu.appendToGroup("additions", (IContributionItem)alignMenuManager);
                menu.appendToGroup("additions", (IContributionItem)new Separator());
            }
        }
    }
}

