/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class NodeAdapter
extends AdapterImpl {
    protected MethodElement element;
    protected boolean notificationEnabled = true;
    private Collection consumers = new ArrayList();
    protected MethodElementAdapter methodElementAdapter;
    private boolean targetReadOnly;
    protected BreakdownElementWrapperItemProvider wrapper;
    protected InternalTransactionalEditingDomain domain;
    private View view;
    protected IActionManager actionManager;

    protected NodeAdapter() {
    }

    public IActionManager getActionManager() {
        if (this.actionManager != null) {
            return this.actionManager;
        }
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)this.getNode().getActivity());
        return nodeAdapter.getActionManager();
    }

    public NodeAdapter(BreakdownElementWrapperItemProvider wrapper) {
        this((MethodElement)TngUtil.unwrap((Object)wrapper));
        this.wrapper = wrapper;
        this.targetReadOnly = wrapper.isReadOnly();
    }

    public NodeAdapter(MethodElement e) {
        this.element = e;
        this.methodElementAdapter = this.createMethodElementAdapter();
        e.eAdapters().add((Object)this.methodElementAdapter);
    }

    public View getView() {
        if (this.view != null) {
            return this.view;
        }
        View diagramView = this.getDiagramView();
        if (diagramView != null) {
            return BridgeHelper.getView(diagramView, this.getNode());
        }
        return null;
    }

    private View getDiagramView() {
        NodeAdapter adapter;
        Activity diagram = this.getDiagram();
        if (diagram != null && (adapter = BridgeHelper.getNodeAdapter((EObject)diagram)) != null) {
            return adapter.getView();
        }
        return null;
    }

    public void setView(View view) {
        this.view = view;
    }

    public void setEditingDomain(InternalTransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public boolean isTargetReadOnly() {
        NodeAdapter diagramAdapter;
        if (this.targetReadOnly) {
            return this.targetReadOnly;
        }
        Activity activity = this.getDiagram();
        return activity != this.target && (diagramAdapter = BridgeHelper.getNodeAdapter((EObject)activity)) != null && diagramAdapter.isTargetReadOnly();
    }

    protected void basicSetTargetReadOnly(boolean b) {
        this.targetReadOnly = b;
    }

    protected void setTargetReadOnly(boolean targetReadOnly) {
        boolean updateView = this.targetReadOnly ^ targetReadOnly;
        this.targetReadOnly = targetReadOnly;
        if (updateView) {
            this.updateView();
        }
    }

    protected void updateView() {
        FontStyle style;
        View node = this.getView();
        if (node != null && (style = (FontStyle)node.getStyle(NotationPackage.Literals.FONT_STYLE)) == null) {
            node.createStyle(NotationPackage.Literals.FONT_STYLE);
        }
    }

    protected MethodElementAdapter createMethodElementAdapter() {
        return new MethodElementAdapter();
    }

    protected ActivityNode getNode() {
        if (this.target instanceof ActivityNode) {
            return (ActivityNode)this.target;
        }
        return null;
    }

    protected Activity getDiagram() {
        if (this.target instanceof Activity) {
            return (Activity)this.target;
        }
        ActivityNode node = this.getNode();
        return node != null ? node.getActivity() : null;
    }

    protected ActivityEdge addIncomingConnection(MethodElement source) {
        ActivityNode srcNode = BridgeHelper.findNode(this.getDiagram(), source, true);
        if (srcNode == null) {
            return null;
        }
        NodeAdapter srcNodeAdapter = BridgeHelper.getNodeAdapter((EObject)srcNode);
        boolean notify = srcNodeAdapter != null ? srcNodeAdapter.notificationEnabled : false;
        try {
            if (srcNodeAdapter != null) {
                srcNodeAdapter.notificationEnabled = false;
            }
            ControlFlow edge = UMLFactory.eINSTANCE.createControlFlow();
            edge.setSource(srcNode);
            edge.setTarget(this.getNode());
            this.getDiagram().getEdges().add((Object)edge);
            ControlFlow controlFlow = edge;
            return controlFlow;
        }
        finally {
            if (srcNodeAdapter != null) {
                srcNodeAdapter.notificationEnabled = notify;
            }
        }
    }

    protected ActivityEdge addOutgoingConnection(MethodElement target) {
        ActivityNode targetNode = BridgeHelper.findNode(this.getDiagram(), target);
        if (targetNode == null) {
            return null;
        }
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)targetNode);
        boolean notify = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
        try {
            if (nodeAdapter != null) {
                nodeAdapter.notificationEnabled = false;
            }
            ActivityEdge edge = this.getDiagram().createEdge("", UMLPackage.Literals.CONTROL_FLOW);
            edge.setSource(this.getNode());
            edge.setTarget(targetNode);
            ActivityEdge activityEdge = edge;
            return activityEdge;
        }
        finally {
            if (nodeAdapter != null) {
                nodeAdapter.notificationEnabled = notify;
            }
        }
    }

    public void addConsumer(Object consumer) {
        if (!this.consumers.contains(consumer)) {
            this.consumers.add(consumer);
        }
    }

    public void removeConsumer(Object consumer) {
        this.consumers.remove(consumer);
        if (this.consumers.isEmpty()) {
            this.dispose();
        }
    }

    public void dispose() {
        this.domain = null;
        MethodElement obj = this.element;
        if (obj != null && this.methodElementAdapter != null) {
            obj.eAdapters().remove((Object)this.methodElementAdapter);
        }
        if (this.target != null) {
            this.target.eAdapters().remove((Object)this);
        }
        this.element = null;
    }

    public void setName(String newStringValue) {
        ActivityNode e = this.getNode();
        if (e != null) {
            e.setName(newStringValue);
        }
    }

    protected void handleNotification(Notification msg) {
        block25: {
            block0 : switch (msg.getFeatureID(ActivityNode.class)) {
                case 4: {
                    if (msg.getEventType() == 1 && this.getElement() instanceof BreakdownElement) {
                        String newName = msg.getNewStringValue();
                        BreakdownElement e = (BreakdownElement)this.getElement();
                        e.setPresentationName(newName);
                        if (StrUtil.isBlank((String)e.getName())) {
                            e.setName(newName);
                        }
                    }
                    return;
                }
                case 16: {
                    switch (msg.getEventType()) {
                        case 3: {
                            ActivityEdge link = (ActivityEdge)msg.getNewValue();
                            this.addToUMA(link);
                            return;
                        }
                        case 5: {
                            Iterator iter = ((Collection)msg.getNewValue()).iterator();
                            while (iter.hasNext()) {
                                this.addToUMA((ActivityEdge)iter.next());
                            }
                            break;
                        }
                        case 4: {
                            NodeAdapter nodeAdapter;
                            ActivityEdge link = (ActivityEdge)msg.getOldValue();
                            if (link.getSource() == null || (nodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getSource())) == null) break;
                            nodeAdapter.removeFromUMA(link, link.getSource(), (ActivityNode)msg.getNotifier());
                            break;
                        }
                        case 6: {
                            for (ActivityEdge link : (Collection)msg.getOldValue()) {
                                NodeAdapter nodeAdapter;
                                if (link.getSource() == null || (nodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getSource())) == null) continue;
                                nodeAdapter.removeFromUMA(link, link.getSource(), (ActivityNode)msg.getNotifier());
                            }
                            break;
                        }
                    }
                    return;
                }
                case 15: {
                    switch (msg.getEventType()) {
                        case 3: {
                            NodeAdapter nodeAdapter;
                            ActivityEdge link = (ActivityEdge)msg.getNewValue();
                            if (link.getTarget() != null && (nodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getTarget())) != null) {
                                nodeAdapter.addToUMA(link);
                                break block0;
                            }
                            break block25;
                        }
                        case 5: {
                            for (ActivityEdge link : (Collection)msg.getNewValue()) {
                                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)link.getTarget());
                                if (nodeAdapter == null) continue;
                                nodeAdapter.addToUMA(link);
                            }
                            break block25;
                        }
                        case 4: {
                            ActivityEdge link = (ActivityEdge)msg.getOldValue();
                            if (link.getTarget() != null) {
                                this.removeFromUMA(link, (ActivityNode)msg.getNotifier(), link.getTarget());
                                break block0;
                            }
                            break block25;
                        }
                        case 6: {
                            for (ActivityEdge link : (Collection)msg.getOldValue()) {
                                if (link.getTarget() == null) continue;
                                this.removeFromUMA(link, (ActivityNode)msg.getNotifier(), link.getTarget());
                            }
                        }
                    }
                }
            }
        }
    }

    public void notifyChanged(Notification msg) {
        if (!this.notificationEnabled) {
            return;
        }
        this.notificationEnabled = false;
        try {
            this.handleNotification(msg);
        }
        finally {
            this.notificationEnabled = true;
        }
    }

    protected void addToUmaModel(int position, ActivityNode node) {
    }

    protected void nodeAdded(int index, ActivityNode node) {
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
        if (nodeAdapter == null) {
            nodeAdapter = this.addNodeAdapterTo(node);
        }
        this.addToUmaModel(index, node);
        if (nodeAdapter != null) {
            nodeAdapter.addConsumer((Object)this);
        }
    }

    protected NodeAdapter addNodeAdapterTo(ActivityNode node) {
        return null;
    }

    protected void removeFromUmaModel(ActivityNode node) {
    }

    protected void nodeRemoved(ActivityNode node) {
        this.removeFromUmaModel(node);
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
        if (nodeAdapter != null) {
            nodeAdapter.removeConsumer((Object)this);
        }
    }

    protected boolean addToUMA(ActivityEdge link) {
        return link.getTarget() != null && link.getSource() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeFromUMA(ActivityEdge link, ActivityNode oldSource, ActivityNode oldTarget) {
        MethodElement targetElement = BridgeHelper.getMethodElement((EModelElement)oldTarget);
        if (targetElement instanceof WorkBreakdownElement) {
            NodeAdapter targetNodeAdapter = BridgeHelper.getNodeAdapter((EObject)oldTarget);
            boolean notify = targetNodeAdapter != null ? targetNodeAdapter.notificationEnabled : false;
            try {
                WorkBreakdownElement e;
                Collection workOrders;
                MethodElement pred;
                if (targetNodeAdapter != null) {
                    targetNodeAdapter.notificationEnabled = false;
                }
                if (!BridgeHelper.canRemoveAllPreds(link, oldSource, oldTarget) || !((pred = BridgeHelper.getMethodElement((EModelElement)oldSource)) instanceof WorkBreakdownElement) || (workOrders = UmaUtil.findWorkOrder((WorkBreakdownElement)(e = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)oldTarget)), (WorkBreakdownElement)((WorkBreakdownElement)pred), (boolean)true)).isEmpty()) return;
                this.getActionManager().doAction(6, (EObject)e, (EStructuralFeature)UmaPackage.Literals.WORK_BREAKDOWN_ELEMENT__LINK_TO_PREDECESSOR, (Object)workOrders, -1);
                return;
            }
            finally {
                if (targetNodeAdapter != null) {
                    targetNodeAdapter.notificationEnabled = notify;
                }
            }
        } else {
            if (!(oldTarget instanceof ControlNode) || !BridgeHelper.isSynchBar(oldTarget)) return;
            ArrayList<ActivityNode> actNodes = new ArrayList<ActivityNode>();
            BridgeHelper.getSuccessorNodes(actNodes, oldTarget);
            for (ActivityNode node : actNodes) {
                WorkBreakdownElement e = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)node);
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
                boolean notify = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
                try {
                    WorkOrder wo;
                    if (nodeAdapter != null) {
                        nodeAdapter.notificationEnabled = false;
                    }
                    if (!BridgeHelper.canRemoveAllPreds(link, oldSource, node)) continue;
                    while ((wo = UmaUtil.findWorkOrder((WorkBreakdownElement)e, (Object)BridgeHelper.getMethodElement((EModelElement)oldSource))) != null) {
                        this.getActionManager().doAction(4, (EObject)e, (EStructuralFeature)UmaPackage.Literals.WORK_BREAKDOWN_ELEMENT__LINK_TO_PREDECESSOR, (Object)wo, -1);
                    }
                }
                finally {
                    if (nodeAdapter != null) {
                        nodeAdapter.notificationEnabled = notify;
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkOrder addDefaultWorkOrder(ActivityNode node, WorkBreakdownElement predBreakdownElement) {
        nodeAdapter = BridgeHelper.getNodeAdapter((EObject)node);
        notify = nodeAdapter.notificationEnabled;
        map = new HashMap<NodeAdapter, Boolean>();
        e = nodeAdapter.getElement();
        list = e.eAdapters();
        for (E obj : list) {
            if (!(obj instanceof MethodElementAdapter)) continue;
            otherNodeAdapter = ((MethodElementAdapter)obj).getNodeAdapter();
            predNotification = nodeAdapter.notificationEnabled;
            otherNodeAdapter.notificationEnabled = false;
            map.put(otherNodeAdapter, new Boolean(predNotification));
        }
        try {
            nodeAdapter.notificationEnabled = false;
            wo = UmaUtil.createDefaultWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)e), (WorkBreakdownElement)predBreakdownElement, (boolean)false);
            this.getActionManager().doAction(3, (EObject)e, (EStructuralFeature)UmaPackage.Literals.WORK_BREAKDOWN_ELEMENT__LINK_TO_PREDECESSOR, (Object)wo, -1);
            var10_11 = wo;
            return var10_11;
        }
        finally {
            nodeAdapter.setNotificationEnabled(notify);
            set = map.keySet();
            ** for (object : set)
        }
lbl-1000:
        // 1 sources

        {
            obj = map.get(object);
            if (!(obj instanceof Boolean)) continue;
            ((NodeAdapter)object).notificationEnabled = prednot = ((Boolean)obj).booleanValue();
            continue;
        }
lbl29:
        // 1 sources

        return var10_11;
    }

    public void setNotificationEnabled(boolean notify) {
        this.notificationEnabled = notify;
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public MethodElement getElement() {
        return this.element;
    }

    public void setTarget(Notifier newTarget) {
        if (newTarget == null) {
            this.dispose();
        }
        super.setTarget(newTarget);
    }

    public BreakdownElementWrapperItemProvider getWrapper() {
        return this.wrapper;
    }

    protected class MethodElementAdapter
    extends AdapterImpl {
        protected MethodElementAdapter() {
        }

        protected Collection handleNotification(Notification msg) {
            switch (msg.getFeatureID(DescribableElement.class)) {
                case 2: {
                    NodeAdapter.this.setName(msg.getNewStringValue());
                    break;
                }
                case 11: 
                case 12: {
                    ActivityNode e = NodeAdapter.this.getNode();
                    e.eNotify((Notification)new ENotificationImpl((InternalEObject)e, 1, 4, (Object)e.getName(), (Object)e.getName(), true));
                    e.eNotify(msg);
                }
            }
            return Collections.EMPTY_LIST;
        }

        public void notifyChanged(final Notification msg) {
            if (NodeAdapter.this.domain == null || NodeAdapter.this.domain.getChangeRecorder() == null) {
                return;
            }
            if (!NodeAdapter.this.notificationEnabled) {
                return;
            }
            NodeAdapter.this.notificationEnabled = false;
            try {
                try {
                    final ArrayList newNodesToRefresh = new ArrayList();
                    TxUtil.runInTransaction((TransactionalEditingDomain)NodeAdapter.this.domain, (Runnable)new Runnable(){

                        public void run() {
                            newNodesToRefresh.addAll(MethodElementAdapter.this.handleNotification(msg));
                        }
                    });
                    if (!newNodesToRefresh.isEmpty()) {
                        TxUtil.runInTransaction((TransactionalEditingDomain)NodeAdapter.this.domain, (Runnable)new Runnable(){

                            public void run() {
                                for (ActivityNode node : newNodesToRefresh) {
                                    BridgeHelper.getNodeAdapter((EObject)node).updateView();
                                }
                            }
                        });
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    NodeAdapter.this.notificationEnabled = true;
                }
            }
            finally {
                NodeAdapter.this.notificationEnabled = true;
            }
        }

        public NodeAdapter getNodeAdapter() {
            return NodeAdapter.this;
        }
    }
}

