/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.commands;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.DiagramService;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.uma.Activity;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeleteDiagramNodeCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private Activity activity;
    private Collection<?> breakdownElements;
    private DiagramService diagramSvc;

    public DeleteDiagramNodeCommand(Activity activity, Collection<?> breakdownElements) {
        this.activity = activity;
        this.breakdownElements = breakdownElements;
    }

    public Collection<Resource> getModifiedResources() {
        DiagramManager mgr;
        if (this.diagramSvc != null && (mgr = this.diagramSvc.getDiagramManager(this.activity)) != null) {
            try {
                Resource resource = mgr.getResource();
                if (resource != null) {
                    return Collections.singleton(resource);
                }
            }
            catch (CoreException e) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public void execute() {
        Collection<Diagram> diagrams = this.diagramSvc.getDiagrams(this.activity);
        ArrayList<View> viewsToDelete = new ArrayList<View>();
        for (Diagram diagram : diagrams) {
            AbstractTreeIterator<View> iterator = new AbstractTreeIterator<View>((Object)diagram, false){
                private static final long serialVersionUID = 1L;

                protected Iterator<? extends View> getChildren(Object object) {
                    if (object instanceof View) {
                        return ((View)object).getChildren().iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
            };
            while (iterator.hasNext()) {
                View view = (View)iterator.next();
                if (!this.breakdownElements.contains(BridgeHelper.getMethodElement(view, this.activity))) continue;
                viewsToDelete.add(view);
            }
        }
        if (!viewsToDelete.isEmpty()) {
            for (View view : viewsToDelete) {
                final EObject umlElement = view.getElement();
                ViewUtil.destroy((View)view);
                if (umlElement == null || umlElement.eContainer() == null) continue;
                try {
                    TxUtil.runInTransaction((EObject)umlElement, (Runnable)new Runnable(){

                        public void run() {
                            EcoreUtil.delete((EObject)umlElement);
                        }
                    });
                }
                catch (ExecutionException e) {
                    DiagramCorePlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        }
    }

    public void redo() {
        this.execute();
    }

    public boolean canUndo() {
        return false;
    }

    protected boolean prepare() {
        this.diagramSvc = new DiagramService();
        Collection<Diagram> diagrams = this.diagramSvc.getDiagrams(this.activity);
        return !diagrams.isEmpty();
    }

    public void dispose() {
        this.activity = null;
        this.breakdownElements = null;
        this.diagramSvc.dispose();
    }
}

