/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.util;

import com.ibm.icu.text.BreakIterator;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.diagram.core.bridge.ActivityDiagramAdapter;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.figures.WidenedWrapLabel;
import org.eclipse.epf.diagram.core.part.DiagramEditorInput;
import org.eclipse.epf.diagram.core.part.IDiagramEditorInputProvider;
import org.eclipse.epf.diagram.core.util.DiagramConstants;
import org.eclipse.epf.diagram.core.util.DiagramCoreValidation;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.AbstractEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrapLabel;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeTypes;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.uml2.uml.ActivityNode;

public final class DiagramCoreUtil {
    public static void setLabelProperties(WrapLabel labelFigure) {
        labelFigure.setFont(DiagramConstants.DEFAULT_FONT);
        labelFigure.setIconAlignment(8);
        labelFigure.setLabelAlignment(8);
        labelFigure.setTextAlignment(8);
        labelFigure.setTextPlacement(4);
        labelFigure.setTextWrap(true);
        labelFigure.setTextWrapAlignment(2);
    }

    public static void setDefaultFontPreference(IPreferenceStore store) {
        FontData[] fontDataArray = JFaceResources.getDefaultFont().getFontData();
        FontData fontData = fontDataArray[0];
        fontData.setHeight(8);
        fontData.setName(DiagramConstants.DEFAULT_FONT_NAME);
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"Appearance.defaultFont", (FontData)fontData);
    }

    public static String validStringForBreakdownElements(EditPart part, String txt) {
        Object obj = part.getModel();
        if (obj instanceof Node) {
            Node node = (Node)obj;
            EObject umlE = node.getElement();
            MethodElement e = BridgeHelper.getMethodElement((EModelElement)umlE);
            EObject umlA = node.getDiagram().getElement();
            ActivityDiagramAdapter adapter = (ActivityDiagramAdapter)BridgeHelper.getNodeAdapter(umlA);
            if (adapter != null) {
                if (e instanceof Activity) {
                    return TngUtil.checkWBSActivityPresentationName((Object)e, (String)txt, (Suppression)adapter.getSuppression());
                }
                return TngUtil.checkWorkBreakdownElementPresentationName((Object)e, (String)txt, (Suppression)adapter.getSuppression());
            }
        }
        return null;
    }

    public static Color getFontColor(AbstractEditPart editPart) {
        DiagramEditorInput input;
        if (LibraryUtil.PUBLISH_MODE) {
            return null;
        }
        EditPartViewer viewer = editPart.getViewer();
        if (viewer instanceof IDiagramEditorInputProvider && (input = ((IDiagramEditorInputProvider)viewer).getDiagramEditorInput()) != null && input.getWrapper() != null) {
            return DiagramConstants.READ_ONLY_FONT_COLOR;
        }
        Object model = editPart.getModel();
        if (model instanceof View) {
            return DiagramCoreUtil.getFontColor((View)model);
        }
        return null;
    }

    private static Color getFontColor(View view) {
        if (BridgeHelper.isReadOnly(view)) {
            return DiagramConstants.READ_ONLY_FONT_COLOR;
        }
        return null;
    }

    public static DiagramEditPart getDiagramEditPart(EditPart editPart) {
        while (editPart != null && !(editPart instanceof DiagramEditPart)) {
            editPart = editPart.getParent();
        }
        return (DiagramEditPart)editPart;
    }

    public static boolean isReadOnly(AbstractEditPart editPart) {
        Object model = editPart.getModel();
        if (model instanceof View) {
            return BridgeHelper.isReadOnly((View)model);
        }
        return false;
    }

    public static boolean isSyncBar(EditPart part) {
        View node;
        EObject obj;
        if (part instanceof IGraphicalEditPart && (obj = (node = (View)part.getModel()).getElement()) instanceof ActivityNode) {
            return BridgeHelper.isSynchBar((ActivityNode)obj);
        }
        return false;
    }

    public static String wrap(String s, int wrapWidth) {
        String wrapped = "";
        BreakIterator bi = BreakIterator.getLineInstance();
        String remaining = s;
        while (true) {
            if (remaining.length() <= wrapWidth) {
                wrapped = String.valueOf(wrapped) + remaining;
                break;
            }
            bi.setText(remaining);
            int pos = bi.following(wrapWidth);
            if (pos == -1) {
                wrapped = String.valueOf(wrapped) + remaining;
                break;
            }
            if (pos >= remaining.length()) {
                wrapped = String.valueOf(wrapped) + remaining;
                break;
            }
            wrapped = String.valueOf(wrapped) + remaining.substring(0, pos) + "\n";
            remaining = remaining.substring(pos);
        }
        return wrapped;
    }

    public static void setDefaultLineStyle(IPreferenceStore store) {
        PreferenceConverter.setDefault((IPreferenceStore)store, (String)"Appearance.lineColor", (RGB)PreferenceConverter.COLOR_DEFAULT_DEFAULT);
    }

    public static void hideConnectionHandles(IPreferenceStore store) {
        store.setDefault("Global.showConnectionHandles", false);
    }

    public static int getTextHeight(String text, FontStyle fontStyle, int width) {
        Dimension d;
        Font font = null;
        String fontName = null;
        int fontHeight = 0;
        if (fontStyle != null) {
            fontName = fontStyle.getFontName();
            fontHeight = fontStyle.getFontHeight();
            if (fontName == null) {
                fontName = DiagramConstants.getFontName();
            }
            if (fontHeight == 0) {
                fontHeight = 8;
            }
            font = new Font(null, fontName, fontHeight, 0);
        } else {
            font = DiagramConstants.DEFAULT_FONT;
        }
        try {
            d = FigureUtilities.getTextExtents((String)text, (Font)font);
        }
        finally {
            if (font != null && font != DiagramConstants.DEFAULT_FONT) {
                font.dispose();
            }
        }
        int noOfLines = 0;
        if (d != null && d.width > 0) {
            int div = d.width / width;
            int mod = d.width % width;
            if (mod != 0) {
                ++div;
            }
            noOfLines = div;
            return noOfLines * fontHeight;
        }
        return 0;
    }

    public static Dimension getTextSizeInWrapLabel(String text, Font f, int wHint, int hHint, IMapMode mapMode) {
        class MyWrapLabel
        extends WidenedWrapLabel
        implements IMapMode {
            private IMapMode mapMode;

            public MyWrapLabel(IMapMode mapMode) {
                this.mapMode = mapMode != null ? mapMode : MapModeTypes.IDENTITY_MM;
            }

            public int DPtoLP(int deviceUnit) {
                return this.mapMode.DPtoLP(deviceUnit);
            }

            public Translatable DPtoLP(Translatable t) {
                return this.mapMode.DPtoLP(t);
            }

            public int LPtoDP(int logicalUnit) {
                return this.mapMode.LPtoDP(logicalUnit);
            }

            public Translatable LPtoDP(Translatable t) {
                return this.mapMode.LPtoDP(t);
            }
        }
        MyWrapLabel label = new MyWrapLabel(mapMode);
        DiagramCoreUtil.setLabelProperties(label);
        label.setText(text);
        if (f != null) {
            label.setFont(f);
        }
        return label.getTextSize(wHint, hHint);
    }

    public static Color getLinkOverrideColor(Edge edge) {
        return !LibraryUtil.PUBLISH_MODE && DiagramCoreValidation.isReadOnly(edge) ? DiagramConstants.READ_ONLY_FONT_COLOR : null;
    }
}

