/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.xmi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epf.library.ui.wizards.OpenLibraryWizardPage;
import org.eclipse.epf.library.ui.xmi.XMILibraryUIResources;
import org.eclipse.epf.library.xmi.preferences.XMILibraryPreferences;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class OpenXMILibraryWizardPage
extends OpenLibraryWizardPage {
    private Combo locationCombo;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            OpenXMILibraryWizardPage.this.setPageComplete(OpenXMILibraryWizardPage.this.isPageComplete());
            OpenXMILibraryWizardPage.this.getWizard().getContainer().updateButtons();
        }
    };

    public OpenXMILibraryWizardPage(String pageId) {
        super(pageId);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        OpenXMILibraryWizardPage.createLabel((Composite)composite, (String)XMILibraryUIResources.locationLabel_text);
        this.locationCombo = OpenXMILibraryWizardPage.createCombobox((Composite)composite);
        this.locationCombo.addModifyListener(this.modifyListener);
        this.locationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                OpenXMILibraryWizardPage.this.setPageComplete(OpenXMILibraryWizardPage.this.isPageComplete());
                OpenXMILibraryWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        final Shell shell = parent.getShell();
        Button browseButton = OpenXMILibraryWizardPage.createButton((Composite)composite, (String)XMILibraryUIResources.browseButton_text);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    DirectoryDialog dialog = new DirectoryDialog(shell, 0);
                    dialog.setFilterPath(OpenXMILibraryWizardPage.this.getLibraryPath());
                    String selectedDir = dialog.open();
                    if (selectedDir != null) {
                        OpenXMILibraryWizardPage.this.locationCombo.add(selectedDir, 0);
                        OpenXMILibraryWizardPage.this.locationCombo.setText(selectedDir);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.setPageComplete(true);
        this.setControl((Control)composite);
    }

    public void onEnterPage(Object obj) {
        if (this.getLibraryPath().length() == 0) {
            this.locationCombo.removeModifyListener(this.modifyListener);
            this.locationCombo.setText(XMILibraryPreferences.getDefaultLibraryPath());
            this.locationCombo.addModifyListener(this.modifyListener);
        }
    }

    public boolean isPageComplete() {
        return this.getLibraryPath().length() > 0;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public String getLibraryPath() {
        return this.locationCombo.getText().trim();
    }

    public Map getSelections() {
        HashMap<String, String> options = new HashMap<String, String>();
        File libraryPath = new File(this.getLibraryPath());
        options.put("library.path", libraryPath.getAbsolutePath());
        return options;
    }
}

