/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.util;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ILock;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.transaction.internal.EMFTransactionDebugOptions;
import org.eclipse.emf.transaction.internal.EMFTransactionPlugin;
import org.eclipse.emf.transaction.internal.Tracing;
import org.eclipse.emf.transaction.internal.l10n.Messages;
import org.eclipse.emf.transaction.util.Queue;

public class Lock {
    private static final IJobManager jobmgr;
    private static long nextId;
    static final IStatus UI_REENTERED_STATUS;
    private final long id;
    private volatile Thread owner = null;
    private int depth = 0;
    private final Queue waiting = new Queue();
    private final Map yielders = new IdentityHashMap();
    private ThreadLocal threadLock = new ThreadLocal(){

        protected Object initialValue() {
            return Platform.getJobManager().newLock();
        }
    };
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        jobmgr = Platform.getJobManager();
        nextId = 0L;
        UI_REENTERED_STATUS = new Status(1, EMFTransactionPlugin.getPluginId(), 1, "UI thread re-entered to get the lock", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            this.id = ++nextId;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Thread getOwner() {
        return this.owner;
    }

    public int getDepth() {
        if (Thread.currentThread() != this.owner) {
            return 0;
        }
        return this.depth;
    }

    public void acquire(boolean exclusive) throws InterruptedException {
        this.acquire(0L, exclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(long timeout, boolean exclusive) throws InterruptedException {
        if (timeout < 0L) {
            IllegalArgumentException exc = new IllegalArgumentException("negative timeout");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "acquire", exc);
            throw exc;
        }
        if (Thread.interrupted()) {
            InterruptedException exc = new InterruptedException();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "acquire", exc);
            throw exc;
        }
        Thread current = Thread.currentThread();
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
            if (timeout > 0L) {
                Tracing.trace("::: Timed Acquire    [id=" + this.id + ", thread=" + current.getName() + ", exclusive=" + exclusive + ", timeout=" + timeout + ']' + " at " + Tracing.now());
            } else {
                Tracing.trace("::: Acquire          [id=" + this.id + ", thread=" + current.getName() + ", exclusive=" + exclusive + ']' + " at " + Tracing.now());
            }
        }
        boolean result = false;
        Queue.Wait node = null;
        Lock lock = this;
        synchronized (lock) {
            if (!exclusive || this.notYielded()) {
                if (current == this.owner) {
                    ++this.depth;
                    result = true;
                } else if (this.owner == null) {
                    this.depth = 1;
                    this.owner = current;
                    result = true;
                    this.getThreadLock().acquire();
                } else {
                    node = this.waiting.put(timeout, exclusive);
                }
            } else {
                if (this.owner == current) {
                    throw new InterruptedException(Messages.upgradeReadLock);
                }
                node = this.waiting.put(timeout, exclusive);
            }
        }
        if (node != null) {
            node.waitFor(timeout);
            lock = this;
            synchronized (lock) {
                if (node.wasNotified()) {
                    this.depth = 1;
                    this.owner = current;
                    result = true;
                }
            }
        }
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
            if (result) {
                Tracing.trace("::: Taken            [id=" + this.id + ", thread=" + current.getName() + ", depth=" + this.depth + ']' + " at " + Tracing.now());
            } else {
                Tracing.trace("::: Timed Out        [id=" + this.id + ", thread=" + current.getName() + ']' + " at " + Tracing.now());
            }
        }
        if (result) {
            this.resume();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public void uiSafeAcquire(boolean exclusive) throws InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 9[TRYBLOCK] [11 : 957->960)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean uninterruptibleAcquire(long timeout, boolean exclusive) {
        if (timeout <= 0L) {
            IllegalArgumentException exc = new IllegalArgumentException("nonpositive timeout");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "uninterruptibleAcquire", exc);
            throw exc;
        }
        long start = System.currentTimeMillis();
        boolean result = false;
        while (timeout > 0L) {
            try {
                result = this.acquire(timeout, exclusive);
                break;
            }
            catch (InterruptedException interruptedException) {
                Thread.interrupted();
                long when = System.currentTimeMillis();
                timeout -= when - start;
                start = when;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uninterruptibleWait(Object o) {
        Object object = o;
        synchronized (object) {
            while (true) {
                try {
                    o.wait();
                }
                catch (InterruptedException interruptedException) {
                    Thread.interrupted();
                    continue;
                }
                break;
            }
        }
    }

    public synchronized void release() {
        block8: {
            if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
                Tracing.trace("::: Release          [id=" + this.id + ", thread=" + Thread.currentThread().getName() + ", depth=" + (this.depth - 1) + ']' + " at " + Tracing.now());
            }
            if (Thread.currentThread() != this.owner) {
                IllegalArgumentException exc = new IllegalArgumentException("Lock not owned by current thread");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Tracing.throwing(clazz, "release", exc);
                throw exc;
            }
            --this.depth;
            if (this.depth == 0) {
                Queue.Wait node;
                this.getThreadLock().release();
                boolean allowExclusive = this.notYielded();
                do {
                    if ((node = this.waiting.take(allowExclusive)) != null) continue;
                    this.owner = null;
                    break block8;
                } while (!node.wakeUp());
                this.owner = node.getThread();
            }
        }
    }

    private boolean notYielded() {
        return this.yielders.isEmpty();
    }

    public synchronized boolean yield() {
        boolean result;
        boolean bl = result = this.waiting.size() > this.waiting.exclusiveCount();
        if (result) {
            this.yielders.put(Thread.currentThread(), this);
        }
        if (result && Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
            Tracing.trace("::: Yielding         [id=" + this.id + ", thread=" + Thread.currentThread().getName() + ']' + " at " + Tracing.now());
        }
        return result;
    }

    private void resume() {
        boolean removed;
        boolean bl = removed = this.yielders.remove(Thread.currentThread()) == this;
        if (removed && Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
            Tracing.trace("::: Resuming         [id=" + this.id + ", thread=" + Thread.currentThread().getName() + ']' + " at " + Tracing.now());
        }
    }

    synchronized void transfer(Thread thread) {
        if (thread == null) {
            throw new IllegalArgumentException("thread is null");
        }
        if (this.owner != null) {
            Thread current = Thread.currentThread();
            if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
                Tracing.trace("::: Transfer         [id=" + this.id + ", src=" + current.getName() + ", dst=" + thread.getName() + ']' + " at " + Tracing.now());
            }
            if (current == thread) {
                this.getThreadLock().acquire();
            } else if (current == this.owner) {
                this.getThreadLock().release();
            }
            this.owner = thread;
        }
    }

    private ILock getThreadLock() {
        return (ILock)this.threadLock.get();
    }

    public String toString() {
        Thread lastKnownOwner = this.owner;
        return "Lock[id=" + this.id + ", depth=" + this.depth + ", owner=" + (lastKnownOwner == null ? null : lastKnownOwner.getName()) + ", waiting=" + this.waiting + ']';
    }

    public abstract class Access {
        protected Access() {
            this.checkSubclass();
        }

        public void transfer(Thread thread) {
            Lock.this.transfer(thread);
        }

        private void checkSubclass() {
            String name = this.getClass().getName();
            String packageName = name.substring(0, name.lastIndexOf(46) + 1);
            if (!"org.eclipse.emf.transaction.impl.".equals(packageName)) {
                throw new IllegalArgumentException("Illegal subclass");
            }
        }
    }

    class AcquireJob
    extends Job {
        private final Object sync;
        private final Thread thread;
        private final boolean exclusive;
        private ILock ilock;
        private IStatus acquireStatus;
        private boolean aborted;
        private boolean transferred;

        AcquireJob(Thread schedulingThread, boolean exclusive) {
            super(Messages.acquireJobLabel);
            this.sync = new Object();
            this.ilock = jobmgr.newLock();
            this.thread = schedulingThread;
            this.exclusive = exclusive;
            this.setSystem(true);
        }

        /*
         * Exception decompiling
         */
        protected IStatus run(IProgressMonitor monitor) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 13[TRYBLOCK] [17 : 259->262)] java.lang.Throwable
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public final Object getSync() {
            return this.sync;
        }

        ILock getILock() {
            return this.ilock;
        }

        IStatus getAcquireStatus() {
            return this.acquireStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean abort() {
            boolean result;
            Object object = this.sync;
            synchronized (object) {
                result = !this.transferred;
                this.transferred = false;
                this.aborted = true;
                if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
                    Tracing.trace("::: Aborted          [id=" + Lock.this.id + ", thread=" + Thread.currentThread().getName() + ", for=" + this.thread.getName() + ']' + " at " + Tracing.now());
                }
            }
            return result;
        }
    }

    static class AcquireRule
    implements ISchedulingRule {
        AcquireRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

